package com.ejianc.business.rmat.controller.api;

import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.PriceFlowApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/priceFlow/")
@Api(value = "单价流水API接口", tags = {"单价流水API接口"})
public class PriceFlowApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceFlowService service;

    /**
     * @param vo 数据
     * @description: 插入流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author yqls
     * @date: 2022/10/16
     */
    @ApiOperation("插入流水操作")
    @RequestMapping(value = "/insertFlow", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Boolean> insertFlow(@RequestBody PriceFlowApiVO vo) {
        return CommonResponse.success("插入流水数据成功！", service.insertFlow(vo.getFlowList()));
    }

    /**
     * @param vo 数据
     * @description: 删除流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author yqls
     * @date: 2022/10/16
     */
    @ApiOperation("删除流水操作")
    @RequestMapping(value = "/delFlow", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Boolean> delFlow(@RequestBody PriceFlowApiVO vo) {
        return CommonResponse.success("删除流水数据成功！", service.delFlow(vo.getSourceIds(), vo.getBillTypeCode()));
    }
}
