package com.ejianc.business.rmat.controller.api;

import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RmatFlowApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.Map;

@RestController
@RequestMapping("/api/rmatFlow/")
@Api(value = "材料流水API接口", tags = {"材料流水API接口"})
public class RmatFlowApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRmatFlowService service;

    @Autowired
    private IMaterialService materialService;

    /**
     * @param vo 数据
     * @description: 插入流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author yqls
     * @date: 2022/10/16
     */
    @ApiOperation("插入流水操作")
    @RequestMapping(value = "/insertFlow", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Boolean> insertFlow(@RequestBody RmatFlowApiVO vo) {
        return CommonResponse.success("插入流水数据成功！", service.insertFlow(vo.getFlowList()));
    }

    /**z
     * @param vo 数据
     * @description: 删除流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author yqls
     * @date: 2022/10/16
     */
    @ApiOperation("删除流水操作")
    @RequestMapping(value = "/delFlow", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Boolean> delFlow(@RequestBody RmatFlowApiVO vo) {
        return CommonResponse.success("删除流水数据成功！", service.delFlow(vo.getSourceIds(), vo.getBillTypeCode()));
    }

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（验收单、启用单、停用单、退赔单、遗失单、租金计算单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") String contractId,
                                                   @RequestParam(value = "billType", required = false) String billType,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        String msg = materialService.validateContract(contractId, billType, billId, MaterialConstant.保存);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description getLastDate 获取最大单据日期
     * @param params contractId，billType，billId
     */
    @RequestMapping(value = "/getLastDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> getLastDate(@RequestParam(required = false) Map<String, Object> params) {
        Date date = materialService.getLastDate(params);
        return CommonResponse.success("校验成功！", date);
    }
}
