package com.ejianc.business.rmat.service;

import com.ejianc.business.rmat.vo.ExitApplyDetailVO;
import com.ejianc.business.rmat.vo.ExitApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rmat.bean.ExitApplyEntity;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 退场申请单
 * 
 * @author generator
 * 
 */
public interface IExitApplyService extends IBaseService<ExitApplyEntity> {

    /**
     * 推送供方
     *
     * @Param headers:
     * @Param exitEntity:
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @Author2
     **/
    CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitApplyEntity exitApplyEntity);


    /**
     * 导出
     *
     * @Param param: 参数
     * @Param response:
     * @Return void
     * @Author
     **/
    void excelExport(QueryParam param, HttpServletResponse response);


    /**
     * 新增,参照材料库,查询并补录材料库在场和退场数据信息
     *
     * @Param exitApplyVO: 合同id 表体材料库信息
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author
     **/
    List<ExitApplyDetailVO> queryForAddDeatil(String contractId, List<Long> materialIds, Long tenantId);

    /**
     * 修改确认状态
     * @Param exitApplyVO: exitApplyVO
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author
     **/
    CommonResponse<ExitApplyVO> updateConfirmFlag(ExitApplyVO exitApplyVO);

    /**
     * 推送供方删除供方订单
     *
     * @Param headers:
     * @Param exitEntity:
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @Author2
     **/
    CommonResponse<String> pushDelete(Map<String, String> headers, ExitApplyEntity exitApplyEntity);

}
