package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.vo.CoordinationSetVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.CoordinationSetMapper;
import com.ejianc.business.rmat.bean.CoordinationSetEntity;
import com.ejianc.business.rmat.service.ICoordinationSetService;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 周转材协同设置
 *
 * @author generator
 *
 */
@Service("coordinationSetService")
public class CoordinationSetServiceImpl extends BaseServiceImpl<CoordinationSetMapper, CoordinationSetEntity> implements ICoordinationSetService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CoordinationSetVO saveOrUpdate(CoordinationSetVO saveOrUpdateVO) {
        CoordinationSetVO coordinationSetVO = new CoordinationSetVO();
        LambdaQueryWrapper<CoordinationSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CoordinationSetEntity::getOrgId, saveOrUpdateVO.getOrgId());
        List<CoordinationSetEntity> entities = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entities)) {
            // 修改
            LambdaUpdateWrapper<CoordinationSetEntity> updateWrapper=new LambdaUpdateWrapper<>();
            updateWrapper.set(saveOrUpdateVO.getSupplyStatus()!=null,CoordinationSetEntity::getSupplyStatus, saveOrUpdateVO.getSupplyStatus());
            updateWrapper.set(saveOrUpdateVO.getMandatoryStatus() != null, CoordinationSetEntity::getMandatoryStatus, saveOrUpdateVO.getMandatoryStatus());
            updateWrapper.eq(CoordinationSetEntity::getOrgId, saveOrUpdateVO.getOrgId());
            super.update(updateWrapper);
            for (CoordinationSetEntity coordinationSetEntity : entities) {
                coordinationSetVO = BeanMapper.map(coordinationSetEntity, CoordinationSetVO.class);
            }
        }else {
            // 新增
            CoordinationSetEntity coordinationSetEntity = BeanMapper.map(saveOrUpdateVO, CoordinationSetEntity.class);
            coordinationSetEntity.setOrgInnerCode(iOrgApi.detailById(InvocationInfoProxy.getOrgId()).getData().getInnerCode());
            super.saveOrUpdate(coordinationSetEntity);
            coordinationSetVO = BeanMapper.map(coordinationSetEntity, CoordinationSetVO.class);
        }
        return coordinationSetVO;
    }

    @Override
    public Boolean querySupplyByOrgId(Long orgId) {
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(orgId);
        if (orgVO != null) {
            String[] orgInnerCode = (orgVO.getData().getInnerCode()).split("\\|");
            List<CoordinationSetEntity> list = this.list(new QueryWrapper<CoordinationSetEntity>().in("org_id",orgInnerCode).eq("supply_status",0));
            if (CollectionUtils.isNotEmpty(list)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean queryMandatoryByOrgId(Long orgId) {
        logger.info("orgId------" + JSONObject.toJSONString(orgId));
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(orgId);
        logger.info("orgVO------" + JSONObject.toJSONString(orgVO));
        if (orgVO!=null) {
            String[] orgInnerCode = (orgVO.getData().getInnerCode()).split("\\|");
            List<CoordinationSetEntity> list = this.list(new QueryWrapper<CoordinationSetEntity>().in("org_id",orgInnerCode).eq("mandatory_status",0));
            if (CollectionUtils.isNotEmpty(list)) {
                return true;
            }
        }
        return false;
    }
}
