package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.PriceFlowMapper;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.util.CmContractUtil;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 单价流水表
 *
 * @author generator
 *
 */
@Service("priceFlowService")
public class PriceFlowServiceImpl extends BaseServiceImpl<PriceFlowMapper, PriceFlowEntity> implements IPriceFlowService{

    @Autowired
    private CmContractUtil contUtil;

    @Override
    public Boolean insertFlow(List<PriceFlowVO> vos) {
        List<PriceFlowVO> addList = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        // 查询NC合同详情
        Map<Long, CmContractInfoVO> infoMap = contUtil.getInfoMap(vos.get(0).getContractId());
        for(PriceFlowVO vo : vos){
            vo.setId(vo.getSourceDetailId());// 默认主键为子表主键
            // 根据NC合同详情赋值
            contUtil.getInfoVO(infoMap, vo.getMaterialId(), vo.getMaterialTypeId(), vo);
            if(!"del".equals(vo.getRowState())){
                addList.add(vo);
            } else {
                delIds.add(vo.getId());
            }
        }
        if(CollectionUtils.isNotEmpty(addList)){
            List<PriceFlowEntity> list = BeanMapper.mapList(addList, PriceFlowEntity.class);
            super.saveOrUpdateBatch(list);
        }
        if(CollectionUtils.isNotEmpty(delIds)){
            baseMapper.deleteByIds(delIds);
        }
        return true;
    }

    @Override
    public Boolean insertStopFlow(StopEntity entity, String billTypeCode) {
        List<PriceFlowVO> flowList = new ArrayList<>();
        List<StopDetailEntity> detailList = entity.getDetailList();
        for(StopDetailEntity detail : detailList){
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setProjectId(entity.getProjectId());// 项目
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractName(entity.getContractName());
            vo.setBillDate(entity.getStopTime());// 业务日期
            vo.setEffectiveDate(new Date());// 生效日期默认当前日期
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.停用.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));// 停用
            vo.setDetailDate(detail.getStopTime());// 明细业务日期
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setPrice(detail.getStopPrice());
            vo.setTaxPrice(detail.getTaxPrice());
            vo.setTaxRate(detail.getTaxRate());
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertStartFlow(StartEntity entity, String billTypeCode) {
        List<PriceFlowVO> flowList = new ArrayList<>();
        List<StartDetailEntity> detailList = entity.getDetailList();
        for(StartDetailEntity detail : detailList){
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setProjectId(entity.getProjectId());// 项目
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractName(entity.getContractName());
            vo.setBillDate(entity.getStartTime());// 业务日期
            vo.setEffectiveDate(new Date());// 生效日期默认当前日期
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.启用.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            vo.setDetailDate(detail.getStartTime());// 明细业务日期
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setPrice(detail.getStartPrice());
            vo.setTaxPrice(detail.getTaxPrice());
            vo.setTaxRate(detail.getTaxRate());
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, String billTypeCode) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return true;
        }
        baseMapper.deleteBySourceIds(sourceIds, billTypeCode);
        return true;
    }

}
