package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.IStopService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("stop")
public class StopBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(getClass());
	@Autowired
	private IRmatFlowService rmatFlowService;
	@Autowired
	private IStopService service;
	@Autowired
	private IPriceFlowService priceFlowService;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IMaterialService materialService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		StopEntity entity = service.selectById(billId);
		// 推送租赁流水生效
		if(!rmatFlowService.insertStopFlow(entity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}

		// 推送单价流水生效
		if (!priceFlowService.insertStopFlow(entity, billTypeCode)) {
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// 合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		StopEntity entity = service.selectById(billId);
		validateTime(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		StopEntity entity = service.selectById(billId);
		// 删除单价流水
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		if (!priceFlowService.delFlow(ids, billTypeCode)) {
			return CommonResponse.error("撤回失败，单据推送流水失败！");
		}
		logger.info("删除单价流水成功--" + billId+billTypeCode);
		// 推送租赁流水未生效
		if(!rmatFlowService.insertStopFlow(entity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("撤回失败，单据推送流水失败！");
		}
		return CommonResponse.success();
	}

	private String validateTime(StopEntity entity) {
		Map<String, Object> params = new HashMap<>();
		params.put("contractId", entity.getContractId());
		params.put("billType", MaterialConstant.停用单);
		params.put("queryType", "all");
		params.put("billId", entity.getId());
		Date lastDate = materialService.getLastDate(params);
		Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);
		if (lastDate == null) {
			return "未获取最大单据日期！";
		}
		if(ValidateUtil.compareDate(entity.getStopTime(), lastDate, maxTimeMap,entity.getCreateTime())){
			throw new BusinessException(DateUtil.formatDate(entity.getStopTime())
					+ "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许撤回!");
		}
		return "校验通过！";
	}

}
