package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.TransferEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.service.ITransferService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("transfer") 
public class TransferBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ITransferService service;
	@Autowired
	private ITransferFlowService flowService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TransferEntity entity = service.selectById(billId);
		// 推送流水未生效
		if(Boolean.FALSE.equals(flowService.insertTransferFlow(entity, entity.getAllotOutId()==null?TransFlowTypeEnum.调入.getFlowType():TransFlowTypeEnum.调出.getFlowType(), RmatCommonConsts.YES))){
			return CommonResponse.error("单据推送流水失败！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TransferEntity entity = service.selectById(billId);
		List<Long> ids = new ArrayList<>();
		ids.add(entity.getId());
		// 推送流水未生效
		if (entity.getAllotOutId() == null) {
			flowService.delete(ids,TransFlowTypeEnum.调入.getFlowType());
		}else {
			if(Boolean.FALSE.equals(flowService.insertTransferFlow(entity,TransFlowTypeEnum.调出.getFlowType(), RmatCommonConsts.TWO))){
				return CommonResponse.error("单据推送流水失败！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
