package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.bean.ExitDetailEntity;
import com.ejianc.business.rmat.bean.ExitSupplierEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.business.rmat.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.ExitMapper;
import com.ejianc.business.rmat.bean.ExitEntity;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 退场单
 * 
 * @author generator
 * 
 */
@Service("exitService")
public class ExitServiceImpl extends BaseServiceImpl<ExitMapper, ExitEntity> implements IExitService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${openApi.wjExitUrl}")
    private String wjExitUrl;

    @Value("${openApi.wjExitDeleteUrl}")
    private String wjExitDeleteUrl;


    private static final String WJ_WZXT_EXIT = "WJHN_WZXT_EXIT";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IExitApplyService exitApplyService;

    @Autowired
    private IExitSupplierService exitSupplierService;

    @Autowired
    private ITransferFlowService transferFlowService;

    @Autowired
    private IRmatFlowService flowService;


    @Override
    public ExitVO saveOrUpdate(ExitVO saveorUpdateVO) {
        StringBuffer materialName = new StringBuffer();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(saveorUpdateVO.getExitDetail())){
            saveorUpdateVO.getExitDetail().forEach(vo -> {
                materialName.append(vo.getMaterialName()+",");
            });
            String materialNames = materialName.substring(0, materialName.length() - 1);
            saveorUpdateVO.setMaterialName(materialNames);
        }
        ExitEntity entity = BeanMapper.map(saveorUpdateVO, ExitEntity.class);
        entity.setConfirmFlag(0);//待确认
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WJ_WZXT_EXIT, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //删除的明细
        List<ExitSupplierEntity> list = new ArrayList<>();
        for(ExitDetailEntity exitDetailEntity : entity.getExitDetail()){
            List<ExitSupplierEntity> entityList = BeanMapper.mapList(exitDetailEntity.getExitSupplierList(), ExitSupplierEntity.class);
            for (ExitSupplierEntity de : entityList) {
                if (de.getId()!= null){
                    list.add(de);
                }
            }
        }

        List<Long> ids = list.stream().map(ExitSupplierEntity::getId).collect(Collectors.toList());
        super.saveOrUpdate(entity, false);
        //保存劳务队
        saveDealSupplier(entity);
        ExitApplyEntity exitApplyEntity = exitApplyService.selectById(entity.getApplyId());
        ExitVO resVo =  BeanMapper.map(entity, ExitVO.class);
        if(exitApplyEntity != null){
            resVo.setApplyState(exitApplyEntity.getApplyState());
        }
        //新保存后rowState为空重新赋值“add"
        for(ExitDetailEntity exitDetailEntity : entity.getExitDetail()){
            for (ExitSupplierEntity n : exitDetailEntity.getExitSupplierList()) {
                if (!ids.contains(n.getId())){
                    n.setRowState("add");
                    list.add(n);
                }
            }
        }
        entity.setExitSupplierList(list);
        //校验劳务队数量
        for(ExitDetailEntity exitDetailEntity : entity.getExitDetail()){
            BigDecimal realOutNum = new BigDecimal(0);// 实物退场数量
            BigDecimal rentOutNum = new BigDecimal(0); // 计租退场数量
            for(ExitSupplierEntity exitSupplierEntity : exitDetailEntity.getExitSupplierList()){
                if(!("del").equals(exitSupplierEntity.getRowState())){
                    realOutNum = ComputeUtil.safeAdd(realOutNum, exitSupplierEntity.getRealOutNum());
                    rentOutNum = ComputeUtil.safeAdd(rentOutNum, exitSupplierEntity.getRentOutNum());
                }
            }
            if (realOutNum.compareTo(exitDetailEntity.getRealOutNum())> 0){
                throw new BusinessException("请检查，劳务队分配【实物退场数量】总和，超过明细【退场数量(实物)】");
            }
            if (rentOutNum.compareTo(exitDetailEntity.getRentOutNum())> 0){
                throw new BusinessException("请检查，劳务队分配【计租退场数量】总和，超过明细【退场数量(计租)】");
            }
        }
        // 推送流水未生效
        if(!flowService.insertExitFlow(entity, BillTypeEnum.退场单.getCode(), RmatCommonConsts.NO)){
            throw new BusinessException("单据推送台账流水失败！");
        }

        if(CollectionUtils.isNotEmpty(entity.getExitSupplierList())){
            //推送台账流水
            if(!transferFlowService.insertExitFlow(entity, TransFlowTypeEnum.退场.getFlowType(), RmatCommonConsts.NO)){
                throw new BusinessException("单据推送台账流水失败！");
            }
        }
        return  queryDetail(entity.getId());
    }

    @Override
    public List<ExitSupplierVO> querySupplier(Long exitId, Long exitDetailId) {
        LambdaQueryWrapper<ExitSupplierEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExitSupplierEntity::getExitId, exitId);
        queryWrapper.eq(null != exitDetailId, ExitSupplierEntity::getExitDetailId, exitDetailId);
        List<ExitSupplierEntity> list = exitSupplierService.list(queryWrapper);
        return CollectionUtils.isNotEmpty(list) ? BeanMapper.mapList(list, ExitSupplierVO.class) : null;
    }


    @Override
    public ExitVO queryDetail(Long id) {
        ExitEntity entity = selectById(id);
        List<ExitDetailEntity> detailList = entity.getExitDetail();
        for (ExitDetailEntity detailEntity : detailList) {
            LambdaQueryWrapper<ExitSupplierEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ExitSupplierEntity::getExitDetailId, detailEntity.getId());
            List<ExitSupplierEntity> supplierEntityList = exitSupplierService.list(queryWrapper);
            detailEntity.setExitSupplierList(supplierEntityList);
        }
         return BeanMapper.map(entity, ExitVO.class);
    }

    private void saveDealSupplier(ExitEntity entity) {
        for (ExitDetailEntity detailEntity : entity.getExitDetail()) {
            List<ExitSupplierEntity> supplierEntityList = detailEntity.getExitSupplierList();
            if (CollectionUtils.isNotEmpty(supplierEntityList)) {
                List<ExitSupplierEntity> insertList = new ArrayList<>();
                List<Long> delPkList = new ArrayList<>();
                for (ExitSupplierEntity exitSupplierEntity : supplierEntityList) {
                    if ("del".equals(exitSupplierEntity.getRowState())) {
                        delPkList.add(exitSupplierEntity.getId());
                    } else {
                        exitSupplierEntity.setExitId(entity.getId());
                        exitSupplierEntity.setExitDetailId(detailEntity.getId());
                        insertList.add(exitSupplierEntity);
                    }
                }
                if(CollectionUtils.isNotEmpty(insertList)){
                    exitSupplierService.saveOrUpdateBatch(insertList);
                }
                if(CollectionUtils.isNotEmpty(delPkList)){
                    exitSupplierService.removeByIds(delPkList);
                }
            }
        }

    }

    @Override
    public CommonResponse<ExitVO> updateConfirmFlag(ExitVO exitVO) {
        ExitEntity entity = super.getById(exitVO.getId());
        entity.setConfirmFlag(exitVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitVO.getConfirmerId());
        entity.setConfirmerName(exitVO.getConfirmerName());
        entity.setConfirmNote(exitVO.getConfirmNote());
        String msg = "确认";
        //拒绝单据改为自由态
        if (2 == exitVO.getConfirmFlag()) {
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            msg = "拒绝";
        }
        super.saveOrUpdate(entity, false);
        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(entity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"cscec5bhn-wzxt-frontend/#/exit/card?id="+entity.getId();
        String subject = "您的退场单【"+entity.getProjectName()+"--"+entity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+entity.getSupplierName()+"】"+msg+"。";
        String content = "您的退场单【"+entity.getProjectName()+"--"+entity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+entity.getSupplierName()+"】"+msg+"。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(entity.getTenantId()),entity);
        return CommonResponse.success();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,ExitEntity entity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }

        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams  = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "供方平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", wjyPath+"cscec5bhn-wzxt-mobile/#/walkoffIndex/details?id="+entity.getId()+"&userid={userid}");
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }


    /**
     * 推送供方订单
     *
     * @param headers
     *
     */
    @Override
    public CommonResponse<String>  pushConfirmEntity(Map<String, String> headers, ExitEntity exitEntity){
        String url = wjExitUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(exitEntity.getId()));// 主键
        purchase.setApplyId(exitEntity.getApplyId());
        purchase.setOrgId(exitEntity.getParentOrgSourceId());;// 组织主键   传来源组织主键
        purchase.setOrgName(exitEntity.getOrgName());
        purchase.setConfirmFlag(0);
        purchase.setProjectId(exitEntity.getProjectSourceId());// 项目主键    传来源项目主键
        purchase.setProjectName(exitEntity.getProjectName());
        purchase.setBillCode(exitEntity.getBillCode());// 编码
        purchase.setSupplierId(exitEntity.getSupplierSourceId());// 供应商主键     传来源供应商主键
        purchase.setSupplierName(exitEntity.getSupplierName());
        purchase.setContractId(exitEntity.getContractId());// 合同主键
        purchase.setContractName(exitEntity.getContractName());
        purchase.setContractCode(exitEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setExitDate(formatter.format(exitEntity.getExitDate()));
        purchase.setExitNote(exitEntity.getExitNote());
        purchase.setLinkName(exitEntity.getLinkName());
        purchase.setLinkTelephone(exitEntity.getLinkTelephone());
        purchase.setPkCreator("hnxpt");
        purchase.setSysmark("rmat");
        purchase.setCreatorName("五局新平台");
        purchase.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));
        CommonResponse<List<AttachmentVO>> sceneurRes = attachmentApi.queryListBySourceId(exitEntity.getId(),"BT210816000000006","imgUpload2",null);
        if(sceneurRes.isSuccess()){
            List<String> sceneurlList = new ArrayList<>();
            sceneurlList.addAll(sceneurRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(sceneurlList)){
                purchase.setSceneurl(String.join(",", sceneurlList));
            }
        }

        CommonResponse<List<AttachmentVO>> czsignurlRes = attachmentApi.queryListBySourceId(exitEntity.getId(),"BT210816000000006","imgUpload3",null);
        List<String> czsignurllList = new ArrayList<>();
        if(czsignurlRes.isSuccess()){
            czsignurllList.addAll(czsignurlRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(czsignurllList)){
                purchase.setCzsignurl(String.join(",", czsignurllList));
            }
        }

        CommonResponse<List<AttachmentVO>> jlsingurlRes = attachmentApi.queryListBySourceId(exitEntity.getId(),"BT210816000000006","imgUpload4",null);
        List<String> jlsingurlList = new ArrayList<>();
        if(jlsingurlRes.isSuccess()){
            jlsingurlList.addAll(jlsingurlRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if(CollectionUtils.isNotEmpty(jlsingurlList)){
                purchase.setJlsingurl(String.join(",", jlsingurlList));
            }
        }

        if(CollectionUtils.isNotEmpty(exitEntity.getExitDetail())){
            List<ExitDetailGFVO> list = new ArrayList<>();
            exitEntity.getExitDetail().forEach(e -> {
                //非末级才需要同步
                ExitDetailGFVO vo = new ExitDetailGFVO();
                vo.setId(String.valueOf(e.getId()));// 子表主键
                vo.setExitId(String.valueOf(exitEntity.getId()));// 主表主键
                vo.setMaterialId(e.getMaterialSourceId());// 材料主键 传来源主键
                vo.setMaterialCode(e.getMaterialCode());// 材料编码"
                vo.setMaterialTypeName(e.getMaterialTypeName());
                vo.setMaterialName(e.getMaterialName());// 材料名称
                vo.setSpec(e.getSpec());// 规格型号
                vo.setUnit(e.getUnitName());// 单位
                vo.setStopDate(formatter.format(e.getStopDate()));
                vo.setDef1(e.getDef1());
                vo.setDef2(e.getDef2());
                vo.setDef3(e.getDef3());
                vo.setDef4(e.getDef4());
                vo.setDef5(e.getDef5());
                vo.setMemo(e.getMemo());
                vo.setApplyNums(e.getApplyNums()==null? BigDecimal.ZERO:e.getApplyNums());
                vo.setExitNums(e.getExitNums()==null?BigDecimal.ZERO:e.getExitNums());
                vo.setExitNumsSum(e.getExitNumsSum()==null?BigDecimal.ZERO:e.getExitNumsSum());
                vo.setRentUnitName(e.getRentUnitName());
                vo.setRentNum(e.getRentNum()==null?BigDecimal.ZERO:e.getRentNum());
                vo.setRentExitNum(e.getRentExitNum()==null?BigDecimal.ZERO:e.getRentExitNum());
                vo.setRealExitNum(e.getRealExitNum()==null?BigDecimal.ZERO:e.getRealExitNum());
                vo.setRentOutNum(e.getRentOutNum()==null?BigDecimal.ZERO:e.getRentOutNum());
                vo.setRealOutNum(e.getRealOutNum()==null?BigDecimal.ZERO:e.getRealOutNum());

                list.add(vo);
            });
            purchase.setExitDetailList(list);
        }

        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方订单异常!");
        }
    }


    @Override
    public CommonResponse<String>  pushDelete(Map<String, String> headers, ExitEntity exitEntity){
        //todo 需换成删除接口
        String url = wjExitDeleteUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(exitEntity.getId()));// 主键

        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if("200".equals(jsonBack.getString("code"))){
                //调用同步方法成功
                return CommonResponse.success();
            }else{
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("删除供方退场单异常!");
        }
    }


    @Override
    public List<ExitReportVO> queryExitReport(QueryWrapper queryWrapper) {
        return baseMapper.queryExitReport(queryWrapper);
    }

    @Override
    public List<ExitReportVO> queryZlReports(QueryWrapper queryWrapper,Long projectId,Long supplierId) {
        return baseMapper.queryZlReport(queryWrapper,projectId,supplierId);
    }

    @Override
    public List<ExitReportVO> queryCgReports(QueryWrapper queryWrapper, Long projectId) {
        return baseMapper.queryCgReports(queryWrapper,projectId);
    }
}
