package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.api.IRmatFlowApi;
import com.ejianc.business.rmat.bean.PeriodDetailEntity;
import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.PeriodVO;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.PeriodMapper;
import com.ejianc.business.rmat.bean.PeriodEntity;
import com.ejianc.business.rmat.service.IPeriodService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 期初录入单
 *
 * @author generator
 *
 */
@Service("periodService")
public class PeriodServiceImpl extends BaseServiceImpl<PeriodMapper, PeriodEntity> implements IPeriodService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IPriceFlowService priceFlowService;

    private static final String BILL_CODE = "RMAT_PERIOD";

    @Override
    public PeriodVO saveOrUpdate(PeriodVO periodVO) {
        LambdaQueryWrapper<RmatFlowEntity> query = new LambdaQueryWrapper<>();
        query.ne(null != periodVO.getId(), RmatFlowEntity::getSourceId, periodVO.getId());
        query.eq(RmatFlowEntity::getProjectId, periodVO.getProjectId());
        query.eq(RmatFlowEntity::getContractId, periodVO.getContractId());
        if (rmatFlowService.count(query) > 0) {
            throw new BusinessException("同一项目的同一合同已存在进场数据，不允许做期初录入！");
        }
        LambdaQueryWrapper<PeriodEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(null != periodVO.getId(), PeriodEntity::getId, periodVO.getId());
        queryWrapper.eq(PeriodEntity::getProjectId, periodVO.getProjectId());
        queryWrapper.eq(PeriodEntity::getContractId, periodVO.getContractId());
        if (count(queryWrapper) > 0) {
            throw new BusinessException("同一项目的同一合同已做过期初录入，不能多次制单！");
        }
        PeriodEntity entity = BeanMapper.map(periodVO, PeriodEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);

        insertFlow(entity, "BT230606000000001", RmatCommonConsts.NO);

        return BeanMapper.map(entity, PeriodVO.class);
    }

    @Override
    public Boolean insertPriceFlow(PeriodEntity entity, String billTypeCode) {
        List<PriceFlowVO> flowList = new ArrayList<>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for(PeriodDetailEntity detail : detailList){
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setProjectId(entity.getProjectId());// 项目
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractName(entity.getContractName());
            vo.setBillDate(new Date());// 业务日期
            vo.setEffectiveDate(new Date());// 生效日期默认当前日期
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.验收.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            vo.setDetailDate(detail.getRentDate());// 明细业务日期
            vo.setInfoId(detail.getNcDetailId());// 合同清单主键
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setPrice(detail.getNprice());
            vo.setTaxPrice(detail.getNtaxprice());
            vo.setTaxRate(detail.getTaxrate());
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return  priceFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean insertFlow(PeriodEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for(PeriodDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setProjectId(entity.getProjectId());// 项目
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));// 经办人
            vo.setEmployeeName(InvocationInfoProxy.getUsercode());
            vo.setBillDate(new Date());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.验收.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            vo.setDetailDate(detail.getRentDate());// 明细业务日期
            vo.setInfoId(detail.getNcDetailId());// 合同清单主键
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitId());// 档案单位
            vo.setUnitName(detail.getUnit());
            vo.setNum(detail.getCheckNumsSum());// 档案数量
            vo.setRealUnitId(detail.getRealUnitId());// 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());// 实物数量
            vo.setRealTransScale(detail.getRealTransScale());// 实物转换系数
            vo.setRentUnitId(detail.getRentUnitId());// 计租单位
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());// 计租数量
            vo.setRentTransScale(detail.getRentTransScale());// 计租转换系数
            vo.setSignRowType(detail.getSignRowType());// 合同签订方式
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return rmatFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> ids) {
        return rmatFlowService.delFlow(ids, BillTypeEnum.验收单.getCode());
    }

    @Override
    public void delete(List<PeriodVO> vos) {
        List<Long> idList = vos.stream().map(PeriodVO::getId).collect(Collectors.toList());
        delFlow(idList);
        removeByIds(idList,true);
    }
}
