package com.ejianc.business.rmat.util;

import org.springframework.stereotype.Component;

import java.util.List;

@Component("assistPageUtil")
public class PageUtil<T> {

    /**
     * List转Page
     * @param list 所有记录
     * @param current 当前页，默认 1
     * @param size 当前分页总页数
     * @param <T> 泛型
     * @return
     */
    public static <T> List<T> listToPage(List<T> list, int current, int size) {
        current = (current - 1) * size;// 每页的起始索引
        Integer total = list.size();// 记录总数
        if (current + size > total) {
            return list.subList(current, total);
        } else {
            return list.subList(current, total > size ? current + size : current + total);
        }
    }
}
