/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.CalculateOtherEntity;
import com.ejianc.business.rmat.bean.CalculateScrapEntity;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.bean.RestituteMaintainEntity;
import com.ejianc.business.rmat.bean.RestituteOtherEntity;
import com.ejianc.business.rmat.bean.RestituteScrapEntity;
import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.business.sync.api.ICalculateSyncApi;
import com.ejianc.business.sync.vo.CalculateDetailVO;
import com.ejianc.business.sync.vo.CalculateSettleVO;
import com.ejianc.business.sync.vo.CalculateVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="calculate")
public class CalculateBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICalculateService service;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private ICalculateSyncApi calculateSyncApi;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IMaterialService materialService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CalculateEntity entity = (CalculateEntity)((Object)this.service.selectById(billId));
        if (StringUtils.isBlank((CharSequence)entity.getPeriodFlag()) || !"1".equals(entity.getPeriodFlag())) {
            this.writeForNc(entity);
        }
        this.writeSettleFlag(entity, 1);
        return CommonResponse.success();
    }

    private void writeForNc(CalculateEntity entity) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        CommonResponse commonResponse = this.cmContractInfoApi.queryLeaseContractInfoById(entity.getContractId());
        HashMap<String, CmContractInfoVO> contInfoMap = new HashMap<String, CmContractInfoVO>();
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
            for (CmContractInfoVO infoVO : (List)commonResponse.getData()) {
                contInfoMap.put(infoVO.getPkContractinfo(), infoVO);
                rateMap.put(infoVO.getPkAmountlist(), infoVO.getSl());
            }
        }
        HashMap<Object, CalculateVO> calcVOMap = new HashMap<Object, CalculateVO>();
        if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
            for (CalculateDailyEntity dailyEntity : entity.getDailyList()) {
                Iterator<CalculateScrapEntity> fl = ((CmContractInfoVO)contInfoMap.get(dailyEntity.getInfoId())).getPkAmountlist();
                CalculateVO calculateVO = null;
                List<CalculateDetailVO> detailVOS = new ArrayList();
                if (!calcVOMap.containsKey(fl)) {
                    calculateVO = new CalculateVO();
                    calculateVO.setPkId(entity.getId() + "@" + (String)((Object)fl));
                    calculateVO.setDbegindate(sdf.format(entity.getRentDate()));
                    calculateVO.setHtflh((String)((Object)fl));
                    calculateVO.setNflag(Integer.valueOf(0));
                    calculateVO.setPkContract(entity.getContractId());
                    calculateVO.setVurl(this.getWebSite(entity.getId()));
                    calculateVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                } else {
                    calculateVO = (CalculateVO)calcVOMap.get(fl);
                    detailVOS = calculateVO.getDetailList();
                }
                CalculateDetailVO detailVO = new CalculateDetailVO();
                detailVO.setPkId(entity.getId() + "@" + (String)((Object)fl));
                detailVO.setPkSettleId(String.valueOf(dailyEntity.getId()));
                detailVO.setHtflh(fl);
                detailVO.setNstopnum("1".equals(dailyEntity.getUseStatus()) ? dailyEntity.getRentNum() : null);
                detailVO.setNhireworknum(dailyEntity.getRentNum());
                detailVO.setNhiredays(BigDecimal.valueOf(dailyEntity.getRentDayDate().intValue()));
                detailVO.setDbegindate(sdf.format(dailyEntity.getStartDate()));
                detailVO.setDenddate(sdf.format(dailyEntity.getEndDate()));
                detailVO.setPkInvcl(((MaterialCategoryVO)this.materialApi.queryCategoryById(dailyEntity.getMaterialTypeId()).getData()).getSourceId());
                detailVO.setNsettlenum(dailyEntity.getRentNum());
                detailVO.setNinnum(dailyEntity.getRentNum());
                detailVO.setNoriginhireprice(dailyEntity.getUnitPrice());
                detailVO.setNoriginhiremny(dailyEntity.getDailyRentMny());
                detailVO.setNwastenum(null);
                detailVO.setNoutnum(null);
                detailVO.setPkContract(entity.getContractId());
                detailVO.setPkContractB(dailyEntity.getInfoId());
                detailVO.setPkInvbasdoc(null == dailyEntity.getMaterialId() ? this.getLastInMatByCty(dailyEntity.getMaterialTypeId(), entity.getProjectId(), entity.getContractId()) : dailyEntity.getMaterialSourceId());
                detailVO.setPkMeasdoc(dailyEntity.getUnitId());
                detailVO.setPkMeasdoc1(dailyEntity.getRealUnitId());
                detailVO.setNflag(Integer.valueOf(0));
                detailVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                detailVOS.add(detailVO);
                calculateVO.setDetailList(detailVOS);
                calcVOMap.put(fl, calculateVO);
            }
        }
        CalculateVO calculateVO = (CalculateVO)((Map.Entry)calcVOMap.entrySet().stream().findFirst().get()).getValue();
        CalculateSettleVO settleVO = null;
        if (CollectionUtils.isNotEmpty(entity.getScrapList())) {
            settleVO = new CalculateSettleVO();
            settleVO.setPkId(calculateVO.getPkId());
            settleVO.setPkSettleId(settleVO.getPkId());
            settleVO.setNflag(Integer.valueOf(0));
            settleVO.setPkContract(entity.getContractId());
            settleVO.setHtflh(calculateVO.getHtflh());
            settleVO.setSl((BigDecimal)rateMap.get(calculateVO.getHtflh()));
            settleVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            for (CalculateScrapEntity scrapEntity : entity.getScrapList()) {
                RestituteEntity restituteEntity = (RestituteEntity)((Object)this.restituteService.selectById(scrapEntity.getSourceId()));
                if (CollectionUtils.isNotEmpty(restituteEntity.getRestituteDetailList())) {
                    for (RestituteScrapEntity restituteScrapEntity : restituteEntity.getRestituteDetailList()) {
                        settleVO.setNoriginwastemny(ComputeUtil.safeAdd((BigDecimal)settleVO.getNoriginwastemny(), (BigDecimal)restituteScrapEntity.getDamageMny()));
                    }
                }
                if (CollectionUtils.isNotEmpty(restituteEntity.getRestituteMaintainList())) {
                    for (RestituteMaintainEntity maintainEntity : restituteEntity.getRestituteMaintainList()) {
                        settleVO.setNoriginrepairapmny(ComputeUtil.safeAdd((BigDecimal)settleVO.getNoriginrepairapmny(), (BigDecimal)maintainEntity.getMaintainMny()));
                        settleVO.setNoriginrepairiamny(ComputeUtil.safeAdd((BigDecimal)settleVO.getNoriginotheriamny(), (BigDecimal)maintainEntity.getMaintainMny()));
                    }
                }
                if (!CollectionUtils.isNotEmpty(restituteEntity.getOtherList())) continue;
                for (RestituteOtherEntity otherEntity : restituteEntity.getOtherList()) {
                    settleVO.setNoriginotheriamny(ComputeUtil.safeAdd((BigDecimal)settleVO.getNoriginotheriamny(), (BigDecimal)otherEntity.getCurrentAmount()));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getOtherList())) {
            if (null == settleVO) {
                settleVO = new CalculateSettleVO();
                settleVO.setPkId(calculateVO.getPkId());
                settleVO.setPkSettleId(settleVO.getPkId());
                settleVO.setNflag(Integer.valueOf(0));
                settleVO.setPkContract(entity.getContractId());
                settleVO.setHtflh(calculateVO.getHtflh());
                settleVO.setSl((BigDecimal)rateMap.get(calculateVO.getHtflh()));
                settleVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            }
            if (CollectionUtils.isNotEmpty(entity.getOtherList())) {
                for (CalculateOtherEntity otherEntity : entity.getOtherList()) {
                    settleVO.setNoriginotheriamny(ComputeUtil.safeAdd((BigDecimal)settleVO.getNoriginotheriamny(), (BigDecimal)otherEntity.getMny()));
                }
            }
        }
        if (null != settleVO) {
            calculateVO.setSettleList(Arrays.asList(settleVO));
            calcVOMap.put(calculateVO.getHtflh(), calculateVO);
        }
        this.logger.error(JSONObject.toJSONString(new ArrayList(calcVOMap.values())));
        CommonResponse response = this.calculateSyncApi.sync(new ArrayList(calcVOMap.values()));
        if (!response.isSuccess()) {
            this.logger.error(response.getMsg());
            throw new BusinessException("\u63a8\u9001NC\u4e2d\u95f4\u8868\u5931\u8d25");
        }
    }

    private String getWebSite(Long id) {
        Long userid = InvocationInfoProxy.getUserid();
        String targeturl = this.BASE_HOST + "cscec5b-rmat-frontend/#/calculate/autoCard?id=" + id;
        this.logger.info("--->> targeturl: " + targeturl);
        try {
            targeturl = URLEncoder.encode(targeturl, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage());
        }
        String webSite = this.BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
        this.logger.info("--->> \u751f\u6210\u79df\u91d1\u8ba1\u7b97\u5355\u8df3\u8f6c\u5730\u5740: " + webSite);
        return webSite;
    }

    private String getLastInMatByCty(Long categoryId, Long projectId, String pkContract) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RmatFlowEntity::getEffectiveState, (Object)1);
        queryWrapper.eq(RmatFlowEntity::getFlowType, (Object)1);
        queryWrapper.eq(RmatFlowEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(RmatFlowEntity::getContractId, (Object)pkContract);
        queryWrapper.eq(RmatFlowEntity::getMaterialTypeId, (Object)categoryId);
        queryWrapper.orderByDesc(RmatFlowEntity::getEffectiveDate);
        List list = this.rmatFlowService.list((Wrapper)queryWrapper);
        return CollectionUtils.isNotEmpty((Collection)list) ? ((RmatFlowEntity)((Object)list.get(0))).getMaterialSourceId() : null;
    }

    private void writeSettleFlag(CalculateEntity entity, Integer settleFlag) {
        List<CalculateScrapEntity> scrapList = entity.getScrapList();
        List ids = scrapList.stream().map(CalculateScrapEntity::getSourceId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(ids)) {
            LambdaUpdateWrapper ew = new LambdaUpdateWrapper();
            ew.set(RestituteEntity::getSettleFlag, (Object)settleFlag);
            ew.in(BaseEntity::getId, ids);
            this.restituteService.update((Wrapper)ew);
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.validateTime((CalculateEntity)((Object)this.service.selectById(billId)));
        CommonResponse listCommonResponse = this.calculateSyncApi.settleFlagSync(null, billId);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            Boolean isSettle = false;
            for (CalculateVO calculateVO : (List)listCommonResponse.getData()) {
                if (1 != calculateVO.getNflag()) continue;
                isSettle = true;
                break;
            }
            if (isSettle.booleanValue()) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)billId);
                updateWrapper.set(CalculateEntity::getNcSettleFlag, (Object)1);
                this.service.update((Wrapper)updateWrapper);
                return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u5728NC\u7ed3\u7b97\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CalculateEntity entity = (CalculateEntity)((Object)this.service.selectById(billId));
        CommonResponse response = this.calculateSyncApi.delSync(billId);
        if (!response.isSuccess()) {
            this.logger.error(response.getMsg());
            throw new BusinessException("\u5220\u9664NC\u4e2d\u95f4\u8868\u5931\u8d25," + response.getMsg());
        }
        this.writeSettleFlag(entity, 0);
        if (1 == entity.getNcSettleFlag()) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(CalculateEntity::getNcSettleFlag, (Object)0);
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    private String validateTime(CalculateEntity entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", entity.getContractId());
        params.put("billType", "\u79df\u91d1\u8ba1\u7b97\u5355");
        params.put("queryType", "");
        params.put("billId", entity.getId());
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(entity.getRentDate(), lastDate, maxTimeMap, entity.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(entity.getRentDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

