/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.ContInfoPriceRecordEntity;
import com.ejianc.business.rmat.bean.PeriodDetailEntity;
import com.ejianc.business.rmat.bean.PeriodEntity;
import com.ejianc.business.rmat.bean.PeriodPriceEntity;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.enums.SignTypeEnum;
import com.ejianc.business.rmat.mapper.PeriodMapper;
import com.ejianc.business.rmat.service.IArchivesService;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IPeriodService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.business.rmat.vo.PeriodDetailVO;
import com.ejianc.business.rmat.vo.PeriodVO;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="periodService")
public class PeriodServiceImpl
extends BaseServiceImpl<PeriodMapper, PeriodEntity>
implements IPeriodService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private IArchivesService archivesService;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;
    private static final String BILL_CODE = "RMAT_PERIOD";

    @Override
    public PeriodVO saveOrUpdate(PeriodVO periodVO) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(CalculateEntity::getProjectId, (Object)periodVO.getProjectId());
        query.eq(CalculateEntity::getContractId, (Object)periodVO.getContractId());
        if (this.calculateService.count((Wrapper)query) > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u7684\u540c\u4e00\u5408\u540c\u5df2\u505a\u8fc7\u79df\u91d1\u8ba1\u7b97\uff0c\u4e0d\u5141\u8bb8\u505a\u671f\u521d\u5f55\u5165\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(null != periodVO.getId(), BaseEntity::getId, (Object)periodVO.getId());
        queryWrapper.eq(PeriodEntity::getProjectId, (Object)periodVO.getProjectId());
        queryWrapper.eq(PeriodEntity::getContractId, (Object)periodVO.getContractId());
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u7684\u540c\u4e00\u5408\u540c\u5df2\u505a\u8fc7\u671f\u521d\u5f55\u5165\uff0c\u4e0d\u80fd\u591a\u6b21\u5236\u5355\uff01");
        }
        PeriodEntity entity = (PeriodEntity)((Object)BeanMapper.map((Object)periodVO, PeriodEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        PeriodEntity periodEntity = (PeriodEntity)((Object)BeanMapper.map((Object)((Object)entity), PeriodEntity.class));
        for (PeriodDetailVO detailVO : periodVO.getDetailList()) {
            if (!"del".equals(detailVO.getRowState())) continue;
            periodEntity.getDetailList().add((PeriodDetailEntity)((Object)BeanMapper.map((Object)detailVO, PeriodDetailEntity.class)));
        }
        this.insertFlow(periodEntity, "BT230606000000001", RmatCommonConsts.NO);
        return (PeriodVO)BeanMapper.map((Object)((Object)entity), PeriodVO.class);
    }

    @Override
    public Boolean insertPriceFlow(PeriodEntity entity, String billTypeCode) {
        ArrayList<PriceFlowVO> flowList = new ArrayList<PriceFlowVO>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for (PeriodDetailEntity detail : detailList) {
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setBillDate(new Date());
            vo.setEffectiveDate(new Date());
            vo.setFlowType(detail.getFlowType());
            vo.setUseStatus(detail.getUseStatus());
            vo.setDetailDate(detail.getRentDate());
            vo.setInfoId(detail.getNcDetailId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setPrice(RmatCommonConsts.NO.equals(detail.getUseStatus()) ? detail.getStopPrice() : detail.getNprice());
            vo.setTaxPrice(RmatCommonConsts.NO.equals(detail.getUseStatus()) ? detail.getStopTaxPrice() : detail.getNtaxprice());
            vo.setTaxRate(detail.getTaxrate());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.priceFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean insertFlow(PeriodEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for (PeriodDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            vo.setEmployeeName(InvocationInfoProxy.getUsercode());
            vo.setBillDate(new Date());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(detail.getFlowType());
            vo.setInOutFlag(detail.getInOutFlag());
            vo.setUseStatus(detail.getUseStatus());
            vo.setDetailDate(detail.getRentDate());
            vo.setInfoId(detail.getNcDetailId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnit());
            vo.setNum(detail.getCheckNumsSum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setSignRowType(detail.getSignRowType());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.rmatFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean delPriceFlow(List<Long> ids, String billTypeCode) {
        return this.priceFlowService.delFlow(ids, billTypeCode);
    }

    @Override
    public Boolean delFlow(List<Long> ids, String billTypeCode) {
        return this.rmatFlowService.delFlow(ids, billTypeCode);
    }

    @Override
    public void delete(List<PeriodVO> vos) {
        List<Long> idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.delFlow(idList, "BT230606000000001");
        this.removeByIds(idList, true);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        String contractId = request.getParameter("contractId");
        Long orgId = Long.valueOf(request.getParameter("orgId"));
        Map<Long, PeriodDetailVO> refMap = this.refList(contractId, orgId);
        Map resultMap = refMap.values().stream().collect(Collectors.toMap(PeriodDetailVO::getMaterialCode, Function.identity(), (key1, key2) -> key1));
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        HashMap<String, String> bussTypeMap = new HashMap<String, String>();
        bussTypeMap.put("\u8fdb\u573a", FlowTypeEnum.\u9a8c\u6536.getFlowType() + "@1@1@0");
        bussTypeMap.put("\u542f\u7528", FlowTypeEnum.\u542f\u7528.getFlowType() + "@1@1@1");
        bussTypeMap.put("\u505c\u7528", FlowTypeEnum.\u505c\u7528.getFlowType() + "@0@1@2");
        bussTypeMap.put("\u9000\u573a-\u542f\u7528", FlowTypeEnum.\u9000\u573a.getFlowType() + "@1@2@3");
        bussTypeMap.put("\u9000\u573a-\u505c\u7528", FlowTypeEnum.\u9000\u573a.getFlowType() + "@0@2@4");
        bussTypeMap.put("\u62a5\u5e9f-\u542f\u7528", FlowTypeEnum.\u8d54\u507f.getFlowType() + "@1@2@5");
        bussTypeMap.put("\u62a5\u5e9f-\u505c\u7528", FlowTypeEnum.\u8d54\u507f.getFlowType() + "@0@2@6");
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result.size() > 0 && ((List)result.get(0)).size() < 5) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<PeriodDetailVO> successList = new ArrayList<PeriodDetailVO>();
        ArrayList<PeriodDetailVO> errorList = new ArrayList<PeriodDetailVO>();
        if (result != null && result.size() > 0) {
            ArrayList<PeriodDetailVO> detailVoList = new ArrayList<PeriodDetailVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PeriodDetailVO vo = new PeriodDetailVO();
                boolean flag = false;
                String warnType = "";
                String bussType = (String)datas.get(0);
                String materialCode = (String)datas.get(1);
                String bussDate = (String)datas.get(2);
                String rentNum = (String)datas.get(3);
                String stopPrice = (String)datas.get(4);
                vo.setImportMatCode(materialCode);
                if (StringUtils.isEmpty((CharSequence)materialCode)) {
                    vo.setMaterialCode(null);
                    warnType = warnType + "[\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else if (!resultMap.containsKey(materialCode)) {
                    vo.setMaterialCode(null);
                    warnType = warnType + "[\u8be5\u7269\u8d44\u5728\u8be5\u5408\u540c\u4e2d\u4e0d\u5b58\u5728]";
                    flag = true;
                } else {
                    vo = (PeriodDetailVO)BeanMapper.map(resultMap.get(materialCode), PeriodDetailVO.class);
                }
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportBusiType(bussType);
                if (StringUtils.isEmpty((CharSequence)bussType)) {
                    vo.setFlowType(null);
                    vo.setUseStatus(null);
                    vo.setInOutFlag(null);
                    warnType = warnType + "[\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a]";
                    flag = true;
                } else if (!bussTypeMap.containsKey(bussType)) {
                    vo.setFlowType(null);
                    vo.setUseStatus(null);
                    vo.setInOutFlag(null);
                    warnType = warnType + "[\u4e1a\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u5339\u914d]";
                    flag = true;
                } else {
                    String[] split = ((String)bussTypeMap.get(bussType)).split("@");
                    vo.setFlowType(split[0]);
                    vo.setUseStatus(split[1]);
                    vo.setInOutFlag(Integer.valueOf(split[2]));
                    vo.setBusiType(split[3]);
                }
                if (StringUtils.isEmpty((CharSequence)bussDate)) {
                    vo.setRentDate(null);
                    warnType = warnType + "[\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setRentDate(new SimpleDateFormat("yyyy-MM-dd").parse(bussDate));
                    }
                    catch (Exception e) {
                        vo.setRentDate(null);
                        warnType = warnType + "[\u4e1a\u52a1\u65e5\u671f\u683c\u5f0f\u9519\u8bef]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)rentNum)) {
                    vo.setRentNum(null);
                    warnType = warnType + "[\u6570\u91cf\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setRentNum(new BigDecimal(rentNum));
                        vo.setCheckNumsSum(ComputeUtil.safeDiv((BigDecimal)vo.getRentNum(), (BigDecimal)vo.getRentTransScale()));
                        vo.setMny(ComputeUtil.safeMultiply((BigDecimal)vo.getNprice(), (BigDecimal)vo.getCheckNumsSum()));
                        vo.setTaxmny(ComputeUtil.safeMultiply((BigDecimal)vo.getNtaxprice(), (BigDecimal)vo.getCheckNumsSum()));
                        vo.setTax(ComputeUtil.safeSub((BigDecimal)vo.getTaxmny(), (BigDecimal)vo.getMny()));
                        vo.setRealNum(ComputeUtil.safeDiv((BigDecimal)vo.getCheckNumsSum(), (BigDecimal)vo.getRealTransScale()));
                    }
                    catch (Exception e) {
                        vo.setRentNum(null);
                        warnType = warnType + "[\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if ("0".equals(vo.getUseStatus())) {
                    if (StringUtils.isEmpty((CharSequence)stopPrice)) {
                        vo.setStopPrice(null);
                        warnType = warnType + "[\u505c\u7528\u5355\u4ef7\u4e3a\u7a7a]";
                        flag = true;
                    } else {
                        try {
                            vo.setStopPrice(new BigDecimal(stopPrice));
                            vo.setStopTaxPrice(ComputeUtil.safeMultiply((BigDecimal)vo.getStopPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTaxrate(), (BigDecimal)BigDecimal.valueOf(100L)))));
                        }
                        catch (Exception e) {
                            vo.setStopPrice(null);
                            warnType = warnType + "[\u505c\u7528\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                            flag = true;
                        }
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (PeriodDetailVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                resp.put("successList", successList);
                resp.put("errorList", null);
                resp.put("successNum", (Object)successList.size());
                resp.put("errorNum", (Object)0);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    @Override
    public Map<Long, PeriodDetailVO> refList(String contractId, Long orgId) {
        HashMap<Long, PeriodDetailVO> detailMap = new HashMap<Long, PeriodDetailVO>();
        CommonResponse response = this.cmContractInfoApi.queryLeaseContractInfoById(contractId);
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            PeriodDetailVO periodDetailVO;
            CmContractInfoVO infoVO;
            List<ArchivesVO> archivesVOS;
            ArchivesVOS queryVO;
            List infoVOS = (List)response.getData();
            HashMap<Long, CmContractInfoVO> materialMap = new HashMap<Long, CmContractInfoVO>();
            HashMap<String, CmContractInfoVO> categoryMap = new HashMap<String, CmContractInfoVO>();
            HashSet<Long> categorySet = new HashSet<Long>();
            for (CmContractInfoVO infoVO2 : infoVOS) {
                if (null != infoVO2.getMaterialId()) {
                    materialMap.put(infoVO2.getMaterialId(), infoVO2);
                    continue;
                }
                categorySet.add(infoVO2.getMaterialTypeId());
                categoryMap.put(infoVO2.getMaterialTypeId() + "@" + infoVO2.getPkMngmeasdoc(), infoVO2);
            }
            if (!materialMap.isEmpty()) {
                queryVO = new ArchivesVOS();
                queryVO.setMaterialIds(new ArrayList(materialMap.keySet()));
                queryVO.setOrgId(orgId);
                queryVO.setType(Integer.valueOf(0));
                archivesVOS = this.archivesService.queryIds(queryVO);
                if (CollectionUtils.isNotEmpty(archivesVOS)) {
                    for (ArchivesVO archivesVO : archivesVOS) {
                        if (detailMap.containsKey(archivesVO.getMaterialId())) continue;
                        infoVO = (CmContractInfoVO)materialMap.get(archivesVO.getMaterialId());
                        periodDetailVO = new PeriodDetailVO();
                        periodDetailVO.setSignRowType(SignTypeEnum.\u660e\u7ec6.getCode());
                        this.convertToCheckDetail(periodDetailVO, infoVO, archivesVO);
                        detailMap.put(periodDetailVO.getMaterialId(), periodDetailVO);
                    }
                }
            }
            if (!categoryMap.isEmpty()) {
                queryVO = new ArchivesVOS();
                queryVO.setCategoryIds(new ArrayList(categorySet));
                queryVO.setOrgId(orgId);
                queryVO.setType(Integer.valueOf(1));
                archivesVOS = this.archivesService.queryIds(queryVO);
                if (CollectionUtils.isNotEmpty(archivesVOS)) {
                    for (ArchivesVO archivesVO : archivesVOS) {
                        if (detailMap.containsKey(archivesVO.getMaterialId()) || !categoryMap.containsKey(archivesVO.getMaterialTypeId() + "@" + archivesVO.getUnitId())) continue;
                        infoVO = (CmContractInfoVO)categoryMap.get(archivesVO.getMaterialTypeId() + "@" + archivesVO.getUnitId());
                        periodDetailVO = new PeriodDetailVO();
                        periodDetailVO.setSignRowType(SignTypeEnum.\u5206\u7c7b.getCode());
                        this.convertToCheckDetail(periodDetailVO, infoVO, archivesVO);
                        detailMap.put(periodDetailVO.getMaterialId(), periodDetailVO);
                    }
                }
            }
        }
        return detailMap;
    }

    @Override
    public Boolean insertPriceRecord(PeriodEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getPriceList())) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            Date date = null;
            try {
                date = ft.parse("1990-01-01");
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage());
            }
            ArrayList<ContInfoPriceRecordEntity> recordEntities = new ArrayList<ContInfoPriceRecordEntity>();
            for (PeriodPriceEntity priceEntity : entity.getPriceList()) {
                ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                recordEntity.setPkContract(entity.getContractId());
                recordEntity.setPkLeaselist(priceEntity.getNcDetailId());
                recordEntity.setPkAmountlist(priceEntity.getPkAmountlist());
                recordEntity.setDmakedate(priceEntity.getCreateTime());
                recordEntity.setNhireprice(priceEntity.getNprice());
                recordEntity.setDactivedate(date);
                recordEntity.setTs(new Date());
                recordEntity.setPeriodFlag(true);
                recordEntity.setCheckFlag(false);
                recordEntities.add(recordEntity);
            }
            if (CollectionUtils.isNotEmpty(recordEntities)) {
                this.contInfoPriceRecordService.saveOrUpdateBatch(recordEntities);
            }
        }
        return true;
    }

    @Override
    public Boolean delPriceRecord(String pkContract) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ContInfoPriceRecordEntity::getPeriodFlag, (Object)true);
        updateWrapper.eq(ContInfoPriceRecordEntity::getPkContract, (Object)pkContract);
        return this.contInfoPriceRecordService.remove((Wrapper)updateWrapper);
    }

    private void convertToCheckDetail(PeriodDetailVO detailVO, CmContractInfoVO infoVO, ArchivesVO archivesVO) {
        detailVO.setId(archivesVO.getId());
        detailVO.setNcDetailId(infoVO.getPkContractinfo());
        detailVO.setPkAmountlist(infoVO.getPkAmountlist());
        detailVO.setHtywnr(infoVO.getAmountname());
        detailVO.setNtaxprice(BigDecimal.valueOf(infoVO.getTaxhireprice()));
        detailVO.setTaxrate(infoVO.getSl());
        detailVO.setNprice(BigDecimal.valueOf(infoVO.getHireprice()));
        detailVO.setMaterialId(archivesVO.getMaterialId());
        detailVO.setMaterialCode(archivesVO.getMaterialCode());
        detailVO.setMaterialName(archivesVO.getMaterialName());
        detailVO.setMaterialSourceId(archivesVO.getMaterialSourceId());
        detailVO.setMaterialTypeId(archivesVO.getMaterialTypeId());
        detailVO.setMaterialTypeName(archivesVO.getMaterialTypeName());
        detailVO.setUnit(archivesVO.getUnitName());
        detailVO.setUnitId(archivesVO.getUnitId());
        detailVO.setSpec(archivesVO.getSpec());
        detailVO.setRentUnitId(infoVO.getPkContmeasdoc());
        detailVO.setRentUnitName(infoVO.getInfounit());
        detailVO.setRentTransScale(NumberUtils.createBigDecimal((String)infoVO.getMngScale()));
        detailVO.setRealUnitId(archivesVO.getRealUnitId());
        detailVO.setRealUnitName(archivesVO.getRealUnitName());
        detailVO.setRealTransScale(archivesVO.getTransScale());
        detailVO.setCheckNumsSum(BigDecimal.valueOf(infoVO.getInfonum()));
        detailVO.setMny(ComputeUtil.safeMultiply((BigDecimal)detailVO.getNprice(), (BigDecimal)detailVO.getCheckNumsSum()));
        detailVO.setTaxmny(ComputeUtil.safeMultiply((BigDecimal)detailVO.getNtaxprice(), (BigDecimal)detailVO.getCheckNumsSum()));
        detailVO.setTax(ComputeUtil.safeSub((BigDecimal)detailVO.getTaxmny(), (BigDecimal)detailVO.getMny()));
    }
}

