/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.util;

import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CmContractUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICmContractInfoApi infoApi;

    public Map<Long, CmContractInfoVO> getInfoMap(String pkContract) {
        CommonResponse response = this.infoApi.queryLeaseContractInfoById(pkContract);
        if (!response.isSuccess()) {
            this.logger.error(response.getMsg());
        }
        List infoList = new ArrayList();
        if (response.isSuccess()) {
            infoList = (List)response.getData();
        }
        Map<Long, CmContractInfoVO> infoMap = infoList.stream().collect(Collectors.toMap(x -> x.getMaterialId() != null ? x.getMaterialId() : x.getMaterialTypeId(), x -> x));
        return infoMap;
    }

    public CmContractInfoVO getInfoVO(Map<Long, CmContractInfoVO> infoMap, Long materialId, Long materialTypeId, PriceFlowVO vo) {
        CmContractInfoVO infoVO = null;
        if (infoMap.containsKey(materialId)) {
            infoVO = infoMap.get(materialId);
        } else if (infoMap.containsKey(materialTypeId)) {
            infoVO = infoMap.get(materialTypeId);
        }
        if (infoVO != null) {
            vo.setInfoId(StringUtils.isNotEmpty((CharSequence)vo.getInfoId()) ? vo.getInfoId() : infoVO.getPkContractinfo());
        }
        return infoVO;
    }

    public CmContractInfoVO getInfoVO(Map<Long, CmContractInfoVO> infoMap, Long materialId, Long materialTypeId, RmatFlowVO vo) {
        CmContractInfoVO infoVO = null;
        if (infoMap.containsKey(materialId)) {
            infoVO = infoMap.get(materialId);
            vo.setSignRowType(Integer.valueOf(vo.getSignRowType() != null ? vo.getSignRowType() : 2));
        } else if (infoMap.containsKey(materialTypeId)) {
            infoVO = infoMap.get(materialTypeId);
            vo.setSignRowType(Integer.valueOf(vo.getSignRowType() != null ? vo.getSignRowType() : 1));
        }
        if (infoVO != null) {
            vo.setInfoId(StringUtils.isNotEmpty((CharSequence)vo.getInfoId()) ? vo.getInfoId() : infoVO.getPkContractinfo());
        }
        return infoVO;
    }
}

