/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.mapper.StartMapper;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IStartService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.StartVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="startService")
public class StartServiceImpl
extends BaseServiceImpl<StartMapper, StartEntity>
implements IStartService {
    @Autowired
    private IMaterialService materialService;

    @Override
    public String validateTime(StartVO startVO, String type) {
        Date lastDate;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", startVO.getContractId());
        if (startVO.getId() != null) {
            params.put("billType", "\u542f\u7528\u5355");
            params.put("billId", startVO.getId());
        }
        if ((lastDate = this.materialService.getLastDate(params)) == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (DateUtil.compareDate(startVO.getStartTime(), lastDate) < 0) {
            throw new BusinessException(DateUtil.formatDate(startVO.getStartTime()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String validateContract(String contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u518d\u542f\u79df\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

