package com.ejianc.business.rmat.controller.api;

import com.ejianc.business.rmat.service.IArchivesService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.business.rmat.vo.PriceFlowApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/archives/")
@Api(value = "周转材档案API接口", tags = {"周转材档案API接口"})
public class ArchivesApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IArchivesService service;

    /**
     * @param vos 数据
     * @description: 根据物料ids/分类ids、组织主键查询周转材档案
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author yqls
     * @date: 2022/10/16
     */
    @ApiOperation("查询操作")
    @RequestMapping(value = "/queryIds", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<ArchivesVO>> queryIds(@RequestBody ArchivesVOS vos) {
        return CommonResponse.success("查询成功！", service.queryIds(vos));
    }

}
