/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.business.rmat.vo.CalculateDailyVO;
import com.ejianc.business.rmat.vo.CalculateVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.business.sync.api.ICalculateSyncApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"calculate"})
public class CalculateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICalculateService service;
    @Autowired
    private ICalculateSyncApi calculateSyncApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CalculateVO> saveOrUpdate(@RequestBody CalculateVO saveOrUpdateVO) {
        CalculateVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CalculateVO> queryDetail(Long id) {
        CalculateEntity entity = (CalculateEntity)((Object)this.service.selectById(id));
        CalculateVO vo = (CalculateVO)BeanMapper.map((Object)((Object)entity), CalculateVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vo.getDailyList())) {
            vo.getDailyList().sort(Comparator.comparingInt(CalculateDailyVO::getSequence));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CalculateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CalculateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CalculateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, CalculateVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("calculate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCalculateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CalculateVO>> refCalculateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CalculateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/autoCalculate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CalculateVO> autoCalculate(@RequestBody CalculateVO vo) {
        return CommonResponse.success((String)"\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u6210\u529f\uff01", (Object)this.service.autoCalculate(vo));
    }

    @RequestMapping(value={"/queryRestituteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RestituteVO>> queryRestituteData(@RequestParam(value="contractId") String contractId, @RequestParam(value="lastRentDate", required=false) String lastRentDate, @RequestParam(value="rentDate", required=false) String rentDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9000\u8d54\u5355\u6210\u529f\uff01", this.service.queryRestituteData(new QueryParam(), contractId, lastRentDate, rentDate));
    }

    @RequestMapping(value={"/refRestituteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RestituteVO>> refMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        String contractId = null;
        String lastRentDate = null;
        String rentDate = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                contractId = json.getString("contractId");
            }
            if (condition.contains("lastRentDate")) {
                lastRentDate = json.getString("lastRentDate");
            }
            if (condition.contains("rentDate")) {
                rentDate = json.getString("rentDate");
            }
        }
        List<RestituteVO> list = this.service.queryRestituteData(param, contractId, lastRentDate, rentDate);
        List<RestituteVO> records = PageUtil.listToPage(list, pageNumber, pageSize);
        Page page = new Page();
        page.setRecords(records);
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        page.setTotal((long)list.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/getLastRentDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Date> getLastRentDate(@RequestParam(value="contractId") String contractId) {
        Date date = this.service.getLastRentDate(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)date);
    }

    @RequestMapping(path={"/syncSettleFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncSettleFlag(HttpServletRequest request) {
        this.logger.info("\u7ed3\u7b97\u6807\u8bc6\u540c\u6b65\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String ts = df.format(calendar.getTime()) + " 00:00:00";
        if (request.getParameter("ts") != null) {
            ts = request.getParameter("ts");
        }
        this.logger.info("ts------->" + ts);
        CommonResponse listCommonResponse = this.calculateSyncApi.settleFlagSync(ts, null);
        this.logger.info(JSONObject.toJSONString((Object)listCommonResponse));
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            HashSet<String> isSettleSet = new HashSet<String>();
            HashSet<String> noSettleSet = new HashSet<String>();
            for (com.ejianc.business.sync.vo.CalculateVO calculateVO : (List)listCommonResponse.getData()) {
                String pkId = calculateVO.getPkId().split("@")[0];
                if (1 == calculateVO.getNflag()) {
                    isSettleSet.add(pkId);
                    continue;
                }
                if (isSettleSet.contains(pkId) || 0 != calculateVO.getNflag()) continue;
                noSettleSet.add(pkId);
            }
            LambdaUpdateWrapper updateWrapper = null;
            if (CollectionUtils.isNotEmpty(isSettleSet)) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, isSettleSet);
                updateWrapper.set(CalculateEntity::getNcSettleFlag, (Object)1);
                this.service.update((Wrapper)updateWrapper);
            }
            if (CollectionUtils.isNotEmpty(noSettleSet)) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, noSettleSet);
                updateWrapper.set(CalculateEntity::getNcSettleFlag, (Object)0);
                this.service.update((Wrapper)updateWrapper);
            }
        }
        this.logger.info("\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u7ed3\u7b97\u6807\u8bc6\u540c\u6b65\u7ed3\u675f");
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }
}

