/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.IExitApplyService;
import com.ejianc.business.rmat.service.IExitService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.vo.ExitReportVO;
import com.ejianc.business.rmat.vo.ExitSupplierVO;
import com.ejianc.business.rmat.vo.ExitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"exit"})
public class ExitController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExitService service;
    @Autowired
    private IExitApplyService exitApplyService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITransferFlowService transferFlowService;
    @Autowired
    private IRmatFlowService flowService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdate(@RequestBody ExitVO saveorUpdateVO) {
        saveorUpdateVO.setSaveState(Integer.valueOf(1));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/saveOrUpdateTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdateTemp(@RequestBody ExitVO saveorUpdateVO) {
        saveorUpdateVO.setSaveState(Integer.valueOf(0));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExitVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/queryLinkDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExitVO> queryLinkDetail(Long projectId) {
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ExitEntity::getProjectId, (Object)projectId);
        lambda.eq(ExitEntity::getEmployeeId, (Object)InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(BaseEntity::getCreateTime);
        details = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(details.get(0), ExitVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExitVO> queryCopyDetail(Long id) {
        ExitApplyEntity applyEntity = (ExitApplyEntity)((Object)this.exitApplyService.selectById(id));
        ExitVO vo = (ExitVO)BeanMapper.map((Object)((Object)applyEntity), ExitVO.class);
        vo.setApplyId(applyEntity.getId());
        vo.setId(null);
        vo.setEmployeeId(null);
        vo.setEmployeeName(null);
        vo.setLinkId(null);
        vo.setLinkName(null);
        vo.setLinkTelephone(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setConfirmFlag(Integer.valueOf(0));
        vo.setConfirmDate(null);
        vo.setConfirmerId(null);
        vo.setConfirmerName(null);
        vo.setConfirmNote(null);
        vo.setExitDate(null);
        vo.setBillState(Integer.valueOf(0));
        vo.setBillCode(null);
        vo.setDef1(null);
        vo.setDef2(null);
        vo.setDef3(null);
        vo.setDef4(null);
        vo.setDef5(null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.transferFlowService.delete(ids, TransFlowTypeEnum.\u9000\u573a.getFlowType());
        if (!this.flowService.delFlow(ids, BillTypeEnum.\u9000\u573a\u5355.getCode()).booleanValue()) {
            return CommonResponse.error((String)"\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExitVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExitSupplierVO>> querySupplier(@RequestParam(value="exitId") Long exitId, @RequestParam(value="exitDetailId", required=false) Long exitDetailId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9886\u6599\u6210\u529f\uff01", this.service.querySupplier(exitId, exitDetailId));
    }

    @RequestMapping(value={"/queryTempList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryTempList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExitVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter("ne", (Object)0));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExitVO.class));
        List listExport = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (null != vo.getConfirmFlag() && 0 == vo.getConfirmFlag()) {
                    vo.setConfirmFlagName("\u5f85\u786e\u8ba4");
                } else if (null != vo.getConfirmFlag() && 1 == vo.getConfirmFlag()) {
                    vo.setConfirmFlagName("\u5df2\u786e\u8ba4");
                } else if (null != vo.getConfirmFlag() && 2 == vo.getConfirmFlag()) {
                    vo.setConfirmFlagName("\u5df2\u62d2\u7edd");
                }
            });
            listExport = pageData.getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("exitExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/updateConfirmFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExitVO> updateConfirmFlag(@RequestBody ExitVO exitVO) {
        return this.service.updateConfirmFlag(exitVO);
    }

    @RequestMapping(value={"/queryExitReports"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExitReportVO>> queryExitReports(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("exitDate", "asc");
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ExitReportVO> list = this.service.queryExitReport(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                if (0 == vo.getType()) {
                    vo.setTypeName("\u8fdb\u573a");
                } else {
                    vo.setTypeName("\u9000\u573a");
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/ExitReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void ExitReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("exitDate", "asc");
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ExitReportVO> list = this.service.queryExitReport(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                if (0 == vo.getType()) {
                    vo.setTypeName("\u8fdb\u573a");
                } else {
                    vo.setTypeName("\u9000\u573a");
                }
            });
        }
        HashMap<String, List<ExitReportVO>> beans = new HashMap<String, List<ExitReportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("exitReportExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryZlReports"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExitReportVO>> queryZlReports(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId = ((Parameter)queryParam.getParams().get("projectId")).getValue().toString();
        String supplierId = "0";
        if (queryParam.getParams().get("supplierId") != null) {
            supplierId = ((Parameter)queryParam.getParams().get("supplierId")).getValue().toString();
        }
        queryParam.getParams().remove("projectId");
        queryParam.getParams().remove("supplierId");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ExitReportVO> list = this.service.queryZlReports(wrapper, Long.valueOf(projectId), Long.valueOf(supplierId));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/zlReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void zlReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId = ((Parameter)queryParam.getParams().get("projectId")).getValue().toString();
        String supplierId = "0";
        if (queryParam.getParams().get("supplierId") != null) {
            supplierId = ((Parameter)queryParam.getParams().get("supplierId")).getValue().toString();
        }
        queryParam.getParams().remove("projectId");
        queryParam.getParams().remove("supplierId");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ExitReportVO> list = this.service.queryZlReports(wrapper, Long.valueOf(projectId), Long.valueOf(supplierId));
        HashMap<String, List<ExitReportVO>> beans = new HashMap<String, List<ExitReportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("zlReportExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryCgReports"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExitReportVO>> queryCgReports(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId = ((Parameter)queryParam.getParams().get("projectId")).getValue().toString();
        queryParam.getParams().remove("projectId");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ExitReportVO> list = this.service.queryCgReports(wrapper, Long.valueOf(projectId));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/cgReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void cgReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId = ((Parameter)queryParam.getParams().get("projectId")).getValue().toString();
        queryParam.getParams().remove("projectId");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ExitReportVO> list = this.service.queryCgReports(wrapper, Long.valueOf(projectId));
        HashMap<String, List<ExitReportVO>> beans = new HashMap<String, List<ExitReportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("cgReportExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/updatenums"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> updatenums(@RequestParam(value="ids") List<Long> ids) {
        if (this.service.updatenums(ids).booleanValue()) {
            return CommonResponse.success((Object)true);
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5931\u8d25\uff01");
    }
}

