/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.CalculateOtherEntity;
import com.ejianc.business.rmat.bean.DailyDetailEntity;
import com.ejianc.business.rmat.bean.DailyEntity;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.bean.RestituteMaintainEntity;
import com.ejianc.business.rmat.bean.RestituteOtherEntity;
import com.ejianc.business.rmat.bean.RestituteScrapEntity;
import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.bean.StopDetailEntity;
import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.DailyMapper;
import com.ejianc.business.rmat.service.ICalculateOtherService;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IDailyService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.service.IRestituteMaintainService;
import com.ejianc.business.rmat.service.IRestituteOtherService;
import com.ejianc.business.rmat.service.IRestituteScrapService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.IStopDetailService;
import com.ejianc.business.rmat.service.IStopService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.ContInfoPriceRecordVO;
import com.ejianc.business.rmat.vo.DailyVO;
import com.ejianc.business.rmat.vo.RentReportCalcVO;
import com.ejianc.business.rmat.vo.RentReportDetailVO;
import com.ejianc.business.rmat.vo.RentReportOtherVO;
import com.ejianc.business.rmat.vo.RentReportRepairVO;
import com.ejianc.business.rmat.vo.RentReportRestituteVO;
import com.ejianc.business.rmat.vo.RentReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dailyService")
public class DailyServiceImpl
extends BaseServiceImpl<DailyMapper, DailyEntity>
implements IDailyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String RMAT_DAILY = "RMAT_DAILY";
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private ICalculateOtherService calculateOtherService;
    @Autowired
    private IReportDailyService reportDailyService;
    @Autowired
    private IStopService stopService;
    @Autowired
    private IStopDetailService stopDetailService;
    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private IRestituteScrapService restituteScrapService;
    @Autowired
    private IRestituteMaintainService restituteMaintainService;
    @Autowired
    private IRestituteOtherService restituteOtherService;
    @Autowired
    private IMaterialService materialService;

    @Override
    public DailyVO saveOrUpdate(DailyVO dailyVO) {
        DailyEntity entity = (DailyEntity)((Object)BeanMapper.map((Object)((Object)dailyVO), DailyEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (DailyVO)((Object)BeanMapper.map((Object)((Object)entity), DailyVO.class));
    }

    @Override
    public CommonResponse<String> generation(HttpServletRequest request) {
        DailyEntity dailyEntity;
        this.logger.info("\u751f\u6210\u65e5\u79df\u91d1\u62a5\u8868\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String beginTime = df.format(calendar.getTime()) + " 00:00:00";
        String endTime = df.format(calendar.getTime()) + " 23:59:59";
        if (request.getParameter("beginTime") != null) {
            beginTime = request.getParameter("beginTime");
        }
        if (request.getParameter("endTime") != null) {
            endTime = request.getParameter("endTime");
        }
        this.logger.info("beginTime------->" + beginTime);
        this.logger.info("endTime------->" + endTime);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = dateFormat.parse(beginTime);
            endDate = dateFormat.parse(endTime);
        }
        catch (ParseException e) {
            this.logger.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01");
            throw new BusinessException(e.getMessage());
        }
        List<CalculateDailyEntity> dailyEntityList = this.calculateService.dailyQueryList(startDate, endDate);
        HashMap<Long, DailyEntity> map = new HashMap<Long, DailyEntity>();
        HashMap<String, CmContractInfoVO> infoMap = new HashMap<String, CmContractInfoVO>();
        HashMap<Long, ProjectRegisterVO> projMap = new HashMap<Long, ProjectRegisterVO>();
        HashMap<Long, OrgVO> orgMap = new HashMap<Long, OrgVO>();
        for (CalculateDailyEntity calcDailyEntity : dailyEntityList) {
            CmContractInfoVO infoVO;
            CommonResponse response;
            dailyEntity = null;
            if (!map.containsKey(calcDailyEntity.getProjectId())) {
                dailyEntity = (DailyEntity)((Object)BeanMapper.map((Object)((Object)calcDailyEntity), DailyEntity.class));
                dailyEntity.setId(IdWorker.getId());
                dailyEntity.setRentDate(calendar.getTime());
                dailyEntity.setCreateTime(null);
                dailyEntity.setCreateUserCode(null);
                dailyEntity.setUpdateTime(null);
                dailyEntity.setUpdateUserCode(null);
                dailyEntity.setVersion(1);
                dailyEntity.setMemo(null);
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RMAT_DAILY, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                dailyEntity.setBillCode((String)billCode.getData());
                dailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
                if (projMap.containsKey(calcDailyEntity.getProjectId())) {
                    projectRegisterVO = (ProjectRegisterVO)projMap.get(calcDailyEntity.getProjectId());
                } else {
                    CommonResponse commonResponse = this.projectApi.queryProjectByIds(Arrays.asList(calcDailyEntity.getProjectId()));
                    if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                        projectRegisterVO = (ProjectRegisterVO)((List)commonResponse.getData()).get(0);
                        projMap.put(calcDailyEntity.getProjectId(), projectRegisterVO);
                    }
                }
                dailyEntity.setProjectCode(projectRegisterVO.getCode());
                dailyEntity.setProjectName(projectRegisterVO.getName());
                dailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                dailyEntity.setOrgId(projectRegisterVO.getOrgId());
                dailyEntity.setOrgName(projectRegisterVO.getOrgName());
                dailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                dailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                dailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());
                OrgVO orgVO = new OrgVO();
                if (orgMap.containsKey(dailyEntity.getOrgId())) {
                    orgVO = (OrgVO)orgMap.get(dailyEntity.getOrgId());
                } else {
                    CommonResponse response2 = this.orgApi.getOneById(dailyEntity.getOrgId());
                    if (response2.isSuccess() && response2.getData() != null) {
                        orgVO = (OrgVO)response2.getData();
                        orgMap.put(dailyEntity.getOrgId(), orgVO);
                    }
                }
                dailyEntity.setParentOrgId(orgVO.getId());
                dailyEntity.setParentOrgCode(orgVO.getCode());
                dailyEntity.setParentOrgName(orgVO.getName());
            } else {
                dailyEntity = (DailyEntity)((Object)map.get(calcDailyEntity.getProjectId()));
            }
            DailyDetailEntity detailEntity = (DailyDetailEntity)((Object)BeanMapper.map((Object)((Object)calcDailyEntity), DailyDetailEntity.class));
            detailEntity.setId(IdWorker.getId());
            detailEntity.setDailyId(dailyEntity.getId());
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setVersion(1);
            detailEntity.setMemo(null);
            if (!infoMap.containsKey(calcDailyEntity.getInfoId()) && (response = this.cmContractInfoApi.queryLeaseContractInfoById(calcDailyEntity.getContractId())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                for (CmContractInfoVO infoVO2 : (List)response.getData()) {
                    infoMap.put(infoVO2.getPkContractinfo(), infoVO2);
                }
            }
            if (null == (infoVO = (CmContractInfoVO)infoMap.get(detailEntity.getInfoId()))) {
                this.logger.error("NC\u4e0d\u5b58\u5728\u7684\u5408\u540c\u660e\u7ec6\uff1a" + detailEntity.getInfoId());
            }
            detailEntity.setRentPrice(BigDecimal.valueOf(infoVO.getHireprice()));
            detailEntity.setRentTaxPrice(BigDecimal.valueOf(infoVO.getTaxhireprice()));
            detailEntity.setRentMny(ComputeUtil.safeMultiply((BigDecimal)detailEntity.getRentNum(), (BigDecimal)detailEntity.getRentPrice()));
            detailEntity.setRentTaxMny(ComputeUtil.safeMultiply((BigDecimal)detailEntity.getRentNum(), (BigDecimal)detailEntity.getRentTaxPrice()));
            detailEntity.setRentTax(ComputeUtil.safeSub((BigDecimal)detailEntity.getRentTaxMny(), (BigDecimal)detailEntity.getRentMny()));
            ArrayList<DailyDetailEntity> detailList = null != dailyEntity.getDetailList() ? dailyEntity.getDetailList() : new ArrayList<DailyDetailEntity>();
            detailList.add(detailEntity);
            dailyEntity.setDetailList(detailList);
            map.put(dailyEntity.getProjectId(), dailyEntity);
        }
        if (CollectionUtils.isNotEmpty(map.values())) {
            for (Long projectId : map.keySet()) {
                dailyEntity = (DailyEntity)((Object)map.get(projectId));
                LambdaQueryWrapper query = new LambdaQueryWrapper();
                query.eq(CalculateEntity::getProjectId, (Object)dailyEntity.getProjectId());
                query.eq(CalculateEntity::getRentDate, (Object)dailyEntity.getRentDate());
                query.eq(CalculateEntity::getBillState, (Object)"1,3");
                List calculateEntities = this.calculateService.list((Wrapper)query);
                for (CalculateEntity calculateEntity : calculateEntities) {
                    dailyEntity.setCalcMny(ComputeUtil.safeAdd((BigDecimal)dailyEntity.getCalcMny(), (BigDecimal)calculateEntity.getRentMny()));
                    dailyEntity.setCalcTaxMny(ComputeUtil.safeAdd((BigDecimal)dailyEntity.getCalcTaxMny(), (BigDecimal)calculateEntity.getRentTaxMny()));
                    dailyEntity.setCalcTax(ComputeUtil.safeAdd((BigDecimal)dailyEntity.getCalcTax(), (BigDecimal)calculateEntity.getRentTax()));
                }
                for (DailyDetailEntity detailEntity : dailyEntity.getDetailList()) {
                    dailyEntity.setRentMny(ComputeUtil.safeAdd((BigDecimal)dailyEntity.getRentMny(), (BigDecimal)detailEntity.getRentMny()));
                    dailyEntity.setRentTaxMny(ComputeUtil.safeAdd((BigDecimal)dailyEntity.getRentTaxMny(), (BigDecimal)detailEntity.getRentTaxMny()));
                    dailyEntity.setRentTax(ComputeUtil.safeAdd((BigDecimal)dailyEntity.getRentTax(), (BigDecimal)detailEntity.getRentTax()));
                }
                this.saveOrUpdate((Object)dailyEntity, false);
            }
        }
        this.reportDailyService.makeReportDailyData(new ArrayList<DailyEntity>(map.values()));
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    @Override
    public RentReportVO qryReport(Long projectId, String beginDate, String endDate) {
        RentReportVO rentReportVO = new RentReportVO();
        rentReportVO.setId(IdWorker.getId());
        HashMap<String, List<ContInfoPriceRecordVO>> priceMap = new HashMap<String, List<ContInfoPriceRecordVO>>();
        List<RentReportCalcVO> sumCalcList = this.qryCalcList(projectId, "1990-01-01", endDate, null, priceMap);
        HashMap<Long, RentReportDetailVO> detailMap = new HashMap<Long, RentReportDetailVO>();
        HashSet<Long> detailAddedSet = new HashSet<Long>();
        for (RentReportCalcVO rentReportCalcVO : sumCalcList) {
            RentReportDetailVO detailVO = null;
            if (!detailMap.containsKey(rentReportCalcVO.getMaterialId())) {
                detailVO = (RentReportDetailVO)((Object)BeanMapper.map((Object)((Object)rentReportCalcVO), RentReportDetailVO.class));
                detailVO.setReportId(rentReportVO.getId());
            } else {
                detailVO = (RentReportDetailVO)((Object)detailMap.get(rentReportCalcVO.getMaterialId()));
            }
            if ("\u8fdb\u573a".equals(rentReportCalcVO.getBillType()) && !detailAddedSet.contains(rentReportCalcVO.getSourceDetailId())) {
                detailVO.setMaxInNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getMaxInNum(), (BigDecimal)rentReportCalcVO.getInOutNum()));
            } else if ((rentReportCalcVO.getBillType().contains("\u9000\u573a") || rentReportCalcVO.getBillType().contains("\u8d54\u507f")) && !detailAddedSet.contains(rentReportCalcVO.getSourceDetailId())) {
                detailVO.setRentNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getRentNum(), (BigDecimal)rentReportCalcVO.getInOutNum()));
            }
            detailVO.setSumRentMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getSumRentMny(), (BigDecimal)rentReportCalcVO.getMny()));
            detailVO.setSumRentTaxMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getSumRentTaxMny(), (BigDecimal)rentReportCalcVO.getTaxMny()));
            detailAddedSet.add(rentReportCalcVO.getSourceDetailId());
            detailMap.put(rentReportCalcVO.getMaterialId(), detailVO);
        }
        List<RentReportCalcVO> reportCalcVOS = this.qryCalcList(projectId, beginDate, endDate, null, priceMap);
        rentReportVO.setCalcList(reportCalcVOS);
        for (RentReportCalcVO calcVO : reportCalcVOS) {
            RentReportDetailVO detailVO = (RentReportDetailVO)((Object)detailMap.get(calcVO.getMaterialId()));
            detailVO.setRentMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getRentMny(), (BigDecimal)calcVO.getMny()));
            detailVO.setRentTaxMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getRentTaxMny(), (BigDecimal)calcVO.getTaxMny()));
            detailMap.put(calcVO.getMaterialId(), detailVO);
        }
        if (!detailMap.isEmpty()) {
            for (RentReportDetailVO detailVO : detailMap.values()) {
                detailVO.setRentNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getMaxInNum(), (BigDecimal)detailVO.getRentNum()));
                rentReportVO.setTotalMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getTotalMny(), (BigDecimal)detailVO.getRentMny()));
                rentReportVO.setRentMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getRentMny(), (BigDecimal)detailVO.getRentMny()));
            }
            rentReportVO.setDetailList(new ArrayList<RentReportDetailVO>(detailMap.values()));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(RestituteEntity::getProjectId, (Object)projectId);
        lambdaQueryWrapper.in(RestituteEntity::getBillState, new Object[]{"1,3"});
        lambdaQueryWrapper.between(RestituteEntity::getRestituteDate, (Object)"1990-01-01", (Object)endDate);
        List restituteEntities = this.restituteService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)restituteEntities)) {
            rentReportVO.setRestituteList(this.qryRestituteVOList(rentReportVO, beginDate, restituteEntities));
        }
        if (CollectionUtils.isNotEmpty((Collection)restituteEntities)) {
            rentReportVO.setRepairList(this.qryRepairVOList(rentReportVO, beginDate, restituteEntities));
        }
        rentReportVO.setOtherList(this.qryOtherVOList(rentReportVO, projectId, beginDate, endDate, restituteEntities));
        return rentReportVO;
    }

    @Override
    public List<RentReportCalcVO> qryReportCalcList(Long projectId, String beginDate, String endDate, Long materialId) {
        HashMap<String, List<ContInfoPriceRecordVO>> priceMap = new HashMap<String, List<ContInfoPriceRecordVO>>();
        return this.qryCalcList(projectId, beginDate, endDate, materialId, priceMap);
    }

    private List<RentReportRestituteVO> qryRestituteVOList(RentReportVO rentReportVO, String beginDate, List<RestituteEntity> restituteEntities) {
        HashMap<Long, RentReportRestituteVO> restituteMap = new HashMap<Long, RentReportRestituteVO>();
        HashSet<Long> bqSet = new HashSet<Long>();
        ArrayList<Long> allList = new ArrayList<Long>();
        Date begin = null;
        try {
            begin = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        for (RestituteEntity entity : restituteEntities) {
            allList.add(entity.getId());
            if (begin.compareTo(entity.getRestituteDate()) > 0) continue;
            bqSet.add(entity.getId());
        }
        if (CollectionUtils.isNotEmpty(restituteEntities)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(RestituteScrapEntity::getRestituteId, allList);
            List scrapEntities = this.restituteScrapService.list((Wrapper)query);
            for (RestituteScrapEntity scrapEntity : scrapEntities) {
                RentReportRestituteVO restituteVO = null;
                if (!restituteMap.containsKey(scrapEntity.getMaterialId())) {
                    restituteVO = (RentReportRestituteVO)((Object)BeanMapper.map((Object)((Object)scrapEntity), RentReportRestituteVO.class));
                    restituteVO.setId(IdWorker.getId());
                    restituteVO.setReportId(rentReportVO.getId());
                } else {
                    restituteVO = (RentReportRestituteVO)((Object)restituteMap.get(scrapEntity.getMaterialId()));
                }
                if (bqSet.contains(scrapEntity.getRestituteId())) {
                    restituteVO.setSumNum(ComputeUtil.safeAdd((BigDecimal)restituteVO.getSumNum(), (BigDecimal)scrapEntity.getDamageNum()));
                    restituteVO.setRentMny(ComputeUtil.safeAdd((BigDecimal)restituteVO.getRentMny(), (BigDecimal)scrapEntity.getDamageMny()));
                    restituteVO.setRentTaxMny(ComputeUtil.safeAdd((BigDecimal)restituteVO.getRentTaxMny(), (BigDecimal)scrapEntity.getDamageTaxMny()));
                    rentReportVO.setTotalMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getTotalMny(), (BigDecimal)scrapEntity.getDamageMny()));
                    rentReportVO.setOtherMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getOtherMny(), (BigDecimal)scrapEntity.getDamageMny()));
                }
                restituteVO.setSumRentMny(ComputeUtil.safeAdd((BigDecimal)restituteVO.getSumRentMny(), (BigDecimal)scrapEntity.getDamageMny()));
                restituteVO.setSumRentTaxMny(ComputeUtil.safeAdd((BigDecimal)restituteVO.getSumRentTaxMny(), (BigDecimal)scrapEntity.getDamageTaxMny()));
                restituteMap.put(scrapEntity.getMaterialId(), restituteVO);
            }
        }
        return new ArrayList<RentReportRestituteVO>(restituteMap.values());
    }

    private List<RentReportRepairVO> qryRepairVOList(RentReportVO rentReportVO, String beginDate, List<RestituteEntity> restituteEntities) {
        HashMap<Long, RentReportRepairVO> repairMap = new HashMap<Long, RentReportRepairVO>();
        HashSet<Long> bqSet = new HashSet<Long>();
        ArrayList<Long> allList = new ArrayList<Long>();
        Date begin = null;
        try {
            begin = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        for (RestituteEntity entity : restituteEntities) {
            allList.add(entity.getId());
            if (begin.compareTo(entity.getRestituteDate()) > 0) continue;
            bqSet.add(entity.getId());
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(RestituteMaintainEntity::getRestituteId, allList);
        List detailEntities = this.restituteMaintainService.list((Wrapper)query);
        for (RestituteMaintainEntity maintainEntity : detailEntities) {
            RentReportRepairVO repairVO = null;
            if (!repairMap.containsKey(maintainEntity.getMaterialId())) {
                repairVO = (RentReportRepairVO)((Object)BeanMapper.map((Object)((Object)maintainEntity), RentReportRepairVO.class));
                repairVO.setId(IdWorker.getId());
                repairVO.setReportId(rentReportVO.getId());
            } else {
                repairVO = (RentReportRepairVO)((Object)repairMap.get(maintainEntity.getMaterialId()));
            }
            if (bqSet.contains(maintainEntity.getRestituteId())) {
                repairVO.setSumNum(ComputeUtil.safeAdd((BigDecimal)repairVO.getSumNum(), (BigDecimal)maintainEntity.getMaintainNum()));
                repairVO.setRentMny(ComputeUtil.safeAdd((BigDecimal)repairVO.getRentMny(), (BigDecimal)maintainEntity.getMaintainMny()));
                repairVO.setRentTaxMny(ComputeUtil.safeAdd((BigDecimal)repairVO.getRentTaxMny(), (BigDecimal)maintainEntity.getMaintainTaxMny()));
                rentReportVO.setTotalMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getTotalMny(), (BigDecimal)maintainEntity.getMaintainMny()));
                rentReportVO.setOtherMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getOtherMny(), (BigDecimal)maintainEntity.getMaintainMny()));
            }
            repairVO.setSumRentMny(ComputeUtil.safeAdd((BigDecimal)repairVO.getSumRentMny(), (BigDecimal)maintainEntity.getMaintainMny()));
            repairVO.setSumRentTaxMny(ComputeUtil.safeAdd((BigDecimal)repairVO.getSumRentTaxMny(), (BigDecimal)maintainEntity.getMaintainTaxMny()));
            repairMap.put(maintainEntity.getMaterialId(), repairVO);
        }
        return new ArrayList<RentReportRepairVO>(repairMap.values());
    }

    private List<RentReportOtherVO> qryOtherVOList(RentReportVO rentReportVO, Long projectId, String beginDate, String endDate, List<RestituteEntity> restituteEntities) {
        RentReportOtherVO otherVO = null;
        HashSet<Long> bqSet = new HashSet<Long>();
        ArrayList<Long> allList = new ArrayList<Long>();
        Date begin = null;
        Date end = null;
        try {
            begin = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
            end = new SimpleDateFormat("yyyy-MM-dd").parse(endDate);
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        rentReportVO.setBeginDate(begin);
        rentReportVO.setEndDate(end);
        for (RestituteEntity entity : restituteEntities) {
            allList.add(entity.getId());
            if (begin.compareTo(entity.getRestituteDate()) > 0) continue;
            bqSet.add(entity.getId());
        }
        if (CollectionUtils.isNotEmpty(restituteEntities)) {
            otherVO = new RentReportOtherVO();
            otherVO.setId(IdWorker.getId());
            otherVO.setReportId(rentReportVO.getId());
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(RestituteOtherEntity::getRestituteId, allList);
            List detailEntities = this.restituteOtherService.list((Wrapper)query);
            for (RestituteOtherEntity otherEntity : detailEntities) {
                if (bqSet.contains(otherEntity.getRestituteId())) {
                    otherVO.setRentMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getRentMny(), (BigDecimal)otherEntity.getCurrentAmount()));
                    otherVO.setRentTaxMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getRentTaxMny(), (BigDecimal)otherEntity.getCurrentTaxAmount()));
                    rentReportVO.setTotalMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getTotalMny(), (BigDecimal)otherEntity.getCurrentAmount()));
                    rentReportVO.setOtherMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getOtherMny(), (BigDecimal)otherEntity.getCurrentAmount()));
                }
                otherVO.setSumMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getSumMny(), (BigDecimal)otherEntity.getCurrentAmount()));
                otherVO.setSumTaxMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getSumTaxMny(), (BigDecimal)otherEntity.getCurrentTaxAmount()));
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CalculateEntity::getProjectId, (Object)projectId);
        queryWrapper.in(CalculateEntity::getBillState, new Object[]{"1,3"});
        queryWrapper.between(CalculateEntity::getRentDate, (Object)"1990-01-01", (Object)endDate);
        List calculateEntities = this.calculateService.list((Wrapper)queryWrapper);
        bqSet = new HashSet();
        allList = new ArrayList();
        for (CalculateEntity entity : calculateEntities) {
            allList.add(entity.getId());
            if (begin.compareTo(entity.getRentDate()) > 0) continue;
            bqSet.add(entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)calculateEntities)) {
            if (otherVO == null) {
                otherVO = new RentReportOtherVO();
                otherVO.setId(IdWorker.getId());
                otherVO.setReportId(rentReportVO.getId());
            }
            LambdaQueryWrapper qry = new LambdaQueryWrapper();
            qry.in(CalculateOtherEntity::getCalculateId, allList);
            List otherEntities = this.calculateOtherService.list((Wrapper)qry);
            for (CalculateOtherEntity otherEntity : otherEntities) {
                if (bqSet.contains(otherEntity.getCalculateId())) {
                    otherVO.setRentMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getRentMny(), (BigDecimal)otherEntity.getMny()));
                    otherVO.setRentTaxMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getRentTaxMny(), (BigDecimal)otherEntity.getTaxMny()));
                    rentReportVO.setTotalMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getTotalMny(), (BigDecimal)otherEntity.getMny()));
                    rentReportVO.setOtherMny(ComputeUtil.safeAdd((BigDecimal)rentReportVO.getOtherMny(), (BigDecimal)otherEntity.getMny()));
                }
                otherVO.setSumMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getSumMny(), (BigDecimal)otherEntity.getMny()));
                otherVO.setSumTaxMny(ComputeUtil.safeAdd((BigDecimal)otherVO.getSumTaxMny(), (BigDecimal)otherEntity.getTaxMny()));
            }
        }
        if (null == otherVO) {
            return null;
        }
        return Arrays.asList(otherVO);
    }

    private List<RentReportCalcVO> qryCalcList(Long projectId, String beginDate, String endDate, Long materialId, Map<String, List<ContInfoPriceRecordVO>> priceMap) {
        HashMap<String, String> billTypeMap = new HashMap<String, String>();
        billTypeMap.put("1", "\u8fdb\u573a");
        billTypeMap.put("2", "\u505c\u79df");
        billTypeMap.put("3", "\u518d\u542f\u79df");
        billTypeMap.put("40", "\u9000\u573a(\u505c\u7528)");
        billTypeMap.put("41", "\u9000\u573a(\u542f\u7528)");
        billTypeMap.put("50", "\u8d54\u507f(\u505c\u7528)");
        billTypeMap.put("51", "\u8d54\u507f(\u542f\u7528)");
        ArrayList<RentReportCalcVO> result = new ArrayList<RentReportCalcVO>();
        HashMap<String, CmContractInfoVO> infoMap = new HashMap<String, CmContractInfoVO>();
        CommonResponse response = this.projectApi.queryProjectByIds(Arrays.asList(projectId));
        ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)((List)response.getData()).get(0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = null;
        Date end = null;
        try {
            begin = format.parse(beginDate);
            end = format.parse(endDate);
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RmatFlowEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(RmatFlowEntity::getEffectiveState, (Object)1);
        queryWrapper.eq(null != materialId, RmatFlowEntity::getMaterialId, (Object)materialId);
        List flowEntities = this.rmatFlowService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)flowEntities)) {
            ArrayList<RmatFlowEntity> periodList = new ArrayList<RmatFlowEntity>();
            ArrayList<RmatFlowEntity> flowList = new ArrayList<RmatFlowEntity>();
            for (RmatFlowEntity rmatFlowEntity : flowEntities) {
                if (rmatFlowEntity.getDetailDate().compareTo(begin) < 0) {
                    periodList.add(rmatFlowEntity);
                    continue;
                }
                if (rmatFlowEntity.getDetailDate().compareTo(begin) < 0 || rmatFlowEntity.getDetailDate().compareTo(end) > 0) continue;
                flowList.add(rmatFlowEntity);
            }
            if (CollectionUtils.isNotEmpty(periodList)) {
                HashMap<Object, RentReportCalcVO> map = new HashMap<Object, RentReportCalcVO>();
                for (RmatFlowEntity rmatFlowEntity : periodList) {
                    CommonResponse commonResponse;
                    if (!infoMap.containsKey(rmatFlowEntity.getInfoId()) && (commonResponse = this.cmContractInfoApi.queryLeaseContractInfoById(rmatFlowEntity.getContractId())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                        for (CmContractInfoVO infoVO : (List)commonResponse.getData()) {
                            infoMap.put(infoVO.getPkContractinfo(), infoVO);
                        }
                    }
                    String key = rmatFlowEntity.getContractId() + "@" + rmatFlowEntity.getMaterialId() + "@" + rmatFlowEntity.getUseStatus();
                    RentReportCalcVO calcVO = null;
                    if ("1".equals(rmatFlowEntity.getUseStatus())) {
                        if (!map.containsKey(key)) {
                            calcVO = new RentReportCalcVO();
                            this.transferVO(rmatFlowEntity, calcVO, projectRegisterVO, infoMap);
                            calcVO.setBillType("\u671f\u521d\u542f\u7528");
                            calcVO.setBillCode("/");
                            calcVO.setBillDate(begin);
                            calcVO.setBillCreateTime("/");
                            calcVO.setRentEndDate(end);
                        } else {
                            calcVO = (RentReportCalcVO)((Object)map.get(key));
                        }
                        if (RmatCommonConsts.OUT.equals(rmatFlowEntity.getInOutFlag())) {
                            calcVO.setInOutNum(ComputeUtil.safeSub((BigDecimal)calcVO.getInOutNum(), (BigDecimal)rmatFlowEntity.getRentNum()));
                        } else {
                            calcVO.setInOutNum(ComputeUtil.safeAdd((BigDecimal)calcVO.getInOutNum(), (BigDecimal)rmatFlowEntity.getRentNum()));
                        }
                    } else if ("0".equals(rmatFlowEntity.getUseStatus())) {
                        if (!map.containsKey(key)) {
                            calcVO = new RentReportCalcVO();
                            this.transferVO(rmatFlowEntity, calcVO, projectRegisterVO, infoMap);
                            calcVO.setBillType("\u671f\u521d\u505c\u7528");
                            calcVO.setBillCode("/");
                            calcVO.setBillDate(begin);
                            calcVO.setBillCreateTime("/");
                            calcVO.setRentEndDate(end);
                        } else {
                            calcVO = (RentReportCalcVO)((Object)map.get(key));
                        }
                        calcVO.setStopPrice("2".equals(rmatFlowEntity.getFlowType()) ? ((StopDetailEntity)((Object)this.stopDetailService.selectById(rmatFlowEntity.getSourceDetailId()))).getStopPrice() : null);
                        if (RmatCommonConsts.OUT.equals(rmatFlowEntity.getInOutFlag())) {
                            calcVO.setInOutNum(ComputeUtil.safeAdd((BigDecimal)calcVO.getInOutNum(), (BigDecimal)rmatFlowEntity.getRentNum()));
                        } else {
                            calcVO.setInOutNum(ComputeUtil.safeSub((BigDecimal)calcVO.getInOutNum(), (BigDecimal)rmatFlowEntity.getRentNum()));
                        }
                    }
                    map.put(key, calcVO);
                }
                if (!map.isEmpty()) {
                    result.addAll(map.values());
                }
            }
            if (CollectionUtils.isNotEmpty(flowList)) {
                for (RmatFlowEntity rmatFlowEntity : flowList) {
                    CommonResponse commonResponse;
                    if (!infoMap.containsKey(rmatFlowEntity.getInfoId()) && (commonResponse = this.cmContractInfoApi.queryLeaseContractInfoById(rmatFlowEntity.getContractId())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                        for (CmContractInfoVO infoVO : (List)commonResponse.getData()) {
                            infoMap.put(infoVO.getPkContractinfo(), infoVO);
                        }
                    }
                    RentReportCalcVO rentReportCalcVO = new RentReportCalcVO();
                    this.transferVO(rmatFlowEntity, rentReportCalcVO, projectRegisterVO, infoMap);
                    if ("4, 5".contains(rmatFlowEntity.getFlowType())) {
                        rentReportCalcVO.setBillType((String)billTypeMap.get(rmatFlowEntity.getFlowType() + rmatFlowEntity.getUseStatus()));
                    } else {
                        rentReportCalcVO.setBillType((String)billTypeMap.get(rmatFlowEntity.getFlowType()));
                    }
                    rentReportCalcVO.setBillCode(rmatFlowEntity.getBillCode());
                    rentReportCalcVO.setBillDate(rmatFlowEntity.getDetailDate());
                    rentReportCalcVO.setBillCreateTime(DateUtil.formatDate(rmatFlowEntity.getBillCreateTime()));
                    rentReportCalcVO.setRentEndDate(end);
                    if ("0".equals(rmatFlowEntity.getUseStatus())) {
                        LambdaQueryWrapper qry = new LambdaQueryWrapper();
                        qry.eq(StopEntity::getContractId, (Object)rmatFlowEntity.getContractId());
                        qry.in(StopEntity::getBillState, new Object[]{"1,3"});
                        List stopEntities = this.stopService.list((Wrapper)qry);
                        List stopIdList = stopEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper query = new LambdaQueryWrapper();
                        query.in(StopDetailEntity::getStopId, stopIdList);
                        query.orderByDesc(StopDetailEntity::getStopTime);
                        query.last("limit 1");
                        StopDetailEntity stopDetailEntity = (StopDetailEntity)((Object)this.stopDetailService.getOne((Wrapper)query, false));
                        rentReportCalcVO.setStopPrice(stopDetailEntity.getStopPrice());
                    }
                    if ("1,3".contains(rmatFlowEntity.getFlowType())) {
                        rentReportCalcVO.setInOutNum(rmatFlowEntity.getRentNum());
                    } else {
                        rentReportCalcVO.setInOutNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)rmatFlowEntity.getRentNum()));
                    }
                    result.add(rentReportCalcVO);
                }
            }
        }
        return this.fullPriceAndMny(result, priceMap);
    }

    private void transferVO(RmatFlowEntity detail, RentReportCalcVO vo, ProjectRegisterVO projectRegisterVO, Map<String, CmContractInfoVO> infoMap) {
        vo.setId(IdWorker.getId());
        vo.setProjectId(detail.getProjectId());
        vo.setProjectCode(projectRegisterVO.getCode());
        vo.setProjectName(detail.getProjectName());
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setContractInfoId(detail.getInfoId());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgName(detail.getOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());
        vo.setParentOrgId(projectRegisterVO.getOrgId());
        vo.setParentOrgName(projectRegisterVO.getOrgName());
        vo.setRealCorpId(projectRegisterVO.getRealCorpId());
        vo.setRealNcCorp(projectRegisterVO.getRealNcCorp());
        vo.setRealCorpName(projectRegisterVO.getRealCorpName());
        vo.setSourceDetailId(detail.getSourceDetailId());
        vo.setRentUnitId(detail.getRentUnitId());
        vo.setRentUnitName(detail.getRentUnitName());
        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setMaterialSourceId(detail.getMaterialSourceId());
        vo.setSpec(detail.getSpec());
        vo.setTaxRate(infoMap.get(vo.getContractInfoId()).getSl());
    }

    private List<RentReportCalcVO> fullPriceAndMny(List<RentReportCalcVO> calcList, Map<String, List<ContInfoPriceRecordVO>> priceMap) {
        ArrayList<RentReportCalcVO> result = new ArrayList<RentReportCalcVO>();
        for (RentReportCalcVO calcVO : calcList) {
            List<ContInfoPriceRecordVO> priceRecordVOS;
            List<ContInfoPriceRecordVO> list = priceRecordVOS = priceMap.containsKey(calcVO.getContractInfoId()) ? priceMap.get(calcVO.getContractInfoId()) : this.contInfoPriceRecordService.qryByContId(calcVO.getContractId(), calcVO.getContractInfoId());
            if (CollectionUtils.isNotEmpty(priceRecordVOS)) {
                int anInt;
                for (int i = anInt = this.findInt(calcVO.getBillDate(), priceRecordVOS); i < priceRecordVOS.size(); ++i) {
                    RentReportCalcVO newCalcVO = (RentReportCalcVO)((Object)BeanMapper.map((Object)((Object)calcVO), RentReportCalcVO.class));
                    newCalcVO.setId(IdWorker.getId());
                    newCalcVO.setStartPrice(priceRecordVOS.get(i).getNhireprice());
                    if (i != anInt) {
                        newCalcVO.setBillDate(priceRecordVOS.get(i).getDactivedate());
                        newCalcVO.setBillCreateTime(DateUtil.formatDate(priceRecordVOS.get(i).getDmakedate()));
                    }
                    if (i + 1 <= priceRecordVOS.size() - 1) {
                        Date calcEndDate = DateUtil.addDays(priceRecordVOS.get(i + 1).getDactivedate(), -1);
                        if (newCalcVO.getRentEndDate().compareTo(calcEndDate) < 0) {
                            result.add(newCalcVO);
                            break;
                        }
                        newCalcVO.setRentEndDate(calcEndDate);
                    }
                    result.add(newCalcVO);
                }
            } else {
                result.add(calcVO);
            }
            priceMap.put(calcVO.getContractInfoId(), priceRecordVOS);
        }
        for (RentReportCalcVO calcVO : result) {
            calcVO.setPrice(ComputeUtil.safeSub((BigDecimal)calcVO.getStartPrice(), (BigDecimal)calcVO.getStopPrice()));
            calcVO.setRentDayNum(BigDecimal.valueOf(DateUtil.getSubDay(calcVO.getRentEndDate(), calcVO.getBillDate()).intValue()));
            calcVO.setMny(ComputeUtil.safeMultiply((BigDecimal)calcVO.getRentDayNum(), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)calcVO.getPrice(), (BigDecimal)calcVO.getInOutNum())));
            calcVO.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)calcVO.getMny(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)calcVO.getTaxRate(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)BigDecimal.ONE)));
        }
        return result;
    }

    private int findInt(Date date, List<ContInfoPriceRecordVO> priceRecordVOS) {
        int k = 0;
        for (int i = 0; i < priceRecordVOS.size(); ++i) {
            ContInfoPriceRecordVO recordVO = priceRecordVOS.get(i);
            if (date.compareTo(recordVO.getDactivedate()) < 0) continue;
            k = i;
        }
        return k;
    }
}

