/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.LeaseInfoPriceRecordVO;
import com.ejianc.business.rmat.bean.ContInfoPriceRecordEntity;
import com.ejianc.business.rmat.bean.PriceFlowEntity;
import com.ejianc.business.rmat.mapper.ContInfoPriceRecordMapper;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.ContInfoPriceRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contInfoPriceRecordService")
public class ContInfoPriceRecordServiceImpl
extends BaseServiceImpl<ContInfoPriceRecordMapper, ContInfoPriceRecordEntity>
implements IContInfoPriceRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;

    @Override
    public ContInfoPriceRecordVO queryDetail(Long id) {
        ContInfoPriceRecordEntity entity = (ContInfoPriceRecordEntity)((Object)this.selectById(id));
        ContInfoPriceRecordVO vo = (ContInfoPriceRecordVO)BeanMapper.map((Object)((Object)entity), ContInfoPriceRecordVO.class);
        return vo;
    }

    @Override
    public List<ContInfoPriceRecordVO> qryByContId(String pkContract, String pkContractInfo) {
        String key;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContInfoPriceRecordEntity::getPkContract, (Object)pkContract);
        queryWrapper.eq(ContInfoPriceRecordEntity::getPkLeaselist, (Object)pkContractInfo);
        queryWrapper.orderByAsc(ContInfoPriceRecordEntity::getDactivedate);
        List list = this.list((Wrapper)queryWrapper);
        HashSet<String> set = new HashSet<String>();
        ContInfoPriceRecordEntity priceRecordEntity = null;
        ContInfoPriceRecordEntity priceCheckRecordEntity = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ContInfoPriceRecordEntity recordEntity : list) {
                set.add(recordEntity.getPkContract() + "@" + format.format(recordEntity.getDactivedate()) + "@" + recordEntity.getNhireprice().stripTrailingZeros());
                if (!recordEntity.getCheckFlag().booleanValue()) continue;
                priceCheckRecordEntity = recordEntity;
            }
            priceRecordEntity = (ContInfoPriceRecordEntity)((Object)list.get(0));
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PriceFlowEntity::getFlowType, (Object)1);
        query.ne(PriceFlowEntity::getBillTypeCode, (Object)"BT230606000000001");
        query.eq(PriceFlowEntity::getInfoId, (Object)pkContractInfo);
        query.orderByAsc(PriceFlowEntity::getDetailDate);
        query.last("limit 1");
        PriceFlowEntity priceFlowEntity = (PriceFlowEntity)((Object)this.priceFlowService.getOne((Wrapper)query, false));
        ArrayList<ContInfoPriceRecordEntity> recordEntities = new ArrayList<ContInfoPriceRecordEntity>();
        CommonResponse response = this.cmContractInfoApi.queryLeasePriceById(pkContract, pkContractInfo);
        this.logger.error(JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            try {
                if (!(null == priceFlowEntity || null != priceRecordEntity && priceRecordEntity.getDactivedate().compareTo(priceFlowEntity.getDetailDate()) <= 0 || set.contains(key = pkContract + "@" + format.format(priceFlowEntity.getDetailDate()) + "@" + priceFlowEntity.getPrice().stripTrailingZeros()) || format.parse(((LeaseInfoPriceRecordVO)((List)response.getData()).get(0)).getDactivedate()).compareTo(priceFlowEntity.getDetailDate()) <= 0)) {
                    if (null != priceCheckRecordEntity) {
                        priceCheckRecordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                        priceCheckRecordEntity.setNhireprice(priceFlowEntity.getPrice());
                        priceCheckRecordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                        priceCheckRecordEntity.setTs(priceFlowEntity.getDetailDate());
                        recordEntities.add(priceCheckRecordEntity);
                    } else {
                        ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                        recordEntity.setPkContract(pkContract);
                        recordEntity.setPkLeaselist(pkContractInfo);
                        recordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                        recordEntity.setNhireprice(priceFlowEntity.getPrice());
                        recordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                        recordEntity.setTs(priceFlowEntity.getDetailDate());
                        recordEntity.setPeriodFlag(false);
                        recordEntity.setCheckFlag(true);
                        recordEntities.add(recordEntity);
                    }
                    set.add(key);
                }
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage());
            }
            for (LeaseInfoPriceRecordVO recordVO : (List)response.getData()) {
                String key2 = recordVO.getPkContract() + "@" + recordVO.getDactivedate() + "@" + recordVO.getNhireprice().stripTrailingZeros();
                if (set.contains(key2)) continue;
                ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                recordEntity.setPkContract(pkContract);
                recordEntity.setPkLeaselist(pkContractInfo);
                recordEntity.setNhireprice(recordVO.getNhireprice());
                recordEntity.setPeriodFlag(false);
                recordEntity.setCheckFlag(false);
                try {
                    recordEntity.setDmakedate(format.parse(recordVO.getDmakedate()));
                    recordEntity.setDactivedate(format.parse(recordVO.getDactivedate()));
                    recordEntity.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(recordVO.getTs()));
                }
                catch (ParseException e) {
                    this.logger.error(e.getMessage());
                }
                recordEntities.add(recordEntity);
            }
        } else if (!(null == priceFlowEntity || null != priceRecordEntity && priceRecordEntity.getDactivedate().compareTo(priceFlowEntity.getDetailDate()) <= 0 || set.contains(key = pkContract + "@" + format.format(priceFlowEntity.getDetailDate()) + "@" + priceFlowEntity.getPrice().stripTrailingZeros()))) {
            if (null != priceCheckRecordEntity) {
                priceCheckRecordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                priceCheckRecordEntity.setNhireprice(priceFlowEntity.getPrice());
                priceCheckRecordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                priceCheckRecordEntity.setTs(priceFlowEntity.getDetailDate());
                recordEntities.add(priceCheckRecordEntity);
            } else {
                ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                recordEntity.setPkContract(pkContract);
                recordEntity.setPkLeaselist(pkContractInfo);
                recordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                recordEntity.setNhireprice(priceFlowEntity.getPrice());
                recordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                recordEntity.setTs(priceFlowEntity.getDetailDate());
                recordEntity.setPeriodFlag(false);
                recordEntity.setCheckFlag(true);
                recordEntities.add(recordEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(recordEntities)) {
            this.saveOrUpdateBatch(recordEntities);
        }
        recordEntities.addAll(list);
        List result = BeanMapper.mapList(recordEntities, ContInfoPriceRecordVO.class);
        Collections.sort(result, Comparator.comparing(ContInfoPriceRecordVO::getDactivedate));
        return result;
    }
}

