/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.bean.ExitDetailEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.bean.RestituteScrapEntity;
import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.bean.StartDetailEntity;
import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.bean.StopDetailEntity;
import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.RmatFlowMapper;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.util.CmContractUtil;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rmatFlowService")
public class RmatFlowServiceImpl
extends BaseServiceImpl<RmatFlowMapper, RmatFlowEntity>
implements IRmatFlowService {
    @Autowired
    private CmContractUtil contUtil;

    @Override
    public Boolean insertFlow(List<RmatFlowVO> vos) {
        ArrayList<RmatFlowVO> addList = new ArrayList<RmatFlowVO>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        Map<Long, CmContractInfoVO> infoMap = this.contUtil.getInfoMap(vos.get(0).getContractId());
        for (RmatFlowVO vo : vos) {
            vo.setId(vo.getSourceDetailId());
            this.contUtil.getInfoVO(infoMap, vo.getMaterialId(), vo.getMaterialTypeId(), vo);
            if (!"del".equals(vo.getRowState())) {
                addList.add(vo);
                continue;
            }
            delIds.add(vo.getId());
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            List list = BeanMapper.mapList(addList, RmatFlowEntity.class);
            super.saveOrUpdateBatch((Collection)list);
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds);
        }
        return true;
    }

    @Override
    public Boolean insertStopFlow(StopEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<StopDetailEntity> detailList = entity.getDetailList();
        for (StopDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopTime());
            vo.setBillCreateTime(entity.getCreateTime());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u505c\u7528.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));
            vo.setDetailDate(detail.getStopTime());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.insertFlow(flowList);
    }

    @Override
    public Boolean insertStartFlow(StartEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<StartDetailEntity> detailList = entity.getDetailList();
        for (StartDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStartTime());
            vo.setBillCreateTime(entity.getCreateTime());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u542f\u7528.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));
            vo.setDetailDate(detail.getStartTime());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.insertFlow(flowList);
    }

    @Override
    public Boolean insertExitFlow(ExitEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<ExitDetailEntity> detailList = entity.getExitDetail();
        for (ExitDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getExitDate());
            vo.setBillCreateTime(entity.getCreateTime());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u9000\u573a.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);
            vo.setUseStatus(detail.getState());
            vo.setDetailDate(detail.getStopDate());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getRentRecordOutNum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealOutNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentOutNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.insertFlow(flowList);
    }

    @Override
    public Boolean insertRestFlow(RestituteEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<RestituteScrapEntity> detailList = entity.getRestituteDetailList();
        for (RestituteScrapEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getRestituteDate());
            vo.setBillCreateTime(entity.getCreateTime());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u8d54\u507f.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);
            vo.setUseStatus(detail.getUseStatus());
            vo.setDetailDate(detail.getStopDate());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getRentRecordNum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealScrapNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getDamageNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, String billTypeCode) {
        if (CollectionUtils.isEmpty(sourceIds)) {
            return true;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in((Object)"source_id", sourceIds);
        ew.eq((Object)"bill_type_code", (Object)billTypeCode);
        return super.remove((Wrapper)ew);
    }
}

