package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.PeriodEntity;
import com.ejianc.business.rmat.service.IPeriodService;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.business.rmat.vo.PeriodDetailVO;
import com.ejianc.business.rmat.vo.PeriodVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 期初录入单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("period")
public class PeriodController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPeriodService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PeriodVO> saveOrUpdate(@RequestBody PeriodVO periodVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(periodVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PeriodVO> queryDetail(Long id) {
    	PeriodEntity entity = service.selectById(id);
    	PeriodVO vo = BeanMapper.map(entity, PeriodVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PeriodVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PeriodVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<PeriodEntity> page = service.queryPage(param,false);
        IPage<PeriodVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PeriodVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PeriodEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Period-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPeriodData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PeriodDetailVO>> refPeriodData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String contractId = null;
        Long orgId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                contractId = String.valueOf(conditionMap.get("contractId"));
            }
            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        Map<Long, PeriodDetailVO> detailMap = service.refList(contractId, orgId);
        List<PeriodDetailVO> list = new ArrayList<>();
        if(!detailMap.isEmpty()){
            for (Long key : detailMap.keySet()) {
                PeriodDetailVO detailVO = detailMap.get(key);
                if(StringUtils.isBlank(searchText) || detailVO.getMaterialName().contains(searchText) || detailVO.getMaterialCode().contains(searchText)){
                    list.add(detailVO);
                }
            }
        }

        IPage<PeriodDetailVO> page = new Page<>();
        page.setCurrent(StringUtils.isNotBlank(searchObject)?1:pageNumber);
        page.setSize(pageSize);
        page.setTotal(list.size());
        list = PageUtil.listToPage(list, StringUtils.isNotBlank(searchObject) ? 1 : pageNumber, pageSize);
        page.setRecords(list);
        return CommonResponse.success("查询参照数据成功！", page);
     }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "period-import.xlsx", "期初导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
            return service.excelImport(request, response);
    }

}
