package com.ejianc.business.rmat.service;

import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.vo.CalculateDailyVO;
import com.ejianc.business.rmat.vo.CalculateVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 租金计算单
 *
 * @author generator
 *
 */
public interface ICalculateService extends IBaseService<CalculateEntity> {

    CalculateVO saveOrUpdate(CalculateVO saveOrUpdateVO);

    String validateTime(CalculateVO vo, String type);

    CalculateVO autoCalculate(CalculateVO vo);

    List<RestituteVO> queryRestituteData(QueryParam param, String contractId, String lastRentDate, String rentDate);

    Date getLastRentDate(String contractId);

    List<CalculateDailyEntity> dailyQueryList(Date startDate, Date endDate);

}
