package com.ejianc.business.rmat.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.vo.PeriodDetailVO;
import com.ejianc.business.rmat.vo.PeriodVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.rmat.bean.PeriodEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 期初录入单
 *
 * @author generator
 *
 */
public interface IPeriodService extends IBaseService<PeriodEntity> {

    PeriodVO saveOrUpdate(PeriodVO periodVO);

    Boolean insertPriceFlow(PeriodEntity entity, String billTypeCode);

    Boolean insertFlow(PeriodEntity entity, String billTypeCode, Integer effectiveState);

    Boolean delPriceFlow(List<Long> ids, String billTypeCode);

    Boolean delFlow(List<Long> ids, String billTypeCode);

    void delete(List<PeriodVO> vos);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    Map<Long, PeriodDetailVO> refList(String contractId, Long orgId);

    Boolean insertPriceRecord(PeriodEntity entity);

    Boolean delPriceRecord(String pkContract);
}
