package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.enums.SignTypeEnum;
import com.ejianc.business.rmat.mapper.PeriodMapper;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.vo.*;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 期初录入单
 *
 * @author generator
 *
 */
@Service("periodService")
public class PeriodServiceImpl extends BaseServiceImpl<PeriodMapper, PeriodEntity> implements IPeriodService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private IArchivesService archivesService;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;
    @Autowired
    private IMaterialApi materialApi;

    private static final String BILL_CODE = "RMAT_PERIOD";

    @Override
    public PeriodVO saveOrUpdate(PeriodVO periodVO) {
        LambdaQueryWrapper<CalculateEntity> query = new LambdaQueryWrapper<>();
        query.eq(CalculateEntity::getProjectId, periodVO.getProjectId());
        query.eq(CalculateEntity::getContractId, periodVO.getContractId());
        if (calculateService.count(query) > 0) {
            throw new BusinessException("同一项目的同一合同已做过租金计算，不允许做期初录入！");
        }
        LambdaQueryWrapper<PeriodEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ne(null != periodVO.getId(), PeriodEntity::getId, periodVO.getId());
        queryWrapper.eq(PeriodEntity::getProjectId, periodVO.getProjectId());
        queryWrapper.eq(PeriodEntity::getContractId, periodVO.getContractId());
        if (count(queryWrapper) > 0) {
            throw new BusinessException("同一项目的同一合同已做过期初录入，不能多次制单！");
        }
        PeriodEntity entity = BeanMapper.map(periodVO, PeriodEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        saveOrUpdate(entity, false);

        PeriodEntity periodEntity = BeanMapper.map(entity, PeriodEntity.class);
        for (PeriodDetailVO detailVO : periodVO.getDetailList()) {
            if("del".equals(detailVO.getRowState())){
                periodEntity.getDetailList().add(BeanMapper.map(detailVO, PeriodDetailEntity.class));
            }
        }
        insertFlow(periodEntity, "BT230606000000001", RmatCommonConsts.NO);

        return BeanMapper.map(entity, PeriodVO.class);
    }

    @Override
    public Boolean insertPriceFlow(PeriodEntity entity, String billTypeCode) {
        List<PriceFlowVO> flowList = new ArrayList<>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for (PeriodDetailEntity detail : detailList) {
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setProjectId(entity.getProjectId());// 项目
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractName(entity.getContractName());
            vo.setBillDate(new Date());// 业务日期
            vo.setEffectiveDate(new Date());// 生效日期默认当前日期
            vo.setFlowType(detail.getFlowType());
            vo.setUseStatus(detail.getUseStatus());// 启用
            vo.setDetailDate(detail.getRentDate());// 明细业务日期
            vo.setInfoId(detail.getNcDetailId());// 合同清单主键
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setPrice(RmatCommonConsts.NO.equals(detail.getUseStatus()) ? detail.getStopPrice() : detail.getNprice());
            vo.setTaxPrice(RmatCommonConsts.NO.equals(detail.getUseStatus()) ? detail.getStopTaxPrice() :detail.getNtaxprice());;
            vo.setTaxRate(detail.getTaxrate());
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return priceFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean insertFlow(PeriodEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for (PeriodDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setBillCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setProjectId(entity.getProjectId());// 项目
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));// 经办人
            vo.setEmployeeName(InvocationInfoProxy.getUsercode());
            vo.setBillDate(new Date());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            vo.setFlowType(detail.getFlowType());
            vo.setInOutFlag(detail.getInOutFlag());
            vo.setUseStatus(detail.getUseStatus());
            vo.setDetailDate(detail.getRentDate());// 明细业务日期
            vo.setInfoId(detail.getNcDetailId());// 合同清单主键
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitId());// 档案单位
            vo.setUnitName(detail.getUnit());
            vo.setNum(detail.getCheckNumsSum());// 档案数量
            vo.setRealUnitId(detail.getRealUnitId());// 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());// 实物数量
            vo.setRealTransScale(detail.getRealTransScale());// 实物转换系数
            vo.setRentUnitId(detail.getRentUnitId());// 计租单位
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());// 计租数量
            vo.setRentTransScale(detail.getRentTransScale());// 计租转换系数
            vo.setSignRowType(detail.getSignRowType());// 合同签订方式
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return rmatFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean delPriceFlow(List<Long> ids, String billTypeCode) {
        return priceFlowService.delFlow(ids, billTypeCode);
    }

    @Override
    public Boolean delFlow(List<Long> ids, String billTypeCode) {
        return rmatFlowService.delFlow(ids, billTypeCode);
    }

    @Override
    public void delete(List<PeriodVO> vos) {
        List<Long> idList = vos.stream().map(PeriodVO::getId).collect(Collectors.toList());
        delFlow(idList, "BT230606000000001");
        removeByIds(idList, true);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        String contractId = request.getParameter("contractId");
        Long orgId = Long.valueOf(request.getParameter("orgId"));
        Map<Long, PeriodDetailVO> refMap = refList(contractId, orgId);
        Map<String, PeriodDetailVO> resultMap = refMap.values().stream().collect(Collectors.toMap(PeriodDetailVO::getMaterialCode, Function.identity(), (key1, key2) -> key1));
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Map<String, MaterialVO> codeCtyMap = new HashMap<>();
        //固定放一个value，用来存放
        // 1. htywnr: 签物资分类合同的所有物资分类内码合并字符串
        // 2. memo: 签物资明细合同的所有物资编码合并字符串
        String allInnerCodeStr = refMap.get(Long.valueOf("9527")).getHtywnr();
        String allMatCodeStr = refMap.get(Long.valueOf("9527")).getMemo();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            Map<String, String> bussTypeMap = new HashMap<>();
            bussTypeMap.put("进场", FlowTypeEnum.验收.getFlowType() + "@1@1@0");
            bussTypeMap.put("启用", FlowTypeEnum.启用.getFlowType() + "@1@1@1");
            bussTypeMap.put("停用", FlowTypeEnum.停用.getFlowType() + "@0@1@2");
            bussTypeMap.put("退场-启用", FlowTypeEnum.退场.getFlowType() + "@1@2@3");
            bussTypeMap.put("退场-停用", FlowTypeEnum.退场.getFlowType() + "@0@2@4");
            bussTypeMap.put("报废-启用", FlowTypeEnum.赔偿.getFlowType() + "@1@2@5");
            bussTypeMap.put("报废-停用", FlowTypeEnum.赔偿.getFlowType() + "@0@2@6");
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result.size() > 0 && result.get(0).size() < 5) {
                return CommonResponse.error("数据不完整，请下载最新模板！");
            }
            List<PeriodDetailVO> successList = new ArrayList<>();
            List<PeriodDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<PeriodDetailVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PeriodDetailVO vo = new PeriodDetailVO();
                    boolean flag = false;
                    String warnType = "";

                    String bussType = datas.get(0);
                    String materialCode = datas.get(1);
                    String bussDate = datas.get(2);
                    String rentNum = datas.get(3);
                    String stopPrice = datas.get(4);

                    vo.setImportMatCode(materialCode);
                    if (StringUtils.isEmpty(materialCode)) {//物资编码为空
                        vo.setMaterialCode(null);
                        warnType = warnType + "[物资编码为空]";
                        flag = true;
                    } else {
                        MaterialVO materialVO = null;
                        if(codeCtyMap.containsKey(materialCode)){
                            materialVO = codeCtyMap.get(materialCode);
                            if(!allMatCodeStr.contains(materialCode) && !allInnerCodeStr.contains(String.valueOf(materialVO.getCategoryId()))){
                                vo.setMaterialCode(null);
                                warnType = warnType + "[该物资编码不在合同清单范围，请核对合同清单]";
                                flag = true;
                            }else if(!resultMap.containsKey(materialCode)){
                                vo.setMaterialCode(null);
                                warnType = warnType + "[该物资编码不在周转材档案，请联系公司管理员添加]";
                                flag = true;
                            } else {
                                vo = BeanMapper.map(resultMap.get(materialCode), PeriodDetailVO.class);
                            }
                        }else {
                            CommonResponse<List<MaterialVO>> commonResponse = materialApi.queryMaterialListByCodes(Arrays.asList(new String[]{materialCode}));
                            if (!commonResponse.isSuccess() || CollectionUtils.isEmpty(commonResponse.getData())) {
                                vo.setMaterialCode(null);
                                warnType = warnType + "[该物资编码不在物料档案]";
                                flag = true;
                            }else {
                                materialVO = commonResponse.getData().get(0);
                                codeCtyMap.put(materialVO.getCode(), materialVO);
                                if(!allMatCodeStr.contains(materialCode) && !allInnerCodeStr.contains(String.valueOf(materialVO.getCategoryId()))){
                                    vo.setMaterialCode(null);
                                    warnType = warnType + "[该物资编码不在合同清单范围，请核对合同清单]";
                                    flag = true;
                                }else if(!resultMap.containsKey(materialCode)){
                                    vo.setMaterialCode(null);
                                    warnType = warnType + "[该物资编码不在周转材档案，请联系公司管理员添加]";
                                    flag = true;
                                } else {
                                    vo = BeanMapper.map(resultMap.get(materialCode), PeriodDetailVO.class);
                                }
                            }
                        }
                    }

                    vo.setId(IdWorker.getId());

                    vo.setImportBusiType(bussType);
                    if (StringUtils.isEmpty(bussType)) {
                        vo.setFlowType(null);
                        vo.setUseStatus(null);
                        vo.setInOutFlag(null);
                        warnType = warnType + "[业务类型为空]";
                        flag = true;
                    } else if(!bussTypeMap.containsKey(bussType)){
                        vo.setFlowType(null);
                        vo.setUseStatus(null);
                        vo.setInOutFlag(null);
                        warnType = warnType + "[业务类型名称不匹配]";
                        flag = true;
                    } else {
                        String[] split = bussTypeMap.get(bussType).split("@");
                        vo.setFlowType(split[0]);
                        vo.setUseStatus(split[1]);
                        vo.setInOutFlag(Integer.valueOf(split[2]));
                        vo.setBusiType(split[3]);
                    }

                    if (StringUtils.isEmpty(bussDate)) {
                        vo.setRentDate(null);
                        warnType = warnType + "[业务日期为空]";
                        flag = true;
                    } else {
                        try {
                            vo.setRentDate(new SimpleDateFormat("yyyy-MM-dd").parse(bussDate));
                        } catch (Exception e) {
                            vo.setRentDate(null);
                            warnType = warnType + "[业务日期格式错误]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(rentNum)) {
                        vo.setRentNum(null);
                        warnType = warnType + "[数量为空]";
                        flag = true;
                    } else {
                        try {
                            vo.setRentNum(new BigDecimal(rentNum));
                            vo.setCheckNumsSum(ComputeUtil.safeDiv(vo.getRentNum(), vo.getRentTransScale()));
                            vo.setMny(ComputeUtil.safeMultiply(vo.getNprice(), vo.getCheckNumsSum()));
                            vo.setTaxmny(ComputeUtil.safeMultiply(vo.getNtaxprice(), vo.getCheckNumsSum()));
                            vo.setTax(ComputeUtil.safeSub(vo.getTaxmny(), vo.getMny()));
                            vo.setRealNum(ComputeUtil.safeDiv(vo.getCheckNumsSum(), vo.getRealTransScale()));
                        } catch (Exception e) {
                            vo.setRentNum(null);
                            warnType = warnType + "[数量只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if("0".equals(vo.getUseStatus())){
                        if (StringUtils.isEmpty(stopPrice)) {
                            vo.setStopPrice(null);
                            warnType = warnType + "[停用单价为空]";
                            flag = true;
                        } else {
                            try {
                                vo.setStopPrice(new BigDecimal(stopPrice));
                                vo.setStopTaxPrice(ComputeUtil.safeMultiply(vo.getStopPrice(), ComputeUtil.safeAdd(BigDecimal.ONE, ComputeUtil.safeDiv(vo.getTaxrate(), BigDecimal.valueOf(100)))));
                            } catch (Exception e) {
                                vo.setStopPrice(null);
                                warnType = warnType + "[停用单价只能为数字或小数]";
                                flag = true;
                            }
                        }
                    }


                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                for (PeriodDetailVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            successList.add(vo);
                        }
                    } else {
                        errorList.add(vo);
                    }
                }
                if (errorList.size() > 0) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }else{
                    resp.put("successList", successList);
                    resp.put("errorList", null);
                    resp.put("successNum", successList.size());
                    resp.put("errorNum", 0);
                }
            }
        }
        return CommonResponse.success(resp);
        }

    @Override
    public Map<Long, PeriodDetailVO> refList(String contractId, Long orgId) {
        Map<Long, PeriodDetailVO> detailMap = new HashMap<>();
        StringBuffer allInnerCodeStr = new StringBuffer();
        StringBuffer allMatCodeStr = new StringBuffer();
        CommonResponse<List<CmContractInfoVO>> response = cmContractInfoApi.queryLeaseContractInfoById(contractId);
        if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
            List<CmContractInfoVO> infoVOS = response.getData();
            Map<Long, CmContractInfoVO> materialMap = new HashMap<>();
            Map<Long, CmContractInfoVO> categoryMap= new HashMap<>();
            for(CmContractInfoVO infoVO : infoVOS){
                if(null != infoVO.getMaterialId()){
                    materialMap.put(infoVO.getMaterialId(), infoVO);
                    allMatCodeStr.append(infoVO.getMaterialCode());
                }else{
                    categoryMap.put(infoVO.getMaterialTypeId(), infoVO);
                    allInnerCodeStr.append(infoVO.getMaterialTypeInnerCode());
                }
            }

            if(!materialMap.isEmpty()){
                ArchivesVOS queryVO = new ArchivesVOS();
                queryVO.setMaterialIds(new ArrayList<>(materialMap.keySet()));
                queryVO.setOrgId(orgId);
                queryVO.setType(0);
                List<ArchivesVO> archivesVOS = archivesService.queryIds(queryVO);
                if (CollectionUtils.isNotEmpty(archivesVOS)) {
                    for(ArchivesVO archivesVO : archivesVOS){
                        if(!detailMap.containsKey(archivesVO.getMaterialId())){
                            CmContractInfoVO infoVO = materialMap.get(archivesVO.getMaterialId());
                            PeriodDetailVO periodDetailVO = new PeriodDetailVO();
                            periodDetailVO.setSignRowType(SignTypeEnum.明细.getCode());
                            convertToCheckDetail(periodDetailVO, infoVO, archivesVO);
                            detailMap.put(periodDetailVO.getMaterialId(), periodDetailVO);
                        }
                    }
                }
            }
            if(!categoryMap.isEmpty()){
                ArchivesVOS queryVO = new ArchivesVOS();
                queryVO.setCategoryIds(new ArrayList<>(categoryMap.keySet()));
                queryVO.setOrgId(orgId);
                queryVO.setType(1);
                List<ArchivesVO> archivesVOS = archivesService.queryIds(queryVO);
                if (CollectionUtils.isNotEmpty(archivesVOS)) {
                    for(ArchivesVO archivesVO : archivesVOS){
                        if(!detailMap.containsKey(archivesVO.getMaterialId()) && categoryMap.containsKey(archivesVO.getMaterialTypeId())){
                            CmContractInfoVO infoVO = categoryMap.get(archivesVO.getMaterialTypeId());
                            PeriodDetailVO periodDetailVO = new PeriodDetailVO();
                            periodDetailVO.setSignRowType(SignTypeEnum.分类.getCode());
                            convertToCheckDetail(periodDetailVO, infoVO, archivesVO);
                            detailMap.put(periodDetailVO.getMaterialId(), periodDetailVO);
                        }
                    }
                }
            }
        }

        //固定放一个value，用来存放
        // 1. htywnr: 签物资分类合同的所有物资分类内码合并字符串
        // 2. memo: 签物资明细合同的所有物资编码合并字符串
        PeriodDetailVO detailVO = new PeriodDetailVO();
        detailVO.setHtywnr(allInnerCodeStr.toString());
        detailVO.setMemo(allMatCodeStr.toString());
        detailMap.put(Long.valueOf("9527"), detailVO);
        return detailMap;
    }

    @Override
    public Boolean insertPriceRecord(PeriodEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getPriceList())) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            Date date = null;
            try {
                date = ft.parse("1990-01-01");
            } catch (ParseException e) {
                logger.error(e.getMessage());
            }
            List<ContInfoPriceRecordEntity> recordEntities = new ArrayList<>();
            for(PeriodPriceEntity priceEntity : entity.getPriceList()) {
                ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                recordEntity.setPkContract(entity.getContractId());
                recordEntity.setPkLeaselist(priceEntity.getNcDetailId());
                recordEntity.setPkAmountlist(priceEntity.getPkAmountlist());
                recordEntity.setDmakedate(priceEntity.getCreateTime());
                recordEntity.setNhireprice(priceEntity.getNprice());
                recordEntity.setDactivedate(date);
                recordEntity.setTs(new Date());
                recordEntity.setPeriodFlag(true);
                recordEntity.setCheckFlag(false);
                recordEntities.add(recordEntity);
            }
            if (CollectionUtils.isNotEmpty(recordEntities)) {
                contInfoPriceRecordService.saveOrUpdateBatch(recordEntities);
            }
        }
        return true;
    }

    @Override
    public Boolean delPriceRecord(String pkContract) {
        LambdaUpdateWrapper<ContInfoPriceRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ContInfoPriceRecordEntity::getPeriodFlag, true);
        updateWrapper.eq(ContInfoPriceRecordEntity::getPkContract, pkContract);
        return  contInfoPriceRecordService.remove(updateWrapper);
    }

    private void convertToCheckDetail(PeriodDetailVO detailVO, CmContractInfoVO infoVO, ArchivesVO archivesVO){
        detailVO.setId(archivesVO.getId());
        detailVO.setNcDetailId(infoVO.getPkContractinfo());
        detailVO.setPkAmountlist(infoVO.getPkAmountlist());
        detailVO.setHtywnr(infoVO.getAmountname());
        detailVO.setNtaxprice(BigDecimal.valueOf(infoVO.getTaxhireprice()));
        detailVO.setTaxrate(infoVO.getSl());
        detailVO.setNprice(BigDecimal.valueOf(infoVO.getHireprice()));
        detailVO.setMaterialId(archivesVO.getMaterialId());
        detailVO.setMaterialCode(archivesVO.getMaterialCode());
        detailVO.setMaterialName(archivesVO.getMaterialName());
        detailVO.setMaterialSourceId(archivesVO.getMaterialSourceId());
        detailVO.setMaterialTypeId(archivesVO.getMaterialTypeId());
        detailVO.setMaterialTypeName(archivesVO.getMaterialTypeName());
        detailVO.setUnit(archivesVO.getUnitName());
        detailVO.setUnitId(archivesVO.getUnitId());
        detailVO.setSpec(archivesVO.getSpec());
        detailVO.setRentUnitId(infoVO.getPkContmeasdoc());
        detailVO.setRentUnitName(infoVO.getInfounit());
        detailVO.setRentTransScale(NumberUtils.createBigDecimal(infoVO.getMngScale()));
        detailVO.setRealUnitId(archivesVO.getRealUnitId());
        detailVO.setRealUnitName(archivesVO.getRealUnitName());
        detailVO.setRealTransScale(archivesVO.getTransScale());

        detailVO.setCheckNumsSum(BigDecimal.valueOf(infoVO.getInfonum()));
        detailVO.setMny(ComputeUtil.safeMultiply(detailVO.getNprice(), detailVO.getCheckNumsSum()));
        detailVO.setTaxmny(ComputeUtil.safeMultiply(detailVO.getNtaxprice(), detailVO.getCheckNumsSum()));
        detailVO.setTax(ComputeUtil.safeSub(detailVO.getTaxmny(), detailVO.getMny()));
    }
}
