package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.mapper.RestituteMapper;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.HttpTookit;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.business.rmat.vo.ExitGFVO;
import com.ejianc.business.rmat.vo.RestituteMaintainVO;
import com.ejianc.business.rmat.vo.RestituteScrapVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 退赔单
 *
 * @author generator
 */
@Service("restituteService")
public class RestituteServiceImpl extends BaseServiceImpl<RestituteMapper, RestituteEntity> implements IRestituteService {
    @Autowired
    private IMaterialService materialService;

    @Value("${openApi.wjRestituteUrl}")
    private String wjRestituteUrl;

    @Value("${openApi.wjRestituteDeleteUrl}")
    private String wjRestituteDeleteUrl;

    @Value("${common.env.base-host}")
    private String baseHost;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.赔偿单.getCode();
    private static final String BILL_NAME = BillTypeEnum.赔偿单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/restitute/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/restitute/billDel";

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<RestituteEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的退赔单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     *
     * @param restituteVO
     * @return
     */
    @Override
    public String validateTime(RestituteVO restituteVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", restituteVO.getContractId());
        if (restituteVO.getId() != null) {
            params.put("billType", MaterialConstant.退赔单);
            params.put("billId", restituteVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        if (lastDate == null) return "未获取最大租金计算日期！";
        for (RestituteScrapVO scrapVO : restituteVO.getRestituteDetailList()) {
            if (DateUtil.compareDate(scrapVO.getStopDate(), lastDate) < 0) {
                throw new BusinessException(DateUtil.formatDate(scrapVO.getStopDate())
                        + "小于等于最大租金计算日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }

        /*for(RestituteDetailVO vo : restituteVO.getRestituteDetailList()){
            if(ValidateUtil.compareDate(vo.getDate(), lastDate, maxTimeMap,vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getDate())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }*/
        return "校验通过！";
    }

//    @Override
//    public boolean pushBillToSupCenter(RestituteEntity entity) {
//        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
//                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
//        return syncFlag;
//    }
//
//    @Override
//    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
//        String billId = request.getParameter("billId");
//        RestituteEntity entity = super.selectById(billId);
//        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
//                RestituteEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
//        return msg;
//    }
//
//    @Override
//    public boolean delPushBill(RestituteEntity entity) {
//        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
//                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
//        return delSuc;
//    }

    /**
     * 推送供方
     *
     * @Param headers: headers
     * @Param exitApplyEntity:  实体
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     **/
    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, RestituteEntity restituteEntity) {
        String url = wjRestituteUrl;

        RestituteVO restituteVO = BeanMapper.map(restituteEntity, RestituteVO.class);
        restituteVO.setSysmark("xpt");
        restituteVO.setPkProject(restituteVO.getProjectSourceId());
        restituteVO.setPkSupplier(restituteVO.getSupplierSourceId());
/*        restituteVO.setId(restituteEntity.getId());// 主键
        restituteVO.setOrgId(restituteEntity.getOrgId());
        // 组织主键   传来源组织主键
        restituteVO.setOrgName(restituteEntity.getOrgName());
        restituteVO.setProjectId(restituteEntity.getProjectId());// 项目主键    传来源项目主键
        restituteVO.setProjectName(restituteEntity.getProjectName());
        restituteVO.setBillCode(restituteEntity.getBillCode());// 编码
        restituteVO.setSupplierId(restituteEntity.getSupplierId());// 供应商主键     传来源供应商主键
        restituteVO.setSupplierName(restituteEntity.getSupplierName());
        restituteVO.setContractId(restituteEntity.getContractId());// 合同主键
        restituteVO.setContractName(restituteEntity.getContractName());
        restituteVO.setContractCode(restituteEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        restituteVO.setRestituteDate(formatter.format(restituteEntity.get()));//退赔日期
        restituteVO.setExitDesc(restituteEntity.getExitDesc());
        restituteVO.setLinkName(restituteEntity.getLinkName());
        restituteVO.setLinkTelephone(restituteEntity.getLinkTelephone());
        restituteVO.setConfirmFlag(0);
        restituteVO.setPkCreator("hnxpt");
        restituteVO.setSysmark("hnxpt");
        restituteVO.setCreatorName("五局新平台");
        restituteVO.setCreatorDate(DateFormater.getInstance().format(DateFormater.LONG_FORMAT));
        CommonResponse<List<AttachmentVO>> sceneurRes = attachmentApi.queryListBySourceId(restituteEntity.getId(), "BT210816000000005", "showImg", null);
        logger.info("---cccccccc:" + JSONObject.toJSONString(sceneurRes));
        List<String> sceneurlList = new ArrayList<>();
        if (sceneurRes.isSuccess()) {
            sceneurlList.addAll(sceneurRes.getData().stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(sceneurlList)) {
                restituteVO.setSceneurl(String.join(",", sceneurlList));
            }
        }

        if (CollectionUtils.isNotEmpty(restituteEntity.getExitApplyDetailEntityList())) {
            List<ExitApplyDetailGFVO> list = new ArrayList<>();
            restituteEntity.getExitApplyDetailEntityList().forEach(e -> {
                //非末级才需要同步
                ExitApplyDetailGFVO exitApplyDetailGFVO = new ExitApplyDetailGFVO();
                exitApplyDetailGFVO.setId(String.valueOf(e.getId()));// 子表主键
                exitApplyDetailGFVO.setpId(String.valueOf(restituteEntity.getId()));// 主表主键
                exitApplyDetailGFVO.setMaterialTypeId(String.valueOf(e.getMaterialTypeId()));
                exitApplyDetailGFVO.setMaterialTypeName(e.getMaterialTypeName());
                exitApplyDetailGFVO.setMaterialId(e.getMaterialSourceId());// 材料主键 传来源主键
                exitApplyDetailGFVO.setMaterialCode(e.getMaterialCode());// 材料编码"
                exitApplyDetailGFVO.setMaterialName(e.getMaterialName());// 材料名称
                exitApplyDetailGFVO.setSpec(e.getSpec());// 规格型号
                exitApplyDetailGFVO.setUnit(e.getUnitName());// 单位
                exitApplyDetailGFVO.setOffRentDate(formatter.format(e.getOffRentDate()));
                exitApplyDetailGFVO.setOnRentNum(e.getRentNum() == null ? BigDecimal.ZERO : e.getRentNum());
                exitApplyDetailGFVO.setApplyExitNum(e.getRentExitNum() == null ? BigDecimal.ZERO : e.getRentExitNum());
                //exitApplyDetailGFVO.setExitedNum(e.getExitedNum() == null ? BigDecimal.ZERO : e.getExitedNum());//已退场数量 改造之后没有该数量
                exitApplyDetailGFVO.setMemo(e.getMemo());
                exitApplyDetailGFVO.setRealExitNum(e.getRealExitNum());
                exitApplyDetailGFVO.setRentExitNum(e.getRentExitNum());
                list.add(exitApplyDetailGFVO);
            });
            restituteVO.setExitApplyDetails(list);
        }*/
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(restituteVO).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            String back = HttpTookit.postByJson(url, JSONObject.toJSON(restituteVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                //修改为已推送
                LambdaUpdateWrapper<RestituteEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(RestituteEntity::getPushFlag, 1);
                updateWrapper.set(RestituteEntity::getCommitId, InvocationInfoProxy.getUserid().toString());
                updateWrapper.eq(RestituteEntity::getId, restituteVO.getId());
                boolean flag = update(updateWrapper);
                if (!flag) {
                    throw new BusinessException("推送状态更新失败！");
                }
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("message"));
            }
        } catch (Exception e) {
            return CommonResponse.error("推送供方赔偿单异常!");
        }
    }


    /**
     * 修改确认状态
     *
     * @param
     * @Param :
     * @Return
     */
    @Override
    public CommonResponse<RestituteVO> updateConfirmFlag(RestituteVO restituteVO) {
        RestituteEntity entity = super.getById(restituteVO.getId());
        entity.setConfirmFlag(restituteVO.getConfirmFlag());//确认状态
        entity.setConfirmDate(DateFormater.getCurrentDate());//确认时间
        entity.setSupOperatorName(restituteVO.getSupOperatorName());//确认人
        entity.setConfirmNote(restituteVO.getConfirmNote());//确认说明
        //拒绝单据改为自由态
        if (restituteVO.getConfirmFlag() == 2) {
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        super.saveOrUpdate(entity, false);
        //组织消息参数
        List<String> receiver = new ArrayList<>();
        receiver.add(String.valueOf(entity.getCommitId()));
        String formurl = baseHost + "cscec5b-rmat-frontend/#/restitute/card?id=" + entity.getId();
        String subject = "您的赔偿单【" + entity.getProjectName() + "--" + entity.getBillCode() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + entity.getSupplierName() + "】" + (restituteVO.getConfirmFlag() == 1 ? "确认" : "拒绝") + " 。";
        String content = "您的赔偿单【" + entity.getProjectName() + "--" + entity.getBillCode() + "】已经在" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT) + "被供应商【" + entity.getSupplierName() + "】" + (restituteVO.getConfirmFlag() == 1 ? "确认" : "拒绝") + "。<a href=" + '"' + formurl + '"' + ">前往点击</a>";

        //装载消息信息
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_WJY});
        parameter.setReceivers(receiver.toArray(new String[receiver.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(String.valueOf(entity.getTenantId()));
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        //String linkUrl = wjyPath + "cscec5bhn-wzxt-mobile/#/walkoffApplyIndex/details?id=" + entity.getId() + "&userid={userid}";
        logger.info(">>>>>>开始发送消息:  , 接收人id : {}, baseHost : {}", entity.getCommitId(), baseHost);
        //commonSupportService.sendMsg(parameter, linkUrl);
        logger.info(">>>>>>发送消息结束:  , 接收人id : {}, baseHost : {}", entity.getCommitId(), baseHost);
        return CommonResponse.success();
    }


    @Override
    public CommonResponse<String> pushDelete(Map<String, String> headers, RestituteEntity entity) {
        String url = wjRestituteDeleteUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(entity.getId()));// 主键

        String back = null;
        try {
            logger.info("---url:" + url);
            logger.info("---入参:" + JSONObject.toJSON(purchase).toString());
            logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON(purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject(back);
            logger.info("---回参:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                //调用同步方法成功
                return CommonResponse.success();
            } else {
                //调用同步方法失败，输出错误信息
                return CommonResponse.error(jsonBack.getString("msg"));
            }
        } catch (Exception e) {
            return CommonResponse.error("删除供方赔偿单异常!");
        }
    }

}
