package com.ejianc.business.rmat.controller;

import java.io.Serializable;

import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.StopDetailEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.CalculateVO;
import com.ejianc.business.rmat.vo.StopDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.service.IStopService;
import com.ejianc.business.rmat.vo.StopVO;

/**
 * 停租单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stop")
public class StopController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String STOP_CODE = "STOP_CODE";//此处需要根据实际修改

    @Autowired
    private IStopService service;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IProjectApi projectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StopVO> saveOrUpdate(@RequestBody StopVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        materialService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.停用单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        service.validateTime(saveOrUpdateVO, MaterialConstant.保存);
        StopEntity entity = BeanMapper.map(saveOrUpdateVO, StopEntity.class);
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(STOP_CODE, InvocationInfoProxy.getTenantid());
        if (null == saveOrUpdateVO.getId()) {
            entity.setBillCode(codeBatchByRuleCode.getData());
            List<Long> projectId = new ArrayList<>();
            projectId.add(entity.getProjectId());
            CommonResponse<List<ProjectRegisterVO>> projectRegisterVO = projectApi.queryProjectByIds(projectId);
            if(projectRegisterVO.getCode() == 0 && projectRegisterVO.getData()!= null){
                entity.setOrgId(projectRegisterVO.getData().get(0).getProjectDepartmentId());
                CommonResponse<OrgVO> orgVo = iOrgApi.detailById(entity.getOrgId());
                entity.setOrgCode(orgVo.getData().getCode());
                entity.setOrgName(orgVo.getData().getName());
                if (orgVo.getData().getParentId()!=null){
                    entity.setParentOrgId(orgVo.getData().getParentId());
                }else {
                    entity.setParentOrgId(entity.getOrgId());
                }
            }else{
                throw new BusinessException("网络异常，未获取到项目部主键");
            }
        }

        // 汇总材料分类
        List<StopDetailVO> detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeName(materialTypeNames);

        List<StopDetailEntity> detailDelList = new ArrayList<>();
        for(StopDetailEntity detailEntity : entity.getDetailList()){
            if ("del".equals(detailEntity.getRowState())) {
                detailDelList.add(detailEntity);
            }
        }

    	service.saveOrUpdate(entity, false);
        // 插入未生效租赁流水
        //保存后把删除的行过滤掉了，在这里重新加上
        entity.getDetailList().addAll(detailDelList);
        rmatFlowService.insertStopFlow(entity, BillTypeEnum.停用单.getCode(), RmatCommonConsts.NO);
    	return CommonResponse.success("保存或修改单据成功！", BeanMapper.map(service.selectById(entity.getId()), StopVO.class));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StopVO> queryDetail(Long id) {
        StopEntity entity = service.selectById(id);
        StopVO vo = BeanMapper.map(entity, StopVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StopVO> vos) {
        List<Long> ids = vos.stream().map(StopVO::getId).collect(Collectors.toList());
        // 删除租赁流水
        if(!rmatFlowService.delFlow(ids, BillTypeEnum.停用单.getCode())){
            return CommonResponse.error("单据删除流水失败！");
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StopVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("materialTypeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<StopEntity> page = service.queryPage(param,false);
        IPage<StopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), StopVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StopEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<StopVO> voList = BeanMapper.mapList(list, StopVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("stop-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refStopData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StopVO>> refStopData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StopEntity> page = service.queryPage(param,false);
        IPage<StopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StopVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询上级组织
     * @param orgId
     */
    @RequestMapping(value = "/queryParentOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(iOrgApi.detailById(orgId).getData().getParentId());
        return CommonResponse.success(orgVO.getData());
    }

    /**
     * @Description validateContract 校验合同下是否存在未生效单据
     * @param contractId 合同ID
     * @param billId 单据主键
     *               废弃
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") String contractId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateContract(contractId, billId);
        return CommonResponse.success("校验成功！", msg);
    }
}
