package com.ejianc.business.rmat.mapper;

import com.ejianc.business.rmat.vo.ReportDailyVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.rmat.bean.ReportDailyEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 日租金报表
 *
 * @author generator
 *
 */
@Mapper
public interface ReportDailyMapper extends BaseCrudMapper<ReportDailyEntity> {

    @Select("SELECT project_id as projectId, SUM(rent_tax_mny) as sumRentTaxMny,  SUM(rent_mny) as sumRentMny FROM `ejc_rmat_calculate` WHERE bill_state IN (1,3) group by project_id")
    List<ReportDailyVO> getCaclMny();

    @Select("SELECT a.project_id as projectId, SUM(b.damage_tax_mny) as sumScrapTaxMny,  SUM(b.damage_mny) as sumScrapMny FROM `ejc_rmat_restitute_scrap` b left join `ejc_rmat_restitute` a on b.restitute_id=a.id  WHERE a.bill_state IN (1,3) group by a.project_id")
    List<ReportDailyVO> getRestitueMny();

    @Select("SELECT a.project_id as projectId, SUM(b.maintain_tax_mny) as sumRepairTaxMny,  SUM(b.maintain_mny) as sumRepairMny FROM `ejc_rmat_restitute_maintain` b left join `ejc_rmat_restitute` a on b.restitute_id=a.id  WHERE a.bill_state IN (1,3) group by a.project_id")
    List<ReportDailyVO> getRepairMny();

    @Select("SELECT a.project_id as projectId, SUM(b.current_tax_amount) as sumOtherTaxMny,  SUM(b.current_amount) as sumOtherMny FROM `ejc_rmat_restitute_other` b left join `ejc_rmat_restitute` a on b.restitute_id=a.id  WHERE a.bill_state IN (1,3) group by a.project_id")
    List<ReportDailyVO> getPcOtherMny();

    @Select("SELECT a.project_id as projectId, SUM(b.tax_mny) as sumOtherTaxMny,  SUM(b.mny) as sumOtherMny FROM `ejc_rmat_calculate_other` b left join `ejc_rmat_calculate` a on b.calculate_id=a.id  WHERE a.bill_state IN (1,3) group by a.project_id")
    List<ReportDailyVO> getCalcOtherMny();

}
