package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.business.rmat.vo.StartDetailVO;
import com.ejianc.business.rmat.vo.StartVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.StartMapper;
import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.service.IStartService;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 再起租单
 *
 * @author generator
 *
 */
@Service("startService")
public class StartServiceImpl extends BaseServiceImpl<StartMapper, StartEntity> implements IStartService{

    @Autowired
    private IMaterialService materialService;

    @Override
    public String validateTime(StartVO startVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", startVO.getContractId());
        if(startVO.getId() != null){
            params.put("billType", MaterialConstant.启用单);
            params.put("billId", startVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        if (lastDate == null) {
            return "未获取最大租金计算日期！";
        }
        for (StartDetailVO detailVO : startVO.getDetailList()) {
            if(DateUtil.compareDate(detailVO.getStartTime(), lastDate) < 0){
                throw new BusinessException(DateUtil.formatDate(detailVO.getStartTime())
                        + "小于等于最大租金计算日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }


    @Override
    public String validateContract(String contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<StartEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的再启租单，不允许新增!");
        }
        return "校验通过！";
    }
}
