/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.PriceFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialStateEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.CalculateMapper;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.CalculateDailyVO;
import com.ejianc.business.rmat.vo.CalculateVO;
import com.ejianc.business.rmat.vo.ContInfoPriceRecordVO;
import com.ejianc.business.rmat.vo.MaterialFlowVO;
import com.ejianc.business.rmat.vo.MaterialVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="calculateService")
public class CalculateServiceImpl
extends BaseServiceImpl<CalculateMapper, CalculateEntity>
implements ICalculateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private IPriceFlowService priceService;
    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;
    private static final String BILL_CODE = "CSCEC_RMAT_CALCULATE";
    private static final String BILL_NAME = BillTypeEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName();

    @Override
    public CalculateVO saveOrUpdate(CalculateVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(CalculateEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper.eq(CalculateEntity::getContractId, (Object)saveOrUpdateVO.getContractId());
        queryWrapper.eq(CalculateEntity::getRentDate, (Object)saveOrUpdateVO.getRentDate());
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u7684\u540c\u4e00\u5408\u540c\u5728\u6240\u9009\u65e5\u671f\u5df2\u505a\u8fc7\u79df\u91d1\u8ba1\u7b97\uff0c\u4e0d\u80fd\u591a\u6b21\u5236\u5355\uff01");
        }
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        CalculateEntity entity = (CalculateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CalculateEntity.class));
        entity.setNcSettleFlag(0);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
            for (int i = 0; i < entity.getDailyList().size(); ++i) {
                entity.getDailyList().get(i).setSequence(i + 1);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (CalculateVO)BeanMapper.map((Object)((Object)entity), CalculateVO.class);
    }

    @Override
    public String validateTime(CalculateVO vo, String type) {
        Date lastDate;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", vo.getContractId());
        if (vo.getId() != null) {
            params.put("billType", BILL_NAME);
            params.put("billId", vo.getId());
        }
        if ((lastDate = this.materialService.getLastDate(params)) == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff01";
        }
        if (DateUtil.compareDate(vo.getRentDate(), lastDate) < 0) {
            throw new BusinessException(DateUtil.formatDate(vo.getRentDate()) + "\u5c0f\u4e8e\u7b49\u4e8e\u6700\u5927\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CalculateVO autoCalculate(CalculateVO vo) {
        List checkList;
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getRentDate() == null) {
            throw new BusinessException("\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String contractId = vo.getContractId();
        Date endDate = DateUtil.endOfDate(vo.getRentDate());
        this.logger.info("\u5f00\u59cb\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (null != vo.getId()) {
            param.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(param, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("rentDate", "desc");
        List lastList = super.queryList(param, false);
        Date startDate = null;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            CalculateEntity last = (CalculateEntity)((Object)lastList.get(0));
            startDate = DateUtil.beginOfDate(DateUtil.dayAddOne(last.getRentDate()));
        }
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u7269\u6599\u4fe1\u606fstart");
        List<MaterialVO> reportList = this.materialService.queryCalculateList(contractId, startDate, endDate);
        if (CollectionUtils.isEmpty(reportList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u7269\u6599\u5165\u573a\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reportList));
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        CalculateEntity entity = new CalculateEntity();
        ArrayList<CalculateDailyEntity> dailyList = new ArrayList<CalculateDailyEntity>();
        ArrayList<CalculateDailyVO> dailyVOList = new ArrayList<CalculateDailyVO>();
        for (MaterialVO materialVO : reportList) {
            this.packParameterDetail(dailyVOList, startDate, endDate, materialVO);
        }
        this.setRentalDayDetailValue(dailyVOList, dailyList, contractId);
        entity.setDailyList(this.dealDailyList(dailyList, contractId));
        this.addTotalLine(entity);
        this.setRentalValue(entity);
        this.logger.info(">>>>\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u7ed3\u675f\uff0c\u8f93\u51fa\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return (CalculateVO)BeanMapper.map((Object)((Object)entity), CalculateVO.class);
    }

    private void addTotalLine(CalculateEntity entity) {
        ArrayList<CalculateDailyEntity> result = new ArrayList<CalculateDailyEntity>();
        if (CollectionUtils.isEmpty(entity.getDailyList())) {
            return;
        }
        String contInfoId = entity.getDailyList().get(0).getInfoId();
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        for (CalculateDailyEntity dailyEntity : entity.getDailyList()) {
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)dailyEntity.getDailyRentMny());
            totalTaxMny = ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)dailyEntity.getDailyRentTaxMny());
            if (null != contInfoId && !contInfoId.equals(dailyEntity.getInfoId())) {
                CalculateDailyEntity newDailyEntity = new CalculateDailyEntity();
                newDailyEntity.setId(IdWorker.getId());
                newDailyEntity.setContractId(entity.getContractId());
                newDailyEntity.setContractName(entity.getContractName());
                newDailyEntity.setInfoId(contInfoId);
                newDailyEntity.setMaterialName("\u5c0f\u8ba1");
                newDailyEntity.setDailyRentMny(mny);
                newDailyEntity.setDailyRentTaxMny(taxMny);
                result.add(newDailyEntity);
                contInfoId = dailyEntity.getInfoId();
                mny = BigDecimal.ZERO;
                taxMny = BigDecimal.ZERO;
            }
            mny = ComputeUtil.safeAdd((BigDecimal)mny, (BigDecimal)dailyEntity.getDailyRentMny());
            taxMny = ComputeUtil.safeAdd((BigDecimal)taxMny, (BigDecimal)dailyEntity.getDailyRentTaxMny());
            result.add(dailyEntity);
        }
        CalculateDailyEntity newDailyEntity = new CalculateDailyEntity();
        newDailyEntity.setId(IdWorker.getId());
        newDailyEntity.setContractId(entity.getContractId());
        newDailyEntity.setContractName(entity.getContractName());
        newDailyEntity.setInfoId(contInfoId);
        newDailyEntity.setMaterialName("\u5c0f\u8ba1");
        newDailyEntity.setDailyRentMny(mny);
        newDailyEntity.setDailyRentTaxMny(taxMny);
        result.add(newDailyEntity);
        CalculateDailyEntity totalDailyEntity = new CalculateDailyEntity();
        totalDailyEntity.setId(IdWorker.getId());
        totalDailyEntity.setContractId(entity.getContractId());
        totalDailyEntity.setContractName(entity.getContractName());
        totalDailyEntity.setInfoId(contInfoId);
        totalDailyEntity.setMaterialName("\u5408\u8ba1");
        totalDailyEntity.setDailyRentMny(totalMny);
        totalDailyEntity.setDailyRentTaxMny(totalTaxMny);
        result.add(totalDailyEntity);
        entity.setDailyList(result);
    }

    private List<CalculateDailyEntity> dealDailyList(List<CalculateDailyEntity> dailyList, String contractId) {
        ArrayList<CalculateDailyEntity> result = new ArrayList<CalculateDailyEntity>();
        HashMap<String, List<ContInfoPriceRecordVO>> priceMap = new HashMap<String, List<ContInfoPriceRecordVO>>();
        HashSet<Long> materialSet = new HashSet<Long>();
        for (CalculateDailyEntity dailyEntity : dailyList) {
            List<ContInfoPriceRecordVO> priceRecordVOS;
            List<ContInfoPriceRecordVO> list = priceRecordVOS = priceMap.containsKey(dailyEntity.getInfoId()) ? (List<ContInfoPriceRecordVO>)priceMap.get(dailyEntity.getInfoId()) : this.contInfoPriceRecordService.qryByContId(contractId, dailyEntity.getInfoId());
            if (CollectionUtils.isNotEmpty(priceRecordVOS)) {
                int anInt;
                for (int i = anInt = this.findInt(dailyEntity.getStartDate(), priceRecordVOS); i < priceRecordVOS.size(); ++i) {
                    CalculateDailyEntity newDailyEntity = (CalculateDailyEntity)((Object)BeanMapper.map((Object)((Object)dailyEntity), CalculateDailyEntity.class));
                    newDailyEntity.setId(IdWorker.getId());
                    newDailyEntity.setUnitPrice(priceRecordVOS.get(i).getNhireprice());
                    if (i != anInt) {
                        newDailyEntity.setStartDate(priceRecordVOS.get(i).getDactivedate());
                    } else if (materialSet.contains(dailyEntity.getMaterialId())) {
                        newDailyEntity.setPeriodNum(null);
                    }
                    if (i + 1 <= priceRecordVOS.size() - 1) {
                        Date calcEndDate = DateUtil.endOfDate(DateUtil.addDays(priceRecordVOS.get(i + 1).getDactivedate(), -1));
                        if (newDailyEntity.getEndDate().compareTo(calcEndDate) < 0) {
                            result.add(newDailyEntity);
                            break;
                        }
                        newDailyEntity.setEndDate(calcEndDate);
                    }
                    if (newDailyEntity.getStartDate().compareTo(newDailyEntity.getEndDate()) > 0) continue;
                    result.add(newDailyEntity);
                }
            } else {
                result.add(dailyEntity);
            }
            materialSet.add(dailyEntity.getMaterialId());
            priceMap.put(dailyEntity.getInfoId(), priceRecordVOS);
        }
        ArrayList<CalculateDailyEntity> resultDaily = new ArrayList<CalculateDailyEntity>();
        for (int i = 0; i < result.size(); ++i) {
            CalculateDailyEntity dailyEntity = (CalculateDailyEntity)((Object)result.get(i));
            dailyEntity.setRentDayDate(DateUtil.getSubDay(dailyEntity.getEndDate(), dailyEntity.getStartDate()));
            dailyEntity.setUnitTaxPrice(ComputeUtil.safeMultiply((BigDecimal)dailyEntity.getUnitPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)dailyEntity.getTaxRate(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)BigDecimal.ONE)));
            dailyEntity.setStopUnitTaxPrice(ComputeUtil.safeMultiply((BigDecimal)dailyEntity.getStopUnitPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeDiv((BigDecimal)dailyEntity.getTaxRate(), (BigDecimal)BigDecimal.valueOf(100L)), (BigDecimal)BigDecimal.ONE)));
            if ("0".equals(dailyEntity.getUseStatus())) {
                dailyEntity.setDailyRentMny(ComputeUtil.scaleTwo((BigDecimal)this.getMny(dailyEntity.getUnitPrice(), dailyEntity.getRentDayDate(), dailyEntity.getRentNum())));
                dailyEntity.setDailyRentTaxMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)dailyEntity.getDailyRentMny(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)dailyEntity.getTaxRate(), (BigDecimal)BigDecimal.valueOf(100L))))));
                dailyEntity.setDailyTax(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)dailyEntity.getDailyRentTaxMny(), (BigDecimal)dailyEntity.getDailyRentMny())));
            } else if ("1".equals(dailyEntity.getUseStatus())) {
                dailyEntity.setDailyRentMny(ComputeUtil.scaleTwo((BigDecimal)this.getMny(dailyEntity.getStopUnitPrice(), dailyEntity.getRentDayDate(), dailyEntity.getRentNum())));
                dailyEntity.setDailyRentTaxMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)dailyEntity.getDailyRentMny(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)dailyEntity.getTaxRate(), (BigDecimal)BigDecimal.valueOf(100L))))));
                dailyEntity.setDailyTax(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)dailyEntity.getDailyRentTaxMny(), (BigDecimal)dailyEntity.getDailyRentMny())));
            }
            resultDaily.add(dailyEntity);
        }
        return resultDaily;
    }

    private int findInt(Date date, List<ContInfoPriceRecordVO> priceRecordVOS) {
        int k = 0;
        for (int i = 0; i < priceRecordVOS.size(); ++i) {
            ContInfoPriceRecordVO recordVO = priceRecordVOS.get(i);
            if (date.compareTo(recordVO.getDactivedate()) < 0) continue;
            k = i;
        }
        return k;
    }

    private void setRentalDayDetailValue(List<CalculateDailyVO> resultList, List<CalculateDailyEntity> dailyList, String contractId) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        List<String> materialIds = resultList.stream().filter(x -> x.getMaterialId() != null).map(x -> String.valueOf(x.getMaterialId())).collect(Collectors.toList());
        List<PriceFlowEntity> mateList = this.getPriceFlowList(contractId, "materialId", materialIds);
        Map<String, PriceFlowEntity> mateStartMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.YES), false, mateList);
        Map<String, PriceFlowEntity> mateStopMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.NO), false, mateList);
        Set infoIds = resultList.stream().filter(x -> x.getMaterialId() == null).map(CalculateDailyVO::getInfoId).collect(Collectors.toSet());
        List<PriceFlowEntity> infoList = this.getPriceFlowList(contractId, "infoId", new ArrayList<String>(infoIds));
        Map<String, PriceFlowEntity> infoStartMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.YES), true, infoList);
        Map<String, PriceFlowEntity> infoStopMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.NO), true, infoList);
        for (CalculateDailyVO vo : resultList) {
            CalculateDailyEntity entity = new CalculateDailyEntity();
            entity.setContractId(vo.getContractId());
            entity.setProjectId(vo.getProjectId());
            entity.setContractName(vo.getContractName());
            entity.setSupplierName(vo.getSupplierName());
            entity.setInfoId(vo.getInfoId());
            entity.setMaterialTypeId(vo.getMaterialTypeId());
            entity.setMaterialTypeName(vo.getMaterialTypeName());
            entity.setMaterialId(vo.getMaterialId());
            entity.setMaterialCode(vo.getMaterialCode());
            entity.setMaterialName(vo.getMaterialName());
            entity.setMaterialSourceId(vo.getMaterialSourceId());
            entity.setSpec(vo.getSpec());
            entity.setUnitId(vo.getUnitId());
            entity.setUnitName(vo.getUnitName());
            entity.setRealUnitId(vo.getRealUnitId());
            entity.setRealUnitName(vo.getRealUnitName());
            entity.setRealTransScale(vo.getRealTransScale());
            entity.setRentUnitId(vo.getRentUnitId());
            entity.setRentUnitName(vo.getRentUnitName());
            entity.setRentTransScale(vo.getRentTransScale());
            entity.setPeriodNum(vo.getPeriodNum());
            entity.setCheckNum(vo.getCheckNum());
            entity.setExitNum(vo.getExitNum());
            entity.setScrapNum(vo.getScrapNum());
            entity.setStopNum(vo.getStopNum());
            if (vo.getMaterialId() == null) {
                String infoId = vo.getInfoId();
                if (infoStartMap.containsKey(infoId)) {
                    entity.setUnitTaxPrice(infoStartMap.get(infoId).getTaxPrice());
                    entity.setUnitPrice(infoStartMap.get(infoId).getPrice());
                    entity.setTaxRate(infoStartMap.get(infoId).getTaxRate());
                }
                if (infoStopMap.containsKey(infoId)) {
                    entity.setStopUnitTaxPrice(infoStopMap.get(infoId).getTaxPrice());
                    entity.setStopUnitPrice(infoStopMap.get(infoId).getPrice());
                    entity.setTaxRate(infoStopMap.get(infoId).getTaxRate());
                }
            } else {
                PriceFlowEntity priceFlowEntity;
                String key;
                String mmaterialId = String.valueOf(vo.getMaterialId());
                if (mateStartMap.containsKey(mmaterialId)) {
                    entity.setUnitTaxPrice(mateStartMap.get(mmaterialId).getTaxPrice());
                    entity.setUnitPrice(mateStartMap.get(mmaterialId).getPrice());
                    entity.setTaxRate(mateStartMap.get(mmaterialId).getTaxRate());
                }
                if (mateStopMap.containsKey(key = mmaterialId + "@" + new SimpleDateFormat("yyyyMMdd").format(vo.getStartDate()))) {
                    priceFlowEntity = mateStopMap.get(key);
                    entity.setStopUnitTaxPrice(priceFlowEntity.getTaxPrice());
                    entity.setStopUnitPrice(priceFlowEntity.getPrice());
                    entity.setTaxRate(priceFlowEntity.getTaxRate());
                } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                    entity.setCheckNum(null);
                    entity.setExitNum(null);
                    entity.setScrapNum(null);
                    entity.setStopNum(null);
                    priceFlowEntity = this.getStopPriceFlow(mateStopMap, vo);
                    entity.setStopUnitTaxPrice(priceFlowEntity.getTaxPrice());
                    entity.setStopUnitPrice(priceFlowEntity.getPrice());
                    entity.setTaxRate(priceFlowEntity.getTaxRate());
                }
            }
            entity.setStartDate(vo.getStartDate());
            entity.setEndDate(vo.getEndDate());
            entity.setNum(vo.getNum());
            entity.setUseStatus(String.valueOf(vo.getMaterialState() - 2));
            entity.setRentDayDate(DateUtil.getSubDay(vo.getEndDate(), vo.getStartDate()));
            if (MaterialStateEnum.\u542f\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getStopUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getStopUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            }
            entity.setDailyTax(ComputeUtil.safeSub((BigDecimal)entity.getDailyRentTaxMny(), (BigDecimal)entity.getDailyRentMny()));
            entity.setRentNum(vo.getNum());
            entity.setNum(null);
            entity.setId(IdWorker.getId());
            entity.setRowState("add");
            if (null == entity.getRentNum() || ComputeUtil.isLessOrEqual((BigDecimal)entity.getRentNum(), (BigDecimal)BigDecimal.ZERO) && ComputeUtil.isEmpty((BigDecimal)entity.getExitNum()).booleanValue() && ComputeUtil.isEmpty((BigDecimal)entity.getScrapNum()).booleanValue()) continue;
            dailyList.add(entity);
        }
        if (CollectionUtils.isNotEmpty(dailyList)) {
            dailyList.sort(Comparator.comparing(CalculateDailyEntity::getMaterialTypeId).thenComparing(CalculateDailyEntity::getMaterialId, Comparator.nullsFirst(Long::compareTo)).thenComparing(CalculateDailyEntity::getStartDate));
        }
    }

    private PriceFlowEntity getStopPriceFlow(Map<String, PriceFlowEntity> priceMap, CalculateDailyVO vo) {
        Date closestDate = null;
        for (String key : priceMap.keySet()) {
            if (!key.contains(String.valueOf(vo.getMaterialId())) || !priceMap.get(key).getDetailDate().before(vo.getStartDate()) || closestDate != null && !priceMap.get(key).getDetailDate().after(closestDate)) continue;
            closestDate = priceMap.get(key).getDetailDate();
        }
        if (null != closestDate) {
            return priceMap.get(vo.getMaterialId() + "@" + new SimpleDateFormat("yyyyMMdd").format(closestDate));
        }
        return new PriceFlowEntity();
    }

    private Map<String, PriceFlowEntity> getPriceFlowMap(String useStatus, boolean isInfo, List<PriceFlowEntity> list) {
        Map<String, PriceFlowEntity> map = list.parallelStream().filter(x -> useStatus.equals(x.getUseStatus())).collect(Collectors.groupingBy(x -> isInfo ? x.getInfoId() : (String.valueOf(RmatCommonConsts.NO).equals(useStatus) ? x.getMaterialId() + "@" + new SimpleDateFormat("yyyyMMdd").format(x.getDetailDate()) : String.valueOf(x.getMaterialId())), Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> DateUtil.compareDate(c1.getCreateTime(), c2.getCreateTime()) > 0 ? c1 : c2), Optional::get)));
        return map;
    }

    private List<PriceFlowEntity> getPriceFlowList(String contractId, String fieldName, List<String> ids) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)contractId)) {
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        param.getOrderMap().put("createTime", "desc");
        List<PriceFlowEntity> list = new ArrayList<PriceFlowEntity>();
        if (CollectionUtils.isNotEmpty(ids)) {
            param.getParams().put(fieldName, new Parameter("in", ids));
            list = this.priceService.queryList(param);
        }
        return list;
    }

    private void setRentalValue(CalculateEntity entity) {
        BigDecimal rentMny = BigDecimal.ZERO;
        BigDecimal rentTaxMny = BigDecimal.ZERO;
        BigDecimal rentTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
            for (CalculateDailyEntity detail : entity.getDailyList()) {
                if (null == detail.getMaterialTypeId()) continue;
                rentMny = ComputeUtil.safeAdd((BigDecimal)rentMny, (BigDecimal)detail.getDailyRentMny());
                rentTaxMny = ComputeUtil.safeAdd((BigDecimal)rentTaxMny, (BigDecimal)detail.getDailyRentTaxMny());
                rentTax = ComputeUtil.safeAdd((BigDecimal)rentTax, (BigDecimal)detail.getDailyTax());
            }
        }
        entity.setDailyMny(rentMny);
        entity.setDailyTaxMny(rentTaxMny);
        entity.setDailyTax(rentTax);
        entity.setRentMny(rentMny);
        entity.setRentTaxMny(rentTaxMny);
        entity.setRentTax(rentTax);
    }

    private void packParameterDetail(List<CalculateDailyVO> resultList, Date lastDate, Date rentDate, MaterialVO materialVO) {
        List flowList = materialVO.getFlowList();
        ArrayList<CalculateDailyVO> result = new ArrayList<CalculateDailyVO>();
        ArrayList<MaterialFlowVO> beginList = materialVO.getBeginList();
        if (CollectionUtils.isEmpty((Collection)beginList) && CollectionUtils.isNotEmpty((Collection)flowList)) {
            MaterialFlowVO start = (MaterialFlowVO)BeanMapper.map(flowList.get(0), MaterialFlowVO.class);
            start.setNum(BigDecimal.ZERO);
            beginList = new ArrayList<MaterialFlowVO>(Arrays.asList(start));
            MaterialFlowVO stop = (MaterialFlowVO)BeanMapper.map((Object)start, MaterialFlowVO.class);
            stop.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
            stop.setUseStatus("0");
            beginList.add(stop);
        }
        if (CollectionUtils.isNotEmpty((Collection)beginList) && beginList.size() == 1 && CollectionUtils.isNotEmpty((Collection)flowList)) {
            MaterialFlowVO data = (MaterialFlowVO)BeanMapper.map(beginList.get(0), MaterialFlowVO.class);
            data.setNum(BigDecimal.ZERO);
            if ("0".equals(((MaterialFlowVO)beginList.get(0)).getUseStatus())) {
                data.setMaterialState(MaterialStateEnum.\u542f\u7528.getCode());
                data.setSourceType(MaterialStateEnum.\u542f\u7528.getDescription());
                data.setUseStatus("1");
            } else {
                data.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
                data.setSourceType(MaterialStateEnum.\u505c\u7528.getDescription());
                data.setUseStatus("0");
            }
            beginList.add(data);
        }
        if (CollectionUtils.isNotEmpty((Collection)beginList)) {
            for (MaterialFlowVO begin : beginList) {
                this.dealFlowList(materialVO, lastDate, rentDate, begin, CollectionUtils.isNotEmpty((Collection)flowList) ? (MaterialFlowVO)flowList.get(0) : null, result, null);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)flowList)) {
            flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            for (MaterialFlowVO begin : beginList) {
                for (int i = 0; i < flowList.size(); ++i) {
                    MaterialFlowVO detailVO = (MaterialFlowVO)flowList.get(i);
                    MaterialFlowVO detailVO1 = i == flowList.size() - 1 ? null : (MaterialFlowVO)flowList.get(i + 1);
                    this.dealFlowList(materialVO, lastDate, rentDate, detailVO, detailVO1, result, "1".equals(begin.getUseStatus()));
                }
            }
        }
        result.sort(Comparator.comparing(CalculateDailyVO::getStartDate));
        resultList.addAll(result);
        this.logger.info("\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(resultList));
    }

    private void dealFlowList(MaterialVO materialVO, Date lastDate, Date rentDate, MaterialFlowVO detailVO, MaterialFlowVO detailVO1, List<CalculateDailyVO> result, Boolean beginFlag) {
        if (detailVO1 != null) {
            this.setBeginNum(detailVO, detailVO1);
        }
        CalculateDailyVO vo = this.transferCacheVO(materialVO, detailVO, beginFlag);
        Date startDate = detailVO.getOperationDate();
        if (detailVO1 == null) {
            if (lastDate == null) {
                this.setValue(detailVO.getOperationDate(), rentDate, vo, result);
            } else if (DateUtil.compareDate(detailVO.getOperationDate(), lastDate) > 0) {
                if (DateUtil.compareDate(detailVO.getOperationDate(), rentDate) > 0) {
                    return;
                }
                this.setValue(startDate, rentDate, vo, result);
            } else {
                this.setValue(lastDate, rentDate, vo, result);
            }
        } else {
            Date endDate = DateUtil.endOfDate(DateUtil.daySubOne(detailVO1.getOperationDate()));
            if (lastDate == null) {
                if (DateUtil.compareDate(detailVO.getOperationDate(), rentDate) > 0) {
                    return;
                }
                if (DateUtil.compareDate(detailVO1.getOperationDate(), rentDate) > 0) {
                    this.setValue(startDate, rentDate, vo, result);
                } else {
                    this.setValue(startDate, endDate, vo, result);
                }
            } else if (DateUtil.compareDate(detailVO.getOperationDate(), lastDate) > 0) {
                if (DateUtil.compareDate(detailVO.getOperationDate(), rentDate) > 0) {
                    return;
                }
                if (DateUtil.compareDate(detailVO1.getOperationDate(), rentDate) > 0) {
                    this.setValue(startDate, rentDate, vo, result);
                } else {
                    this.setValue(startDate, endDate, vo, result);
                }
            } else if (DateUtil.compareDate(detailVO1.getOperationDate(), rentDate) > 0) {
                this.setValue(lastDate, rentDate, vo, result);
            } else {
                this.setValue(lastDate, endDate, vo, result);
            }
        }
    }

    private void setBeginNum(MaterialFlowVO detailVO, MaterialFlowVO detailVO1) {
        if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState()) || MaterialStateEnum.\u8d54\u507f.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            } else {
                detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            }
        } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(detailVO1.getMaterialState()) || MaterialStateEnum.\u542f\u7528.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setStartedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
                detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            } else {
                detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
                detailVO1.setStopedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            }
        } else if (MaterialStateEnum.\u5165\u573a.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setStartedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
                detailVO1.setStopedNum(detailVO.getStopedNum());
            } else {
                detailVO1.setStartedNum(detailVO.getStartedNum());
                detailVO1.setStopedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        if (fmt.format(detailVO.getOperationDate()).equals(fmt.format(detailVO1.getOperationDate()))) {
            if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState())) {
                if ("1".equals(detailVO1.getUseStatus())) {
                    detailVO1.setExitStartNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getExitStartNum(), (BigDecimal)detailVO1.getNum()));
                } else {
                    detailVO1.setExitStopNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getExitStopNum(), (BigDecimal)detailVO1.getNum()));
                }
            } else if (MaterialStateEnum.\u8d54\u507f.getCode().equals(detailVO1.getMaterialState())) {
                if ("1".equals(detailVO1.getUseStatus())) {
                    detailVO1.setScrapStartNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getScrapStartNum(), (BigDecimal)detailVO1.getNum()));
                } else {
                    detailVO1.setScrapStopNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getScrapStopNum(), (BigDecimal)detailVO1.getNum()));
                }
            } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(detailVO1.getMaterialState()) || MaterialStateEnum.\u542f\u7528.getCode().equals(detailVO1.getMaterialState())) {
                if ("1".equals(detailVO1.getUseStatus())) {
                    detailVO1.setStopNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopNum(), (BigDecimal)detailVO1.getNum()));
                } else {
                    detailVO1.setStopNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStopNum(), (BigDecimal)detailVO1.getNum()));
                }
            } else if (MaterialStateEnum.\u5165\u573a.getCode().equals(detailVO1.getMaterialState())) {
                detailVO1.setCheckNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getCheckNum(), (BigDecimal)detailVO1.getNum()));
            }
        } else if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setExitStartNum(detailVO1.getNum());
            } else {
                detailVO1.setExitStopNum(detailVO1.getNum());
            }
        } else if (MaterialStateEnum.\u8d54\u507f.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setScrapStartNum(detailVO1.getNum());
            } else {
                detailVO1.setScrapStopNum(detailVO1.getNum());
            }
        } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(detailVO1.getMaterialState()) || MaterialStateEnum.\u542f\u7528.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setStopNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)detailVO1.getNum()));
            } else {
                detailVO1.setStopNum(detailVO1.getNum());
            }
        } else if (MaterialStateEnum.\u5165\u573a.getCode().equals(detailVO1.getMaterialState())) {
            detailVO1.setCheckNum(detailVO1.getNum());
        }
    }

    private void setValue(Date startDate, Date endDate, CalculateDailyVO vo, List<CalculateDailyVO> result) {
        if (DateUtil.compareDate(startDate, endDate) > 0) {
            return;
        }
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        if (null == vo.getNum() || ComputeUtil.isLessOrEqual((BigDecimal)vo.getNum(), (BigDecimal)BigDecimal.ZERO) && ComputeUtil.isEmpty((BigDecimal)vo.getExitNum()).booleanValue() && ComputeUtil.isEmpty((BigDecimal)vo.getScrapNum()).booleanValue()) {
            return;
        }
        if (CollectionUtils.isEmpty(result) && null == vo.getPeriodNum()) {
            vo.setPeriodNum(this.calcPeriodNum(vo));
        }
        result.add(vo);
    }

    private BigDecimal calcPeriodNum(CalculateDailyVO dailyVO) {
        BigDecimal periodNum = dailyVO.getNum();
        if (null != dailyVO.getCheckNum()) {
            periodNum = ComputeUtil.safeSub((BigDecimal)periodNum, (BigDecimal)dailyVO.getCheckNum());
        } else if (null != dailyVO.getExitNum()) {
            periodNum = ComputeUtil.safeAdd((BigDecimal)periodNum, (BigDecimal)dailyVO.getExitNum());
        } else if (null != dailyVO.getScrapNum()) {
            periodNum = ComputeUtil.safeAdd((BigDecimal)periodNum, (BigDecimal)dailyVO.getScrapNum());
        }
        return periodNum;
    }

    private CalculateDailyVO transferCacheVO(MaterialVO materialVO, MaterialFlowVO detailVO, Boolean flag) {
        CalculateDailyVO vo = new CalculateDailyVO();
        vo.setContractId(materialVO.getContractId());
        vo.setProjectId(materialVO.getProjectId());
        vo.setContractName(materialVO.getContractName());
        vo.setSupplierName(materialVO.getSupplierName());
        vo.setMaterialId(materialVO.getMaterialId());
        vo.setMaterialCode(materialVO.getMaterialCode());
        vo.setMaterialName(materialVO.getMaterialName());
        vo.setMaterialSourceId(materialVO.getMaterialSourceId());
        vo.setInfoId(materialVO.getInfoId());
        vo.setMaterialTypeId(materialVO.getMaterialTypeId());
        vo.setMaterialTypeName(materialVO.getMaterialTypeName());
        vo.setSpec(materialVO.getSpec());
        vo.setUnitId(materialVO.getUnitId());
        vo.setUnitName(materialVO.getUnitName());
        vo.setRealUnitId(materialVO.getRealUnitId());
        vo.setRealUnitName(materialVO.getRealUnitName());
        vo.setRealTransScale(materialVO.getRealTransScale());
        vo.setRentUnitId(materialVO.getRentUnitId());
        vo.setRentUnitName(materialVO.getRentUnitName());
        vo.setRentTransScale(materialVO.getRentTransScale());
        vo.setParameterId(materialVO.getId());
        if (flag == null) {
            vo.setPeriodNum(detailVO.getNum());
            vo.setNum(detailVO.getNum());
            vo.setMaterialState(detailVO.getMaterialState());
        } else if (flag.booleanValue()) {
            vo.setNum(detailVO.getStartedNum());
            vo.setMaterialState(MaterialStateEnum.\u542f\u7528.getCode());
        } else {
            vo.setNum(detailVO.getStopedNum());
            vo.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
        }
        if (MaterialStateEnum.\u5165\u573a.getCode().equals(detailVO.getMaterialState())) {
            vo.setCheckNum(detailVO.getCheckNum());
        } else if (flag != null && MaterialStateEnum.\u542f\u7528.getCode().equals(detailVO.getMaterialState())) {
            vo.setStopNum(detailVO.getStopNum());
        } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(detailVO.getMaterialState())) {
            vo.setStopNum(detailVO.getStopNum());
        } else if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO.getMaterialState())) {
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                vo.setExitNum(detailVO.getExitStopNum());
                vo.setStopNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)detailVO.getExitStopNum()));
            } else {
                vo.setExitNum(detailVO.getExitStartNum());
            }
        } else if (MaterialStateEnum.\u8d54\u507f.getCode().equals(detailVO.getMaterialState())) {
            if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                vo.setScrapNum(detailVO.getScrapStopNum());
                vo.setStopNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)detailVO.getScrapStopNum()));
            } else {
                vo.setScrapNum(detailVO.getScrapStartNum());
            }
        }
        return vo;
    }

    private BigDecimal getMny(BigDecimal price, Integer days, BigDecimal num) {
        return ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal[])new BigDecimal[]{new BigDecimal(days), num});
    }

    @Override
    public List<RestituteVO> queryRestituteData(QueryParam param, String contractId, String lastRentDate, String rentDate) {
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("settleFlag", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        if (StringUtils.isBlank((CharSequence)lastRentDate)) {
            param.getParams().put("restituteDate", new Parameter("le", (Object)rentDate));
        } else {
            param.getParams().put("restituteDate", new Parameter("between", (Object)(lastRentDate + "," + rentDate)));
        }
        List list = this.restituteService.queryList(param);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<RestituteVO>();
        }
        return BeanMapper.mapList((Iterable)list, RestituteVO.class);
    }

    @Override
    public Date getLastRentDate(String contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("rentDate", "desc");
        List lastList = super.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            return ((CalculateEntity)((Object)lastList.get(0))).getRentDate();
        }
        return null;
    }

    @Override
    public List<CalculateDailyEntity> dailyQueryList(Date startDate, Date endDate) {
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u7269\u6599\u4fe1\u606fstart");
        List<MaterialVO> reportList = this.materialService.queryCalculateList(null, startDate, endDate);
        if (CollectionUtils.isEmpty(reportList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u7269\u6599\u5165\u573a\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reportList));
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        ArrayList<CalculateDailyEntity> dailyList = new ArrayList<CalculateDailyEntity>();
        ArrayList<CalculateDailyVO> dailyVOList = new ArrayList<CalculateDailyVO>();
        for (MaterialVO materialVO : reportList) {
            this.packParameterDetail(dailyVOList, startDate, endDate, materialVO);
        }
        this.setRentalDayDetailValue(dailyVOList, dailyList, null);
        return dailyList;
    }
}

