/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.ExitDetailEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.bean.ExitSupplierEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.CommonSupportService;
import com.ejianc.business.rmat.service.ICoordinationSetService;
import com.ejianc.business.rmat.service.IExitService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.vo.ExitVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="exit")
public class ExitBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IExitService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CommonSupportService commonSupportService;
    @Autowired
    private ITransferFlowService transferFlowService;
    @Autowired
    private ICoordinationSetService coordinationSetService;
    @Autowired
    private IRmatFlowService flowService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03------------------------------------------------");
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isEmpty(exitEntity.getExitDetail())) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03------------------------------------------------");
        if (2 == exitEntity.getConfirmFlag()) {
            exitEntity.setConfirmFlag(0);
        }
        exitEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)exitEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        List<ExitSupplierEntity> entityList = exitEntity.getExitSupplierList();
        for (ExitDetailEntity exitDetailEntity : exitEntity.getExitDetail()) {
            entityList.addAll(exitDetailEntity.getExitSupplierList());
        }
        if (CollectionUtils.isNotEmpty(exitEntity.getExitSupplierList()) && !this.transferFlowService.insertExitFlow(exitEntity, TransFlowTypeEnum.\u9000\u573a.getFlowType(), RmatCommonConsts.YES).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u53f0\u8d26\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (!this.flowService.insertExitFlow(exitEntity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        Boolean falg = this.coordinationSetService.querySupplyByOrgId(exitEntity.getOrgId());
        if (!falg.booleanValue()) return CommonResponse.success();
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.commonSupportService.getAccessToken(headers);
        if (!tokenres.isSuccess()) return tokenres;
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
        CommonResponse<String> pushres = this.service.pushConfirmEntity(headers, exitEntity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        if (!pushres.isSuccess()) return pushres;
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
            if (2 == exitEntity.getConfirmFlag()) {
                exitEntity.setConfirmFlag(0);
            }
            exitEntity.setCommitId(InvocationInfoProxy.getUserid());
        }
        this.service.saveOrUpdate((Object)exitEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        Boolean falg = this.coordinationSetService.querySupplyByOrgId(exitEntity.getOrgId());
        this.service.validateTime((ExitVO)BeanMapper.map((Object)((Object)exitEntity), ExitVO.class), "\u5f03\u5ba1");
        if (falg.booleanValue()) {
            if (exitEntity.getConfirmFlag() == 1) {
                return CommonResponse.error((String)"\u9000\u573a\u5355\u4f9b\u65b9\u5df2\u786e\u8ba4\u4e0d\u652f\u6301\u64a4\u56de!");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            CommonResponse<String> tokenres = this.commonSupportService.getAccessToken(headers);
            if (tokenres.isSuccess()) {
                this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
                CommonResponse<String> pushres = this.service.pushDelete(headers, exitEntity);
                this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
                if (!pushres.isSuccess()) {
                    return pushres;
                }
            } else {
                return tokenres;
            }
        }
        if (!this.flowService.insertExitFlow(exitEntity, billTypeCode, RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        List<ExitSupplierEntity> entityList = exitEntity.getExitSupplierList();
        for (ExitDetailEntity exitDetailEntity : exitEntity.getExitDetail()) {
            entityList.addAll(exitDetailEntity.getExitSupplierList());
        }
        if (CollectionUtils.isNotEmpty(exitEntity.getExitSupplierList()) && !this.transferFlowService.insertExitFlow(exitEntity, TransFlowTypeEnum.\u9000\u573a.getFlowType(), RmatCommonConsts.TWO).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u53f0\u8d26\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

