/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.api.IApplyApi;
import com.ejianc.business.op.vo.ApplyDetailVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.bean.ExitDetailEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.bean.ExitSupplierEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.mapper.ExitMapper;
import com.ejianc.business.rmat.service.IExitApplyService;
import com.ejianc.business.rmat.service.IExitService;
import com.ejianc.business.rmat.service.IExitSupplierService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.HttpTookit;
import com.ejianc.business.rmat.vo.ExitDetailGFVO;
import com.ejianc.business.rmat.vo.ExitDetailVO;
import com.ejianc.business.rmat.vo.ExitGFVO;
import com.ejianc.business.rmat.vo.ExitReportVO;
import com.ejianc.business.rmat.vo.ExitSupplierVO;
import com.ejianc.business.rmat.vo.ExitVO;
import com.ejianc.business.rmat.vo.MaterialVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="exitService")
public class ExitServiceImpl
extends BaseServiceImpl<ExitMapper, ExitEntity>
implements IExitService {
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${openApi.wjExitUrl}")
    private String wjExitUrl;
    @Value(value="${openApi.wjExitDeleteUrl}")
    private String wjExitDeleteUrl;
    private static final String WJ_WZXT_EXIT = "WJHN_WZXT_EXIT";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IExitApplyService exitApplyService;
    @Autowired
    private IExitSupplierService exitSupplierService;
    @Autowired
    private ITransferFlowService transferFlowService;
    @Autowired
    private IRmatFlowService flowService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IApplyApi applyApi;

    @Override
    public ExitVO saveOrUpdate(ExitVO saveorUpdateVO) {
        if (StringUtils.isNotBlank((CharSequence)saveorUpdateVO.getContractId())) {
            this.materialService.validateContract(saveorUpdateVO.getContractId(), "\u9057\u5931\u5355", saveorUpdateVO.getId(), "\u4fdd\u5b58");
            this.validateTime(saveorUpdateVO, "\u4fdd\u5b58");
            this.validateNum(saveorUpdateVO);
        }
        if (CollectionUtils.isEmpty((Collection)saveorUpdateVO.getExitDetail())) {
            throw new BusinessException("\u5b50\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuffer materialName = new StringBuffer();
        if (CollectionUtils.isNotEmpty((Collection)saveorUpdateVO.getExitDetail())) {
            saveorUpdateVO.getExitDetail().forEach(vo -> materialName.append(vo.getMaterialName() + ","));
            String materialNames = materialName.substring(0, materialName.length() - 1);
            saveorUpdateVO.setMaterialName(materialNames);
        }
        ExitEntity entity = (ExitEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ExitEntity.class));
        entity.setConfirmFlag(0);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WJ_WZXT_EXIT, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ArrayList<ExitSupplierEntity> list = new ArrayList<ExitSupplierEntity>();
        ArrayList<ExitDetailEntity> detailDelList = new ArrayList<ExitDetailEntity>();
        for (ExitDetailEntity exitDetailEntity : entity.getExitDetail()) {
            List entityList = BeanMapper.mapList(exitDetailEntity.getExitSupplierList(), ExitSupplierEntity.class);
            for (ExitSupplierEntity de : entityList) {
                if (de.getId() == null) continue;
                list.add(de);
            }
            if (!"del".equals(exitDetailEntity.getRowState())) continue;
            detailDelList.add(exitDetailEntity);
        }
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        super.saveOrUpdate((Object)entity, false);
        this.saveDealSupplier(entity);
        ExitApplyEntity exitApplyEntity = (ExitApplyEntity)((Object)this.exitApplyService.selectById(entity.getApplyId()));
        ExitVO resVo = (ExitVO)BeanMapper.map((Object)((Object)entity), ExitVO.class);
        if (exitApplyEntity != null) {
            resVo.setApplyState(exitApplyEntity.getApplyState());
        }
        for (ExitDetailEntity exitDetailEntity : entity.getExitDetail()) {
            for (ExitSupplierEntity n : exitDetailEntity.getExitSupplierList()) {
                if (ids.contains(n.getId())) continue;
                n.setRowState("add");
                list.add(n);
            }
        }
        entity.setExitSupplierList(list);
        for (ExitDetailEntity exitDetailEntity : entity.getExitDetail()) {
            BigDecimal realOutNum = new BigDecimal(0);
            BigDecimal rentOutNum = new BigDecimal(0);
            for (ExitSupplierEntity exitSupplierEntity : exitDetailEntity.getExitSupplierList()) {
                if ("del".equals(exitSupplierEntity.getRowState())) continue;
                realOutNum = ComputeUtil.safeAdd((BigDecimal)realOutNum, (BigDecimal)exitSupplierEntity.getRealOutNum());
                rentOutNum = ComputeUtil.safeAdd((BigDecimal)rentOutNum, (BigDecimal)exitSupplierEntity.getRentOutNum());
            }
            if (realOutNum.compareTo(exitDetailEntity.getRealOutNum()) > 0) {
                throw new BusinessException("\u8bf7\u68c0\u67e5\uff0c\u52b3\u52a1\u961f\u5206\u914d\u3010\u5b9e\u7269\u9000\u573a\u6570\u91cf\u3011\u603b\u548c\uff0c\u8d85\u8fc7\u660e\u7ec6\u3010\u9000\u573a\u6570\u91cf(\u5b9e\u7269)\u3011");
            }
            if (rentOutNum.compareTo(exitDetailEntity.getRentOutNum()) <= 0) continue;
            throw new BusinessException("\u8bf7\u68c0\u67e5\uff0c\u52b3\u52a1\u961f\u5206\u914d\u3010\u8ba1\u79df\u9000\u573a\u6570\u91cf\u3011\u603b\u548c\uff0c\u8d85\u8fc7\u660e\u7ec6\u3010\u9000\u573a\u6570\u91cf(\u8ba1\u79df)\u3011");
        }
        entity.getExitDetail().addAll(detailDelList);
        if (!this.flowService.insertExitFlow(entity, BillTypeEnum.\u9000\u573a\u5355.getCode(), RmatCommonConsts.NO).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u53f0\u8d26\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty(entity.getExitSupplierList()) && !this.transferFlowService.insertExitFlow(entity, TransFlowTypeEnum.\u9000\u573a.getFlowType(), RmatCommonConsts.NO).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u53f0\u8d26\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return this.queryDetail(entity.getId());
    }

    private String validateNum(ExitVO exitVO) {
        String key;
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)exitVO.getContractId()));
        List<MaterialVO> list = this.materialService.queryRmatList(param, exitVO.getExitDate());
        HashSet<Long> materialTypeSet = new HashSet<Long>();
        HashMap<String, BigDecimal> numMap = new HashMap<String, BigDecimal>();
        for (MaterialVO materialVO : list) {
            if (CollectionUtils.isNotEmpty((Collection)materialVO.getChildren())) {
                materialTypeSet.add(materialVO.getMaterialTypeId());
                numMap.put(materialVO.getMaterialTypeId() + "@" + materialVO.getUseStatus(), materialVO.getRefNum());
                continue;
            }
            numMap.put(materialVO.getMaterialId() + "@" + materialVO.getUseStatus(), materialVO.getRefNum());
        }
        HashMap<String, BigDecimal> comMap = new HashMap<String, BigDecimal>();
        for (ExitDetailVO vo : exitVO.getExitDetail()) {
            if (null == vo.getRowState() || "del".equals(vo.getRowState())) continue;
            String string = key = materialTypeSet.contains(vo.getMaterialTypeId()) ? vo.getMaterialTypeId() + "@" + vo.getState() : vo.getMaterialId() + "@" + vo.getState();
            if (!comMap.containsKey(key)) {
                comMap.put(key, vo.getRentOutNum());
                continue;
            }
            comMap.put(key, ComputeUtil.safeAdd((BigDecimal)((BigDecimal)comMap.get(key)), (BigDecimal)vo.getRentOutNum()));
        }
        for (ExitDetailVO vo : exitVO.getExitDetail()) {
            if (null == vo.getRowState() || "del".equals(vo.getRowState()) || !ComputeUtil.isGreaterThan((BigDecimal)((BigDecimal)comMap.get(key = materialTypeSet.contains(vo.getMaterialTypeId()) ? vo.getMaterialTypeId() + "@" + vo.getState() : vo.getMaterialId() + "@" + vo.getState())), (BigDecimal)((BigDecimal)numMap.get(key)))) continue;
            if (materialTypeSet.contains(vo.getMaterialTypeId())) {
                throw new BusinessException("\u8868\u4f53\u5206\u7c7b\u540d\u79f0[" + vo.getMaterialTypeName() + "]\u5bf9\u5e94\u7684\u5206\u7c7b\u9000\u573a\u6570\u91cf[" + ComputeUtil.scale((BigDecimal)((BigDecimal)comMap.get(key)), (int)3) + "]\u5927\u4e8e\u5728\u79df\u6570\u91cf" + ComputeUtil.scale((BigDecimal)((BigDecimal)numMap.get(key)), (int)3) + "!");
            }
            throw new BusinessException("\u8868\u4f53\u6750\u6599\u7f16\u7801[" + vo.getMaterialCode() + "]\u5bf9\u5e94\u7684\u660e\u7ec6\u9000\u573a\u6570\u91cf[" + ComputeUtil.scale((BigDecimal)((BigDecimal)comMap.get(key)), (int)3) + "]\u5927\u4e8e\u5728\u79df\u6570\u91cf" + ComputeUtil.scale((BigDecimal)((BigDecimal)numMap.get(key)), (int)3) + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public List<ExitSupplierVO> querySupplier(Long exitId, Long exitDetailId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExitSupplierEntity::getExitId, (Object)exitId);
        queryWrapper.eq(null != exitDetailId, ExitSupplierEntity::getExitDetailId, (Object)exitDetailId);
        List list = this.exitSupplierService.list((Wrapper)queryWrapper);
        return CollectionUtils.isNotEmpty((Collection)list) ? BeanMapper.mapList((Iterable)list, ExitSupplierVO.class) : null;
    }

    @Override
    public ExitVO queryDetail(Long id) {
        ExitEntity entity = (ExitEntity)((Object)this.selectById(id));
        List<ExitDetailEntity> detailList = entity.getExitDetail();
        for (ExitDetailEntity detailEntity : detailList) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ExitSupplierEntity::getExitDetailId, (Object)detailEntity.getId());
            List supplierEntityList = this.exitSupplierService.list((Wrapper)queryWrapper);
            detailEntity.setExitSupplierList(supplierEntityList);
        }
        return (ExitVO)BeanMapper.map((Object)((Object)entity), ExitVO.class);
    }

    private void saveDealSupplier(ExitEntity entity) {
        for (ExitDetailEntity detailEntity : entity.getExitDetail()) {
            List<ExitSupplierEntity> supplierEntityList = detailEntity.getExitSupplierList();
            if (!CollectionUtils.isNotEmpty(supplierEntityList)) continue;
            ArrayList<ExitSupplierEntity> insertList = new ArrayList<ExitSupplierEntity>();
            ArrayList<Long> delPkList = new ArrayList<Long>();
            for (ExitSupplierEntity exitSupplierEntity : supplierEntityList) {
                if ("del".equals(exitSupplierEntity.getRowState())) {
                    delPkList.add(exitSupplierEntity.getId());
                    continue;
                }
                exitSupplierEntity.setExitId(entity.getId());
                exitSupplierEntity.setExitDetailId(detailEntity.getId());
                insertList.add(exitSupplierEntity);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.exitSupplierService.saveOrUpdateBatch(insertList);
            }
            if (!CollectionUtils.isNotEmpty(delPkList)) continue;
            this.exitSupplierService.removeByIds(delPkList);
        }
    }

    @Override
    public CommonResponse<ExitVO> updateConfirmFlag(ExitVO exitVO) {
        ExitEntity entity = (ExitEntity)((Object)super.getById((Serializable)exitVO.getId()));
        entity.setConfirmFlag(exitVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitVO.getConfirmerId());
        entity.setConfirmerName(exitVO.getConfirmerName());
        entity.setConfirmNote(exitVO.getConfirmNote());
        String msg = "\u786e\u8ba4";
        if (2 == exitVO.getConfirmFlag()) {
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            msg = "\u62d2\u7edd";
        }
        super.saveOrUpdate((Object)entity, false);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(entity.getCommitId()));
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
        String formurl = this.baseHost + "cscec5bhn-wzxt-frontend/#/exit/card?id=" + entity.getId();
        String subject = "\u60a8\u7684\u9000\u573a\u5355\u3010" + entity.getProjectName() + "--" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + msg + "\u3002";
        String content = "\u60a8\u7684\u9000\u573a\u5355\u3010" + entity.getProjectName() + "--" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + msg + "\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(entity.getTenantId()), entity);
        return CommonResponse.success();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, ExitEntity entity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4f9b\u65b9\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)(this.wjyPath + "cscec5bhn-wzxt-mobile/#/walkoffIndex/details?id=" + entity.getId() + "&userid={userid}"));
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitEntity exitEntity) {
        CommonResponse sceneurRes;
        String url = this.wjExitUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(exitEntity.getId()));
        purchase.setApplyId(exitEntity.getApplyId());
        purchase.setOrgId(exitEntity.getParentOrgSourceId());
        purchase.setOrgName(exitEntity.getOrgName());
        purchase.setConfirmFlag(Integer.valueOf(0));
        purchase.setProjectId(exitEntity.getProjectSourceId());
        purchase.setProjectName(exitEntity.getProjectName());
        purchase.setBillCode(exitEntity.getBillCode());
        purchase.setSupplierId(exitEntity.getSupplierSourceId());
        purchase.setSupplierName(exitEntity.getSupplierName());
        purchase.setContractId(exitEntity.getContractId());
        purchase.setContractName(exitEntity.getContractName());
        purchase.setContractCode(exitEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setExitDate(formatter.format(exitEntity.getExitDate()));
        purchase.setExitNote(exitEntity.getExitNote());
        purchase.setLinkName(exitEntity.getLinkName());
        purchase.setLinkTelephone(exitEntity.getLinkTelephone());
        purchase.setPkCreator("hnxpt");
        purchase.setSysmark("rmat");
        purchase.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        purchase.setCreatorDate(DateFormater.getInstance().format("yyyy-MM-dd HH:mm:ss"));
        if (purchase.getProjectId() != null) {
            CommonResponse ponse = this.iProjectApi.queryProjectBySourceId(purchase.getProjectId());
            if (ponse.getData() == null) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)ponse.getData();
            purchase.setCorpId(projectRegisterVO.getOrgId());
            purchase.setCorpName(projectRegisterVO.getOrgName());
            purchase.setCorpSourceId(projectRegisterVO.getSourceOrgId());
        }
        if ((sceneurRes = this.attachmentApi.queryListBySourceId(exitEntity.getId(), "BT210816000000006", "imgUpload2", null)).isSuccess()) {
            ArrayList sceneurlList = new ArrayList();
            sceneurlList.addAll(((List)sceneurRes.getData()).stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(sceneurlList)) {
                purchase.setSceneurl(String.join((CharSequence)",", sceneurlList));
            }
        }
        CommonResponse czsignurlRes = this.attachmentApi.queryListBySourceId(exitEntity.getId(), "BT210816000000006", "imgUpload3", null);
        ArrayList czsignurllList = new ArrayList();
        if (czsignurlRes.isSuccess()) {
            czsignurllList.addAll(((List)czsignurlRes.getData()).stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(czsignurllList)) {
                purchase.setCzsignurl(String.join((CharSequence)",", czsignurllList));
            }
        }
        CommonResponse jlsingurlRes = this.attachmentApi.queryListBySourceId(exitEntity.getId(), "BT210816000000006", "imgUpload4", null);
        ArrayList jlsingurlList = new ArrayList();
        if (jlsingurlRes.isSuccess()) {
            jlsingurlList.addAll(((List)jlsingurlRes.getData()).stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(jlsingurlList)) {
                purchase.setJlsingurl(String.join((CharSequence)",", jlsingurlList));
            }
        }
        if (CollectionUtils.isNotEmpty(exitEntity.getExitDetail())) {
            ArrayList list = new ArrayList();
            exitEntity.getExitDetail().forEach(e -> {
                ExitDetailGFVO vo = new ExitDetailGFVO();
                vo.setId(String.valueOf(e.getId()));
                vo.setExitId(String.valueOf(exitEntity.getId()));
                vo.setMaterialId(e.getMaterialSourceId());
                vo.setMaterialCode(e.getMaterialCode());
                vo.setMaterialTypeName(e.getMaterialTypeName());
                vo.setMaterialName(e.getMaterialName());
                vo.setSpec(e.getSpec());
                vo.setUnit(e.getUnitName());
                vo.setStopDate(formatter.format(e.getStopDate()));
                vo.setDef1(e.getDef1());
                vo.setDef2(e.getDef2());
                vo.setDef3(e.getDef3());
                vo.setDef4(e.getDef4());
                vo.setDef5(e.getDef5());
                vo.setMemo(e.getMemo());
                vo.setApplyNums(e.getApplyNums() == null ? BigDecimal.ZERO : e.getApplyNums());
                vo.setExitNums(e.getExitNums() == null ? BigDecimal.ZERO : e.getExitNums());
                vo.setExitNumsSum(e.getExitNumsSum() == null ? BigDecimal.ZERO : e.getExitNumsSum());
                vo.setRentUnitName(e.getRentUnitName());
                vo.setRentNum(e.getRentNum() == null ? BigDecimal.ZERO : e.getRentNum());
                vo.setRentExitNum(e.getRentExitNum() == null ? BigDecimal.ZERO : e.getRentExitNum());
                vo.setRealExitNum(e.getRealExitNum() == null ? BigDecimal.ZERO : e.getRealExitNum());
                vo.setRentOutNum(e.getRentOutNum() == null ? BigDecimal.ZERO : e.getRentOutNum());
                vo.setRealOutNum(e.getRealOutNum() == null ? BigDecimal.ZERO : e.getRealOutNum());
                list.add(vo);
            });
            purchase.setExitDetailList(list);
        }
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)purchase).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e2) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u8ba2\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public CommonResponse<String> pushDelete(Map<String, String> headers, ExitEntity exitEntity) {
        String url = this.wjExitDeleteUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(exitEntity.getId()));
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)purchase).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u5220\u9664\u4f9b\u65b9\u9000\u573a\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public List<ExitReportVO> queryExitReport(QueryWrapper queryWrapper) {
        return ((ExitMapper)this.baseMapper).queryExitReport(queryWrapper);
    }

    @Override
    public List<ExitReportVO> queryZlReports(QueryWrapper queryWrapper, Long projectId, Long supplierId) {
        return ((ExitMapper)this.baseMapper).queryZlReport(queryWrapper, projectId, supplierId);
    }

    @Override
    public List<ExitReportVO> queryCgReports(QueryWrapper queryWrapper, Long projectId) {
        return ((ExitMapper)this.baseMapper).queryCgReports(queryWrapper, projectId);
    }

    @Override
    public Boolean updatenums(List<Long> ids) {
        boolean res;
        List exits = new ArrayList();
        if (!ids.isEmpty()) {
            exits = ((ExitMapper)this.baseMapper).selectBatchIds(ids);
            if (exits.size() > 0 && exits.size() == ids.size()) {
                Iterator iterator = exits.iterator();
                while (iterator.hasNext()) {
                    ExitEntity entity;
                    entity.setPrintNum((entity = (ExitEntity)((Object)iterator.next())).getPrintNum() == null || entity.getPrintNum() == 0 ? 1 : entity.getPrintNum() + 1);
                }
            } else {
                throw new BusinessException("\u6570\u636e\u53ef\u80fd\u88ab\u66f4\u6539,\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u64cd\u4f5c");
            }
        }
        if (!(res = super.saveOrUpdateBatch(exits))) {
            throw new BusinessException("\u6570\u636e\u53ef\u80fd\u88ab\u66f4\u6539,\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u64cd\u4f5c");
        }
        return res;
    }

    @Override
    public ApplyVO pushOpApply(Long id) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.selectById(id));
        ApplyVO applyVO = new ApplyVO();
        applyVO.setProjectId(exitEntity.getProjectId());
        applyVO.setProjectName(exitEntity.getProjectName());
        applyVO.setOrgId(exitEntity.getOrgId());
        applyVO.setOrgName(exitEntity.getOrgName());
        applyVO.setParentOrgId(exitEntity.getParentOrgId());
        applyVO.setOutDate(new Date());
        applyVO.setTel(exitEntity.getLinkTelephone());
        applyVO.setCarNumber(exitEntity.getLicensePlate());
        applyVO.setLinkUrlPc("http://wei.cscec5b.com.cn:9080/cscec5b-rmat-frontend/#/exit/card?link=true&id=" + exitEntity.getId());
        applyVO.setLinkUrlMobile("https://wjqlh.17elian.com/cscec5b-rmat-mobile/#/exit/card?link=true&id=" + exitEntity.getId());
        ArrayList<ApplyDetailVO> detailList = new ArrayList<ApplyDetailVO>();
        for (ExitDetailEntity detailEntity : exitEntity.getExitDetail()) {
            ApplyDetailVO detailVO = new ApplyDetailVO();
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setSpec(detailEntity.getSpec());
            detailVO.setUnit(detailEntity.getRentUnitName());
            detailVO.setNum(detailEntity.getRentOutNum());
            detailVO.setReason("\u5468\u8f6c\u6750\u9000\u573a");
            detailList.add(detailVO);
        }
        applyVO.setSourceId(String.valueOf(exitEntity.getId()));
        applyVO.setSourceType("EJCBT202210000013");
        applyVO.setSourceTypeName("\u5468\u8f6c\u6750\u9000\u573a\u5355");
        applyVO.setSourceBussType("imgUpload2");
        applyVO.setDetailList(detailList);
        CommonResponse response = this.applyApi.push(applyVO);
        if (response.isSuccess() && null != response.getData()) {
            return (ApplyVO)response.getData();
        }
        this.logger.error(JSONObject.toJSONString((Object)response));
        throw new BusinessException(response.getMsg());
    }

    @Override
    public String validateTime(ExitVO exitVO, String type) {
        Date lastDate;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", exitVO.getContractId());
        if (exitVO.getId() != null) {
            params.put("billType", "\u9057\u5931\u5355");
            params.put("billId", exitVO.getId());
        }
        if ((lastDate = this.materialService.getLastDate(params)) == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff01";
        }
        for (ExitDetailVO detailVO : exitVO.getExitDetail()) {
            if (null == detailVO.getStopDate() || DateUtil.compareDate(detailVO.getStopDate(), lastDate) >= 0) continue;
            throw new BusinessException(DateUtil.formatDate(detailVO.getStopDate()) + "\u5c0f\u4e8e\u7b49\u4e8e\u6700\u5927\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

