/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.bean.ManageSetEntity;
import com.ejianc.business.rmat.mapper.ManageSetMapper;
import com.ejianc.business.rmat.service.IManageSetService;
import com.ejianc.business.rmat.vo.ManageSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="manageSetService")
public class ManageSetServiceImpl
extends BaseServiceImpl<ManageSetMapper, ManageSetEntity>
implements IManageSetService {
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<ManageSetVO> saveOrUpdate(List<ManageSetVO> saveOrUpdateVO) {
        ArrayList<ManageSetVO> manageSetVOList = new ArrayList<ManageSetVO>();
        for (ManageSetVO manageSetVOS : saveOrUpdateVO) {
            CommonResponse materialCategoryVOS = this.materialApi.queryCategoryById(manageSetVOS.getId());
            ManageSetEntity manageSetEntity = new ManageSetEntity();
            manageSetEntity.setMaterialTypeId(((MaterialCategoryVO)materialCategoryVOS.getData()).getId());
            manageSetEntity.setMaterialTypeCode(((MaterialCategoryVO)materialCategoryVOS.getData()).getCode());
            manageSetEntity.setMaterialTypeName(((MaterialCategoryVO)materialCategoryVOS.getData()).getName());
            manageSetEntity.setCategoryInnerCode(((MaterialCategoryVO)materialCategoryVOS.getData()).getInnerCode());
            manageSetEntity.setStatus(0);
            CommonResponse orgVo = this.iOrgApi.detailById(InvocationInfoProxy.getOrgId());
            manageSetEntity.setOrgId(((OrgVO)orgVo.getData()).getId());
            manageSetEntity.setOrgName(((OrgVO)orgVo.getData()).getName());
            manageSetEntity.setOrgCode(((OrgVO)orgVo.getData()).getCode());
            manageSetEntity.setOrgInnerCode(((OrgVO)orgVo.getData()).getInnerCode());
            manageSetEntity.setCreateUserName(manageSetVOS.getCreateUserName());
            super.saveOrUpdate((Object)manageSetEntity);
            manageSetVOList.add((ManageSetVO)BeanMapper.map((Object)((Object)manageSetEntity), ManageSetVO.class));
        }
        return manageSetVOList;
    }

    @Override
    public List<ManageSetVO> queryManageSet(List<ManageSetVO> vos) {
        ArrayList<ManageSetVO> voList = new ArrayList<ManageSetVO>();
        block0: for (ManageSetVO vo : vos) {
            CommonResponse orgVO = this.iOrgApi.detailById(vo.getOrgId());
            this.logger.info("orgVO------============================" + JSONObject.toJSONString((Object)orgVO));
            String[] orgInnerCode = ((OrgVO)orgVO.getData()).getInnerCode().split("\\|");
            for (int i = orgInnerCode.length - 1; i >= 0; --i) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(ManageSetEntity::getStatus, (Object)0);
                queryWrapper.eq(vo.getMaterialId() != null, ManageSetEntity::getMaterialId, (Object)vo.getMaterialId());
                queryWrapper.eq(vo.getMaterialTypeId() != null, ManageSetEntity::getMaterialTypeId, (Object)vo.getMaterialTypeId());
                queryWrapper.eq(ManageSetEntity::getOrgId, (Object)orgInnerCode[i]);
                ManageSetEntity manageSetEntity = (ManageSetEntity)((Object)super.getOne((Wrapper)queryWrapper));
                if (manageSetEntity == null) continue;
                voList.add((ManageSetVO)BeanMapper.map((Object)((Object)manageSetEntity), ManageSetVO.class));
                continue block0;
            }
        }
        return voList;
    }

    @Override
    public String changeStatus(Long id, Integer status) {
        ManageSetEntity manageSetEntity = (ManageSetEntity)((Object)super.selectById((Serializable)id));
        manageSetEntity.setStatus(status);
        super.saveOrUpdate((Object)manageSetEntity);
        if (manageSetEntity.getStatus() == 0) {
            return "\u542f\u7528\u6210\u529f";
        }
        return "\u505c\u7528\u6210\u529f";
    }
}

