/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.DailyEntity;
import com.ejianc.business.rmat.bean.ReportDailyEntity;
import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.ReportDailyMapper;
import com.ejianc.business.rmat.service.ICalculateDailyService;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IDailyService;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.ReportCorpLowerVO;
import com.ejianc.business.rmat.vo.ReportCorpTopVO;
import com.ejianc.business.rmat.vo.ReportDailyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reportDailyService")
public class ReportDailyServiceImpl
extends BaseServiceImpl<ReportDailyMapper, ReportDailyEntity>
implements IReportDailyService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDailyService dailyService;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private ICalculateDailyService calculateDailyService;
    private static final String REPORT_RMAT_DAILY = "REPORT_RMAT_DAILY";

    @Override
    public ReportDailyVO saveOrUpdate(ReportDailyVO reportDailyVO) {
        ReportDailyEntity entity = (ReportDailyEntity)((Object)BeanMapper.map((Object)((Object)reportDailyVO), ReportDailyEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (ReportDailyVO)((Object)BeanMapper.map((Object)((Object)entity), ReportDailyVO.class));
    }

    @Override
    public void makeReportDailyData(List<DailyEntity> dailyList) {
        ReportDailyVO reportVO;
        List reportList = this.list();
        Map reportMap = reportList.stream().collect(Collectors.toMap(ReportDailyEntity::getProjectId, Function.identity(), (key1, key2) -> key1));
        List<ReportDailyVO> caclMny = ((ReportDailyMapper)this.baseMapper).getCaclMny();
        List<ReportDailyVO> restitueMny = ((ReportDailyMapper)this.baseMapper).getRestitueMny();
        List<ReportDailyVO> repairMny = ((ReportDailyMapper)this.baseMapper).getRepairMny();
        List<ReportDailyVO> pcOtherMny = ((ReportDailyMapper)this.baseMapper).getPcOtherMny();
        List<ReportDailyVO> calcOtherMny = ((ReportDailyMapper)this.baseMapper).getCalcOtherMny();
        HashMap<Long, ReportDailyVO> newReportMap = new HashMap<Long, ReportDailyVO>();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (DailyEntity dailyEntity : dailyList) {
                reportVO = new ReportDailyVO();
                reportVO.setProjectId(dailyEntity.getProjectId());
                newReportMap.put(dailyEntity.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(caclMny)) {
            for (ReportDailyVO reportDailyVO : caclMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRentTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRentTaxMny(), (BigDecimal)reportDailyVO.getSumRentTaxMny()));
                reportVO.setSumRentMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRentMny(), (BigDecimal)reportDailyVO.getSumRentMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(restitueMny)) {
            for (ReportDailyVO reportDailyVO : restitueMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumScrapTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumScrapTaxMny(), (BigDecimal)reportDailyVO.getSumScrapTaxMny()));
                reportVO.setSumScrapMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumScrapMny(), (BigDecimal)reportDailyVO.getSumScrapMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(repairMny)) {
            for (ReportDailyVO reportDailyVO : repairMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRepairTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRepairTaxMny(), (BigDecimal)reportDailyVO.getSumRepairTaxMny()));
                reportVO.setSumRepairMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRepairMny(), (BigDecimal)reportDailyVO.getSumRepairMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(pcOtherMny)) {
            for (ReportDailyVO reportDailyVO : pcOtherMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherTaxMny(), (BigDecimal)reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherMny(), (BigDecimal)reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(calcOtherMny)) {
            for (ReportDailyVO reportDailyVO : calcOtherMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherTaxMny(), (BigDecimal)reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherMny(), (BigDecimal)reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        ArrayList<ReportDailyEntity> reportSaveList = new ArrayList<ReportDailyEntity>();
        for (Long key : newReportMap.keySet()) {
            ReportDailyVO reportDailyVO = (ReportDailyVO)((Object)newReportMap.get(key));
            ReportDailyEntity reportDailyEntity = null;
            if (reportMap.containsKey(key)) {
                reportDailyEntity = (ReportDailyEntity)((Object)reportMap.get(key));
            } else {
                CommonResponse commonResponse;
                reportDailyEntity = new ReportDailyEntity();
                reportDailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                reportDailyEntity.setProjectId(reportDailyVO.getProjectId());
                if (StringUtils.isEmpty((CharSequence)reportDailyEntity.getBillCode())) {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        reportDailyEntity.setBillCode((String)billCode.getData());
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                if ((commonResponse = this.projectApi.queryProjectByIds(Arrays.asList(reportDailyVO.getProjectId()))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                    ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)((List)commonResponse.getData()).get(0);
                    reportDailyEntity.setProjectCode(projectRegisterVO.getCode());
                    reportDailyEntity.setProjectName(projectRegisterVO.getName());
                    reportDailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                    reportDailyEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                    reportDailyEntity.setOrgName(projectRegisterVO.getName());
                    reportDailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                    reportDailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                    reportDailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());
                    CommonResponse response = this.orgApi.getOneById(projectRegisterVO.getOrgId());
                    if (response.isSuccess() && response.getData() != null) {
                        OrgVO orgVO = (OrgVO)response.getData();
                        reportDailyEntity.setParentOrgId(orgVO.getId());
                        reportDailyEntity.setParentOrgCode(orgVO.getCode());
                        reportDailyEntity.setParentOrgName(orgVO.getName());
                    }
                }
            }
            reportDailyEntity.setSumRentTaxMny(reportDailyVO.getSumRentTaxMny());
            reportDailyEntity.setSumRentMny(reportDailyVO.getSumRentMny());
            reportDailyEntity.setSumScrapTaxMny(reportDailyVO.getSumScrapTaxMny());
            reportDailyEntity.setSumScrapMny(reportDailyVO.getSumScrapMny());
            reportDailyEntity.setSumRepairTaxMny(reportDailyVO.getSumRepairTaxMny());
            reportDailyEntity.setSumRepairMny(reportDailyVO.getSumRepairMny());
            reportDailyEntity.setSumOtherTaxMny(reportDailyVO.getSumOtherTaxMny());
            reportDailyEntity.setSumOtherMny(reportDailyVO.getSumOtherMny());
            reportSaveList.add(reportDailyEntity);
        }
        if (CollectionUtils.isNotEmpty(reportSaveList)) {
            this.saveOrUpdateBatch(reportSaveList, reportSaveList.size());
        }
    }

    @Override
    public ReportCorpTopVO qryTopInfo(Long orgId) {
        ReportCorpTopVO topVO = new ReportCorpTopVO();
        topVO.setId(IdWorker.getId());
        List orgVOS = (List)this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData();
        HashMap<Long, Object> detailMap = new HashMap<Long, Object>();
        HashMap<Long, String> innerCodeMap = new HashMap<Long, String>();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (OrgVO orgVO : orgVOS) {
            if (null != orgVO.getParentId() && orgVO.getParentId().equals(orgId)) {
                ReportCorpLowerVO lowerVO = new ReportCorpLowerVO();
                lowerVO.setId(IdWorker.getId());
                lowerVO.setTopId(topVO.getId());
                lowerVO.setOrgName(orgVO.getName());
                lowerVO.setOrgId(orgVO.getId());
                lowerVO.setOrgCode(orgVO.getCode());
                detailMap.put(orgVO.getId(), (Object)lowerVO);
            }
            orgIdList.add(orgVO.getId());
            innerCodeMap.put(orgVO.getId(), orgVO.getInnerCode());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DailyEntity::getRentDate, (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        queryWrapper.in(DailyEntity::getBillState, new Object[]{"1,3"});
        queryWrapper.in(DailyEntity::getParentOrgId, orgIdList);
        List dailyEntities = this.dailyService.list((Wrapper)queryWrapper);
        for (DailyEntity dailyEntity : dailyEntities) {
            for (Long key : detailMap.keySet()) {
                if (!((String)innerCodeMap.get(dailyEntity.getParentOrgId())).contains(String.valueOf(key))) continue;
                ReportCorpLowerVO lowerVO = (ReportCorpLowerVO)((Object)detailMap.get(key));
                lowerVO.setDailyMny(ComputeUtil.safeAdd((BigDecimal)lowerVO.getDailyMny(), (BigDecimal)dailyEntity.getRentMny()));
            }
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(CalculateEntity::getBillState, new Object[]{"1,3"});
        query.in(CalculateEntity::getParentOrgId, orgIdList);
        List calcList = this.calculateService.list((Wrapper)query);
        Date beginDate = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfYear()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(LocalDate.now().with(TemporalAdjusters.lastDayOfYear()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        for (CalculateEntity calcEntity : calcList) {
            for (Long key : detailMap.keySet()) {
                if (!((String)innerCodeMap.get(calcEntity.getParentOrgId())).contains(String.valueOf(key))) continue;
                ReportCorpLowerVO lowerVO = (ReportCorpLowerVO)((Object)detailMap.get(key));
                if (calcEntity.getRentDate().after(beginDate) && calcEntity.getRentDate().before(endDate)) {
                    lowerVO.setYearMny(ComputeUtil.safeAdd((BigDecimal)lowerVO.getYearMny(), (BigDecimal)calcEntity.getRentMny()));
                }
                lowerVO.setSumMny(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumMny(), (BigDecimal)calcEntity.getRentMny()));
            }
        }
        CommonResponse orgResponse = this.orgApi.findChildrenByParentIds(orgIdList);
        HashSet<Long> departmentIdSet = new HashSet<Long>();
        for (OrgVO orgVO : (List)orgResponse.getData()) {
            if (!orgVO.getInnerCode().contains(String.valueOf(orgId)) || !orgVO.getOrgType().equals(5)) continue;
            departmentIdSet.add(orgVO.getId());
            innerCodeMap.put(orgVO.getId(), orgVO.getInnerCode());
        }
        ArrayList departmentIdList = new ArrayList(departmentIdSet);
        CommonResponse pipeResponse = this.materialApi.queryCategoryListByPid(Long.valueOf("1328902423640543234"));
        List pipeCtyList = ((List)pipeResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper flowQuery = new LambdaQueryWrapper();
        flowQuery.eq(RmatFlowEntity::getEffectiveState, (Object)RmatCommonConsts.YES);
        flowQuery.in(RmatFlowEntity::getMaterialTypeId, pipeCtyList);
        flowQuery.in(RmatFlowEntity::getOrgId, departmentIdList);
        List pipeFlowList = this.rmatFlowService.list((Wrapper)flowQuery);
        for (RmatFlowEntity flowEntity : pipeFlowList) {
            for (Object key : detailMap.keySet()) {
                if (!((String)innerCodeMap.get(flowEntity.getOrgId())).contains(String.valueOf(key))) continue;
                ReportCorpLowerVO lowerVO = (ReportCorpLowerVO)((Object)detailMap.get(key));
                if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flowEntity.getBillTypeCode())) {
                    lowerVO.setSumPipeInNum(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumPipeInNum(), (BigDecimal)flowEntity.getRealNum()));
                }
                if (!BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flowEntity.getBillTypeCode()) && !BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flowEntity.getBillTypeCode())) continue;
                lowerVO.setSumPipeOutNum(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumPipeOutNum(), (BigDecimal)flowEntity.getRealNum()));
            }
        }
        CommonResponse clampResponse = this.materialApi.queryCategoryListByPid(Long.valueOf("1328902425322459138"));
        List clampCtyList = ((List)clampResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        flowQuery = new LambdaQueryWrapper();
        flowQuery.eq(RmatFlowEntity::getEffectiveState, (Object)RmatCommonConsts.YES);
        flowQuery.in(RmatFlowEntity::getMaterialTypeId, clampCtyList);
        flowQuery.in(RmatFlowEntity::getOrgId, departmentIdList);
        List clampFlowList = this.rmatFlowService.list((Wrapper)flowQuery);
        for (RmatFlowEntity flowEntity : clampFlowList) {
            for (Long key : detailMap.keySet()) {
                if (!((String)innerCodeMap.get(flowEntity.getOrgId())).contains(String.valueOf(key))) continue;
                ReportCorpLowerVO lowerVO = (ReportCorpLowerVO)((Object)detailMap.get(key));
                if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flowEntity.getBillTypeCode())) {
                    lowerVO.setSumClampInNum(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumClampInNum(), (BigDecimal)flowEntity.getRealNum()));
                }
                if (!BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flowEntity.getBillTypeCode()) && !BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flowEntity.getBillTypeCode())) continue;
                lowerVO.setSumClampOutNum(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumClampOutNum(), (BigDecimal)flowEntity.getRealNum()));
            }
        }
        CommonResponse koujResponse = this.materialApi.queryCategoryListByPid(Long.valueOf("1328902426949849089"));
        List koujCtyList = ((List)koujResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        flowQuery = new LambdaQueryWrapper();
        flowQuery.eq(RmatFlowEntity::getEffectiveState, (Object)RmatCommonConsts.YES);
        flowQuery.in(RmatFlowEntity::getMaterialTypeId, koujCtyList);
        flowQuery.in(RmatFlowEntity::getOrgId, departmentIdList);
        List koujFlowList = this.rmatFlowService.list((Wrapper)flowQuery);
        for (RmatFlowEntity flowEntity : koujFlowList) {
            for (Long key : detailMap.keySet()) {
                if (!((String)innerCodeMap.get(flowEntity.getOrgId())).contains(String.valueOf(key))) continue;
                ReportCorpLowerVO lowerVO = (ReportCorpLowerVO)((Object)detailMap.get(key));
                if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flowEntity.getBillTypeCode())) {
                    lowerVO.setSumLunkInNum(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumLunkInNum(), (BigDecimal)flowEntity.getRealNum()));
                }
                if (!BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flowEntity.getBillTypeCode()) && !BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flowEntity.getBillTypeCode())) continue;
                lowerVO.setSumLunkOutNum(ComputeUtil.safeAdd((BigDecimal)lowerVO.getSumLunkOutNum(), (BigDecimal)flowEntity.getRealNum()));
            }
        }
        for (ReportCorpLowerVO lowerVO : detailMap.values()) {
            lowerVO.setDailyMny(ComputeUtil.safeDiv((BigDecimal)lowerVO.getDailyMny(), (BigDecimal)BigDecimal.valueOf(10000L)));
            lowerVO.setYearMny(ComputeUtil.safeDiv((BigDecimal)lowerVO.getYearMny(), (BigDecimal)BigDecimal.valueOf(10000L)));
            lowerVO.setSumMny(ComputeUtil.safeDiv((BigDecimal)lowerVO.getSumMny(), (BigDecimal)BigDecimal.valueOf(10000L)));
            topVO.setDailyMny(ComputeUtil.safeAdd((BigDecimal)topVO.getDailyMny(), (BigDecimal)lowerVO.getDailyMny()));
            topVO.setYearMny(ComputeUtil.safeAdd((BigDecimal)topVO.getYearMny(), (BigDecimal)lowerVO.getYearMny()));
            topVO.setSumMny(ComputeUtil.safeAdd((BigDecimal)topVO.getSumMny(), (BigDecimal)lowerVO.getSumMny()));
            lowerVO.setSumPipeNum(ComputeUtil.safeSub((BigDecimal)lowerVO.getSumPipeInNum(), (BigDecimal)lowerVO.getSumPipeOutNum()));
            lowerVO.setPipeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)lowerVO.getSumPipeOutNum(), (BigDecimal)lowerVO.getSumPipeInNum()), (BigDecimal)BigDecimal.valueOf(100L)));
            topVO.setSumPipeInNum(ComputeUtil.safeAdd((BigDecimal)topVO.getSumPipeInNum(), (BigDecimal)lowerVO.getSumPipeInNum()));
            topVO.setSumPipeOutNum(ComputeUtil.safeAdd((BigDecimal)topVO.getSumPipeOutNum(), (BigDecimal)lowerVO.getSumPipeOutNum()));
            lowerVO.setSumClampNum(ComputeUtil.safeSub((BigDecimal)lowerVO.getSumClampInNum(), (BigDecimal)lowerVO.getSumClampOutNum()));
            lowerVO.setClampRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)lowerVO.getSumClampOutNum(), (BigDecimal)lowerVO.getSumClampInNum()), (BigDecimal)BigDecimal.valueOf(100L)));
            topVO.setSumClampInNum(ComputeUtil.safeAdd((BigDecimal)topVO.getSumClampInNum(), (BigDecimal)lowerVO.getSumClampInNum()));
            topVO.setSumClampOutNum(ComputeUtil.safeAdd((BigDecimal)topVO.getSumClampOutNum(), (BigDecimal)lowerVO.getSumClampOutNum()));
            lowerVO.setSumLunkNum(ComputeUtil.safeSub((BigDecimal)lowerVO.getSumLunkInNum(), (BigDecimal)lowerVO.getSumLunkOutNum()));
            topVO.setSumLunkInNum(ComputeUtil.safeAdd((BigDecimal)topVO.getSumLunkInNum(), (BigDecimal)lowerVO.getSumLunkInNum()));
            topVO.setSumLunkOutNum(ComputeUtil.safeAdd((BigDecimal)topVO.getSumLunkOutNum(), (BigDecimal)lowerVO.getSumLunkOutNum()));
        }
        topVO.setSumPipeNum(ComputeUtil.safeSub((BigDecimal)topVO.getSumPipeInNum(), (BigDecimal)topVO.getSumPipeOutNum()));
        topVO.setPipeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)topVO.getSumPipeOutNum(), (BigDecimal)topVO.getSumPipeInNum()), (BigDecimal)BigDecimal.valueOf(100L)));
        topVO.setSumClampNum(ComputeUtil.safeSub((BigDecimal)topVO.getSumClampInNum(), (BigDecimal)topVO.getSumClampOutNum()));
        topVO.setClampRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)topVO.getSumClampOutNum(), (BigDecimal)topVO.getSumClampInNum()), (BigDecimal)BigDecimal.valueOf(100L)));
        topVO.setSumLunkNum(ComputeUtil.safeSub((BigDecimal)topVO.getSumLunkInNum(), (BigDecimal)topVO.getSumLunkOutNum()));
        topVO.setLowerVOList(new ArrayList<ReportCorpLowerVO>(detailMap.values()));
        return topVO;
    }

    @Override
    public List<JSONObject> qryDailyRise(Long orgId) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Date beginDate = Date.from(LocalDate.now().minusDays(29L).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List orgIdList = ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(sum(rent_mny),0) as rentMny, rent_date as rentDate"});
        queryWrapper.between((Object)"rent_date", (Object)beginDate, (Object)new Date());
        queryWrapper.in((Object)"bill_state", new Object[]{"1,3"});
        queryWrapper.in((Object)"parent_org_id", orgIdList);
        queryWrapper.groupBy((Object[])new String[]{"rent_date"});
        List dailyEntities = this.dailyService.list((Wrapper)queryWrapper);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (DailyEntity dailyEntity : dailyEntities) {
            map.put(dateFormat.format(dailyEntity.getRentDate()), dailyEntity.getRentMny());
        }
        LocalDate currentDate = LocalDate.now();
        for (int i = 30; i > 0; --i) {
            String date = dateFormat.format(Date.from(currentDate.minusDays(i - 1).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", (Object)date);
            jsonObject.put("value", map.get(date));
            list.add(jsonObject);
        }
        return list;
    }

    @Override
    public JSONObject qryRentMnyDistribution(Long orgId) {
        JSONObject jsonObject = new JSONObject();
        List orgIdList = ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(CalculateEntity::getBillState, new Object[]{"1,3"});
        query.in(CalculateEntity::getParentOrgId, orgIdList);
        List calcList = this.calculateService.list((Wrapper)query);
        BigDecimal pipe = null;
        BigDecimal clamp = null;
        BigDecimal lunk = null;
        BigDecimal other = null;
        if (CollectionUtils.isNotEmpty((Collection)calcList)) {
            List calcIdList = calcList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(CalculateDailyEntity::getCalculateId, calcIdList);
            List dailyEntities = this.calculateDailyService.list((Wrapper)queryWrapper);
            CommonResponse pipeResponse = this.materialApi.queryCategoryListByPid(Long.valueOf("1328902423640543234"));
            Set pipeCtySet = ((List)pipeResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toSet());
            CommonResponse clampResponse = this.materialApi.queryCategoryListByPid(Long.valueOf("1328902425322459138"));
            Set clampCtySet = ((List)clampResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toSet());
            CommonResponse koujResponse = this.materialApi.queryCategoryListByPid(Long.valueOf("1328902426949849089"));
            Set koujCtySet = ((List)koujResponse.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toSet());
            for (CalculateDailyEntity dailyEntity : dailyEntities) {
                Long materialTypeId = dailyEntity.getMaterialTypeId();
                if (pipeCtySet.contains(materialTypeId)) {
                    pipe = ComputeUtil.safeAdd(pipe, (BigDecimal)dailyEntity.getDailyRentMny());
                    continue;
                }
                if (clampCtySet.contains(materialTypeId)) {
                    clamp = ComputeUtil.safeAdd(clamp, (BigDecimal)dailyEntity.getDailyRentMny());
                    continue;
                }
                if (koujCtySet.contains(materialTypeId)) {
                    lunk = ComputeUtil.safeAdd(lunk, (BigDecimal)dailyEntity.getDailyRentMny());
                    continue;
                }
                other = ComputeUtil.safeAdd(other, (BigDecimal)dailyEntity.getDailyRentMny());
            }
        }
        jsonObject.put("pipe", (Object)ComputeUtil.safeDiv(pipe, (BigDecimal)BigDecimal.valueOf(10000L)));
        jsonObject.put("clamp", (Object)ComputeUtil.safeDiv(clamp, (BigDecimal)BigDecimal.valueOf(10000L)));
        jsonObject.put("lunk", (Object)ComputeUtil.safeDiv(lunk, (BigDecimal)BigDecimal.valueOf(10000L)));
        jsonObject.put("other", (Object)ComputeUtil.safeDiv(other, (BigDecimal)BigDecimal.valueOf(10000L)));
        return jsonObject;
    }
}

