package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.service.IRestituteScrapService;
import com.ejianc.business.rmat.vo.ReportCorpPcVO;
import com.ejianc.business.rmat.vo.ReportCorpTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 公司租金分析
 *
 * @author generator
 */
@Controller
@RequestMapping("reportCorp")
public class ReportCorpController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IReportDailyService service;

    @Autowired
    private IRestituteScrapService restituteScrapService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;

    /**
     * @param orgId
     * @Description qryTopInfo
     */
    @RequestMapping(value = "/qryTopInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportCorpTopVO> qryTopInfo(@RequestParam(value = "orgId", required = false) Long orgId) {
        return CommonResponse.success("查询数据成功！", service.qryTopInfo(InvocationInfoProxy.getOrgId()));
    }

    /**
     * @param orgId
     * @Description qryDailyRise 查询日租金涨幅情况
     */
    @RequestMapping(value = "/qryDailyRise", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> qryDailyRise(@RequestParam(value = "orgId", required = false) Long orgId) {
        return CommonResponse.success("查询数据成功！", service.qryDailyRise(InvocationInfoProxy.getOrgId()));
    }

    /**
     * @param orgId
     * @Description qryRentMnyDistribution 查询累计租金分布
     */
    @RequestMapping(value = "/qryRentMnyDistribution", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> qryRentMnyDistribution(@RequestParam(value = "orgId", required = false) Long orgId) {
        return CommonResponse.success("查询数据成功！", service.qryRentMnyDistribution(InvocationInfoProxy.getOrgId()));
    }

    /**
     * @param param
     * @Description queryPcList 赔偿单价列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> queryPcList(@RequestBody QueryParam param) {
        IPage<ReportCorpPcVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        List<Long> orgIds = new ArrayList<>();
        if (CollectionUtils.isEmpty(orgVOS)) {
            orgIds.add(InvocationInfoProxy.getOrgId());
        }else {
           orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportCorpPcVO> list = restituteScrapService.queryPcList(pageData, wrapper, orgIds);
        if (CollectionUtils.isNotEmpty(list)) {
            for(ReportCorpPcVO pcVO : list){
                pcVO.setId(IdWorker.getId());
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryPcList 赔偿单价列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/linkPcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> linkPcList(@RequestBody QueryParam param) {
        IPage<ReportCorpPcVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        Object secondFlagObj = param.getParams().get("secondFlag").getValue();
        List<Long> orgIds = new ArrayList<>();
        Map<Long, String> map = new HashMap<>();
        boolean secondFlag = true;
        if (null != secondFlagObj && 1 == (Integer) secondFlagObj) {
            orgIds.add(InvocationInfoProxy.getOrgId());
        }else {
            orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
            map = orgVOS.stream().collect(Collectors.toMap(OrgVO::getId, OrgVO::getName, (k1, k2) -> k1));
            secondFlag = false;
        }
        param.getParams().remove("secondFlag");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportCorpPcVO> list = restituteScrapService.linkPcList(pageData, wrapper, orgIds, secondFlag);
        if (CollectionUtils.isNotEmpty(list)) {
            for(ReportCorpPcVO pcVO : list){
                pcVO.setId(IdWorker.getId());
                if (!secondFlag) {
                    pcVO.setOrgName(map.get(pcVO.getOrgId()));
                }
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryPcList 赔偿单价列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryRentList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> queryRentList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        List<Long> orgIds = new ArrayList<>();
        if (CollectionUtils.isEmpty(orgVOS)) {
            orgIds.add(InvocationInfoProxy.getOrgId());
        }else {
            orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportCorpPcVO> list = contInfoPriceRecordService.queryRentList(wrapper, orgIds);
        IPage<ReportCorpPcVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(paginate(list, param.getPageIndex(), param.getPageSize()));
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * 手动分页
     *
     * @param list      要分页的原始列表
     * @param pageIndex 当前页的索引（从1开始）
     * @param pageSize  每页的大小
     * @return          截取后的分页列表
     */
    public  List<ReportCorpPcVO> paginate(List<ReportCorpPcVO> list, int pageIndex, int pageSize) {
        int total = list.size();  // 获取总记录数

        // 计算起始索引和结束索引
        int fromIndex = (pageIndex - 1) * pageSize;
        int toIndex = Math.min(fromIndex + pageSize, total);

        // 防止索引越界
        if (fromIndex > total || fromIndex < 0) {
            return new ArrayList<>(); // 返回空列表
        }

        return list.subList(fromIndex, toIndex);
    }
}
