package com.ejianc.business.rmat.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.api.ICmContractApi;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rmat.bean.TransferFlowEntity;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.vo.TransferFlowVO;

/**
 * 内部调拨流水表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("transferFlow")
public class TransferFlowController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITransferFlowService service;


    @Autowired
    private ICmContractApi cmContractApi;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private IProjectApi projectApi;


    /**
     * @param vos 数据
     * @description: 验收插入流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value="/insertFlow")
    public CommonResponse<Boolean> insertFlow(@RequestBody List<TransferFlowVO> vos) {
        Boolean flag = service.insertFlow(vos, TransFlowTypeEnum.验收.getFlowType());
        if (Boolean.FALSE.equals(flag)) {
            return CommonResponse.error("插入流水数据失败！");
        }
        return CommonResponse.success("插入流水数据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id 项目id+供应商id
     */
    @GetMapping(value = "/queryDetail")
    public CommonResponse<TransferFlowVO> queryDetail(@RequestParam String id) {
        List<TransferFlowEntity> list = service.list(new QueryWrapper<TransferFlowEntity>()
                .eq("query_id", id));
        //拼数据/基本信息
        TransferFlowVO vo = new TransferFlowVO();
        TransferFlowEntity entity = list.get(0);
        vo.setProjectId(entity.getProjectId());
        vo.setSupplierId(entity.getSupplierId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode()!=null ?entity.getProjectCode() : null);
        vo.setSupplierName(entity.getSupplierName());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgName(entity.getOrgName());
        vo.setOrgCode(entity.getOrgCode()!=null ? entity.getOrgCode() : null);
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode()!=null ? entity.getParentOrgCode() : null);
        vo.setParentOrgName(entity.getParentOrgName()!=null ? entity.getParentOrgName() : null);
        vo.setQueryId(entity.getProjectId()+"_"+entity.getSupplierId());
        List<TransferFlowVO> details = vo.getDetailList();//在场材料明细
        //拼子表明细数据
        Map<Long,List<TransferFlowEntity>> flowMap = list.stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId));
        for (Map.Entry<Long, List<TransferFlowEntity>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = service.getFlowData(entry.getValue());
            details.add(fvo);
        }
        vo.setDetailList(details);

        // 调入/调出单位：类型为调入时显示调出单位，调出时显示调入单位， 验收或调出单位为空时，显示项目。
        list.forEach(e->{
            switch (e.getFlowType()){
                case "1":
                    e.setSupplierId(e.getSupplierId()!=null?e.getSupplierId():e.getProjectId());
                    e.setSupplierName(e.getSupplierName()!=null?e.getSupplierName():e.getProjectName());break;
                case "3":
                    e.setSupplierId(e.getInOutId()!=null?e.getInOutId():e.getProjectId());
                    e.setSupplierName(e.getInOutName()!=null?e.getInOutName():e.getProjectName());break;
                case "4":
                    e.setSupplierId(e.getInOutId());
                    e.setSupplierName(e.getInOutName());
                    break;
                default:break;
            }
        });
        vo.setRmatList(BeanMapper.mapList(list, TransferFlowVO.class));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryUnAlllotDetail 查询详情
     * @param projectId 项目id
     */
    @GetMapping(value = "/queryUnAlllotDetail")
    public CommonResponse<TransferFlowVO> queryUnAlllotDetail(@RequestParam("id") Long projectId) {
        return CommonResponse.success("查询详情数据成功！", service.queryUnAlllotDetail(projectId));
    }

    /**
     * @Description queryRmatDetail 查询物资周转明细
     * @param materialId
     */
    @GetMapping(value = "/queryRmatDetail")
    public CommonResponse<List<TransferFlowVO>> queryRmatDetail(@RequestParam String queryId,@RequestParam Long materialId) {
        List<TransferFlowEntity> list = service.list(new QueryWrapper<TransferFlowEntity>()
                .eq("query_id", queryId).eq("material_id",materialId));
       // 调入/调出单位：类型为调入时显示调出单位，调出时显示调入单位， 验收或调出单位为空时，显示项目。
        list.forEach(e->{
            switch (e.getFlowType()){
                case "1":
                    e.setSupplierId(e.getSupplierId()!=null?e.getSupplierId():e.getProjectId());
                    e.setSupplierName(e.getSupplierName()!=null?e.getSupplierName():e.getProjectName());break;
                case "3":
                    e.setSupplierId(e.getInOutId()!=null?e.getInOutId():e.getProjectId());
                    e.setSupplierName(e.getInOutName()!=null?e.getInOutName():e.getProjectName());break;
                case "4":
                    e.setSupplierId(e.getInOutId());
                    e.setSupplierName(e.getInOutName());
                    break;
                default:break;
            }
        });
        return CommonResponse.success("查询详情数据成功！",BeanMapper.mapList(list,TransferFlowVO.class));
    }

    /**
     * @Description queryUnRmatDetail 查询物资周转明细
     * @param materialId
     */
    @GetMapping(value = "/queryUnRmatDetail")
    public CommonResponse<List<TransferFlowVO>> queryUnRmatDetail(@RequestParam Long projectId, @RequestParam Long materialId) {
        return CommonResponse.success("查询详情数据成功！", service.getUnAllotDetail(projectId, materialId));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @PostMapping(value="/delete")
    public CommonResponse<String> delete(@RequestBody List<Long> sourceIds, @RequestParam Integer flowType) {
        return CommonResponse.success(service.delete(sourceIds, flowType));
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TransferFlowVO>> queryList(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, RmatCommonConsts.YES));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<TransferFlowEntity> page = service.queryPage(param,false);
        IPage<TransferFlowVO> pageData = new Page<>();
        List<TransferFlowVO> flowVo = BeanMapper.mapList(page.getRecords(), TransferFlowVO.class);
        List<TransferFlowVO> list = service.getListData(flowVo);
        List<TransferFlowVO> allList = service.getAllList(param);
        list.addAll(allList);

        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        pageData.setTotal(list.size());
        list = PageUtil.listToPage(list, pageNumber, pageSize);
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if(!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<TransferFlowEntity> list = service.queryList(param);
        List<TransferFlowVO> flowVoS = service.getListData(BeanMapper.mapList(list,TransferFlowVO.class));
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(flowVoS,TransferFlowEntity.class));
        ExcelExport.getInstance().export("TransferFlow-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param pageNumber
     * @Return void
     */
    @RequestMapping(value = "/refTransferFlowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TransferFlowVO>> refTransferFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, RmatCommonConsts.YES));
//        param.getParams().put("useStatus", new Parameter(QueryParam.NE, "1"));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("supplierId")) {
                Long supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
            }else if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }else {
                return CommonResponse.success("查询参照数据成功！",new Page<>());
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        IPage<TransferFlowEntity> page = service.queryPage(param,false);
        //拼子表明细数据
        List<TransferFlowVO> flows = new ArrayList<>();
        Map<Long,List<TransferFlowEntity>> flowMap = page.getRecords().stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId));
        for (Map.Entry<Long, List<TransferFlowEntity>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = service.getFlowData(entry.getValue());
            if (fvo.getRealOnHandNums().compareTo(BigDecimal.ZERO)> 0){
                flows.add(fvo);
            }
        }
        IPage<TransferFlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(flows);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 分包供应商参照
     *
     * @return
     */
    @GetMapping("/subSupplierRef")
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> subSupplierRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        Long projectId = null;
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
        }else {
            return CommonResponse.success("分包供应商参照成功！", new Page<>());
        }
        CommonResponse<List<ProjectRegisterVO>> response = projectApi.queryProjectByIds(Arrays.asList(projectId));
        CommonResponse<List<CmContract>> listCommonResponse = cmContractApi.querySubContractList(response.getData().get(0).getSourceId(), searchText);
        List<SupplierVO> supplierVOS = new ArrayList<>();
        SupplierVO supplier;
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
            Set<String> supList = listCommonResponse.getData().stream().map(CmContract::getPkSupplier).collect(Collectors.toSet());
            for(String key : supList){
                supplier = supplierApi.queryBySourceId(key).getData();
                if(supplier!= null){
                    supplierVOS.add(supplier);
                }
            }
        }
        IPage<SupplierVO> pageData = new Page<>();
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        pageData.setTotal(supplierVOS.size());
        supplierVOS = PageUtil.listToPage(supplierVOS, pageNumber, pageSize);
        pageData.setRecords(supplierVOS);
        return CommonResponse.success("分包供应商参照成功！", pageData);
    }
}
