package com.ejianc.business.rmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 租金计算单-日租
 *
 * @author generator
 *
 */
 @TableName("ejc_rmat_calculate_daily")
public class CalculateDailyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="calculate_id")
    private Long calculateId; // 主表主键
    @TableField(value="source_id")
    private Long sourceId; // 来源数据Id
    @TableField(value="info_id")
    private String infoId; // 合同清单主键
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资材料分类Id
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资材料分类名称
    @TableField(value="material_id")
    private Long materialId; // 材料id
    @TableField(value="material_code")
    private String materialCode; // 材料编码
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="material_source_id")
    private String materialSourceId; // 物资来源主键
    @TableField(value="spec")
    private String spec; // 规则/型号
    @TableField(value="rent_unit_id")
    private String rentUnitId; // 计租单位id
    @TableField(value="rent_unit_name")
    private String rentUnitName; // 计租单位
    @TableField(value="rent_num")
    private BigDecimal rentNum; // 计租数量
    @TableField(value="unit_tax_price")
    private BigDecimal unitTaxPrice; // 日租单价
    @TableField(value="unit_price")
    private BigDecimal unitPrice; // 日租单价(无税)
    @TableField(value="stop_unit_tax_price")
    private BigDecimal stopUnitTaxPrice; // 停租单价
    @TableField(value="stop_unit_price")
    private BigDecimal stopUnitPrice; // 停租单价(无税)
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="daily_rent_tax_mny")
    private BigDecimal dailyRentTaxMny; // 日租租金
    @TableField(value="daily_rent_mny")
    private BigDecimal dailyRentMny; // 日租租金(无税)
    @TableField(value="daily_tax")
    private BigDecimal dailyTax; // 税额
    @TableField(value="start_date")
    private Date startDate; // 计费开始日期
    @TableField(value="end_date")
    private Date endDate; // 计费结束日期
    @TableField(value="use_status")
    private String useStatus; // 使用状态：0-启用，1-停用
    @TableField(value="rent_day_date")
    private Integer rentDayDate; // 租赁天数
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="unit_id")
    private String unitId; // 档案单位id
    @TableField(value="unit_name")
    private String unitName; // 档案单位
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="real_unit_id")
    private String realUnitId; // 实物单位id
    @TableField(value="real_unit_name")
    private String realUnitName; // 实物单位
    @TableField(value="real_num")
    private BigDecimal realNum; // 实物数量
    @TableField(value="real_trans_scale")
    private BigDecimal realTransScale; // 实物转换系数
    @TableField(value="rent_trans_scale")
    private BigDecimal rentTransScale; // 计租转换系数
    @TableField(exist = false)
    private Long projectId;
    @TableField(exist = false)
    private String contractId;
    @TableField(exist = false)
    private String contractName; // 合同名称
    @TableField(exist = false)
    private String supplierName; // 供应商名称

    @TableField(value="period_num")
    private BigDecimal periodNum; // 上次结存数量
    @TableField(value="check_num")
    private BigDecimal checkNum; // 进场数量
    @TableField(value="exit_num")
    private BigDecimal exitNum; // 退场数量
    @TableField(value="scrap_num")
    private BigDecimal scrapNum; // 报废数量
    @TableField(value="stop_num")
    private BigDecimal stopNum; // 停租数量
    @TableField(value="sequence")
    private Integer sequence; // 序号

    public Long getCalculateId() {
        return calculateId;
    }

    public void setCalculateId(Long calculateId) {
        this.calculateId = calculateId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getInfoId() {
        return infoId;
    }

    public void setInfoId(String infoId) {
        this.infoId = infoId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSourceId() {
        return materialSourceId;
    }

    public void setMaterialSourceId(String materialSourceId) {
        this.materialSourceId = materialSourceId;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getRentUnitId() {
        return rentUnitId;
    }

    public void setRentUnitId(String rentUnitId) {
        this.rentUnitId = rentUnitId;
    }
    public String getRentUnitName() {
        return rentUnitName;
    }

    public void setRentUnitName(String rentUnitName) {
        this.rentUnitName = rentUnitName;
    }
    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getStopUnitTaxPrice() {
        return stopUnitTaxPrice;
    }

    public void setStopUnitTaxPrice(BigDecimal stopUnitTaxPrice) {
        this.stopUnitTaxPrice = stopUnitTaxPrice;
    }
    public BigDecimal getStopUnitPrice() {
        return stopUnitPrice;
    }

    public void setStopUnitPrice(BigDecimal stopUnitPrice) {
        this.stopUnitPrice = stopUnitPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getDailyRentTaxMny() {
        return dailyRentTaxMny;
    }

    public void setDailyRentTaxMny(BigDecimal dailyRentTaxMny) {
        this.dailyRentTaxMny = dailyRentTaxMny;
    }
    public BigDecimal getDailyRentMny() {
        return dailyRentMny;
    }

    public void setDailyRentMny(BigDecimal dailyRentMny) {
        this.dailyRentMny = dailyRentMny;
    }
    public BigDecimal getDailyTax() {
        return dailyTax;
    }

    public void setDailyTax(BigDecimal dailyTax) {
        this.dailyTax = dailyTax;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }
    public Integer getRentDayDate() {
        return rentDayDate;
    }

    public void setRentDayDate(Integer rentDayDate) {
        this.rentDayDate = rentDayDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public String getRealUnitId() {
        return realUnitId;
    }

    public void setRealUnitId(String realUnitId) {
        this.realUnitId = realUnitId;
    }
    public String getRealUnitName() {
        return realUnitName;
    }

    public void setRealUnitName(String realUnitName) {
        this.realUnitName = realUnitName;
    }
    public BigDecimal getRealNum() {
        return realNum;
    }

    public void setRealNum(BigDecimal realNum) {
        this.realNum = realNum;
    }
    public BigDecimal getRealTransScale() {
        return realTransScale;
    }

    public void setRealTransScale(BigDecimal realTransScale) {
        this.realTransScale = realTransScale;
    }
    public BigDecimal getRentTransScale() {
        return rentTransScale;
    }

    public void setRentTransScale(BigDecimal rentTransScale) {
        this.rentTransScale = rentTransScale;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getPeriodNum() {
        return periodNum;
    }

    public void setPeriodNum(BigDecimal periodNum) {
        this.periodNum = periodNum;
    }

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    public BigDecimal getExitNum() {
        return exitNum;
    }

    public void setExitNum(BigDecimal exitNum) {
        this.exitNum = exitNum;
    }

    public BigDecimal getScrapNum() {
        return scrapNum;
    }

    public void setScrapNum(BigDecimal scrapNum) {
        this.scrapNum = scrapNum;
    }

    public BigDecimal getStopNum() {
        return stopNum;
    }

    public void setStopNum(BigDecimal stopNum) {
        this.stopNum = stopNum;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
}
