package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.dataexchange.vo.LeaseInfoPriceRecordVO;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.ContInfoPriceRecordEntity;
import com.ejianc.business.rmat.bean.PriceFlowEntity;
import com.ejianc.business.rmat.mapper.ContInfoPriceRecordMapper;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.ContInfoPriceRecordVO;
import com.ejianc.business.rmat.vo.ReportCorpPcDetailVO;
import com.ejianc.business.rmat.vo.ReportCorpPcVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材合同清单价格记录
 *
 * @author generator
 *
 */
@Service("contInfoPriceRecordService")
public class ContInfoPriceRecordServiceImpl extends BaseServiceImpl<ContInfoPriceRecordMapper, ContInfoPriceRecordEntity> implements IContInfoPriceRecordService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private ICalculateService calculateService;

    @Override
    public ContInfoPriceRecordVO queryDetail(Long id) {
        ContInfoPriceRecordEntity entity = selectById(id);
        ContInfoPriceRecordVO vo = BeanMapper.map(entity, ContInfoPriceRecordVO.class);
        return vo;
    }

    @Override
    public List<ContInfoPriceRecordVO> qryByContId(String pkContract, String pkContractInfo) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper<ContInfoPriceRecordEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContInfoPriceRecordEntity::getPkContract, pkContract);
        queryWrapper.eq(ContInfoPriceRecordEntity::getPkLeaselist, pkContractInfo);
        queryWrapper.orderByAsc(ContInfoPriceRecordEntity::getDactivedate);
        List<ContInfoPriceRecordEntity> list = list(queryWrapper);
        Set<String> set = new HashSet<>();
        ContInfoPriceRecordEntity priceRecordEntity = null;
        ContInfoPriceRecordEntity priceCheckRecordEntity = null;
        if(CollectionUtils.isNotEmpty(list)){
            for(ContInfoPriceRecordEntity recordEntity : list){
                set.add(recordEntity.getPkContract()  + "@" + format.format(recordEntity.getDactivedate()) + "@" + recordEntity.getNhireprice().stripTrailingZeros());
                if(recordEntity.getCheckFlag()){
                    priceCheckRecordEntity = recordEntity;
                }
            }
            priceRecordEntity = list.get(0);
        }

        LambdaQueryWrapper<PriceFlowEntity> query = new LambdaQueryWrapper<>();
        query.eq(PriceFlowEntity::getFlowType, 1);
        query.ne(PriceFlowEntity::getBillTypeCode, "BT230606000000001");//排除期初录入的验收
        query.eq(PriceFlowEntity::getInfoId, pkContractInfo);
        query.orderByAsc(PriceFlowEntity::getDetailDate);
        query.last("limit 1");
        PriceFlowEntity priceFlowEntity = priceFlowService.getOne(query, false);

        List<ContInfoPriceRecordEntity> recordEntities = new ArrayList<>();
        CommonResponse<List<LeaseInfoPriceRecordVO>> response = cmContractInfoApi.queryLeasePriceById(pkContract, pkContractInfo);
        logger.error(JSONObject.toJSONString(response));
        //有NC单价变更
        if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
            try {
                //1.有验收记录 2.单价记录为空或者最早单价记录比验收记录晚
                if (null != priceFlowEntity && (null == priceRecordEntity || priceRecordEntity.getDactivedate().compareTo(priceFlowEntity.getDetailDate()) > 0)) {
                    String key = pkContract  + "@" + format.format(priceFlowEntity.getDetailDate()) + "@" + priceFlowEntity.getPrice().stripTrailingZeros();
                    if(!set.contains(key) && format.parse(response.getData().get(0).getDactivedate()).compareTo(priceFlowEntity.getDetailDate()) > 0){
                        if(null != priceCheckRecordEntity){
                            priceCheckRecordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                            priceCheckRecordEntity.setNhireprice(priceFlowEntity.getPrice());
                            priceCheckRecordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                            priceCheckRecordEntity.setTs(priceFlowEntity.getDetailDate());
                            recordEntities.add(priceCheckRecordEntity);
                        }else {
                            ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                            recordEntity.setPkContract(pkContract);
                            recordEntity.setPkLeaselist(pkContractInfo);
                            recordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                            recordEntity.setNhireprice(priceFlowEntity.getPrice());
                            recordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                            recordEntity.setTs(priceFlowEntity.getDetailDate());
                            recordEntity.setPeriodFlag(false);
                            recordEntity.setCheckFlag(true);
                            recordEntities.add(recordEntity);
                        }
                        set.add(key);
                    }
                }
            } catch (ParseException e) {
                logger.error(e.getMessage());
            }

            for(LeaseInfoPriceRecordVO recordVO : response.getData()){
                String key = recordVO.getPkContract()  + "@" + recordVO.getDactivedate() + "@" + recordVO.getNhireprice().stripTrailingZeros();
                if (!set.contains(key)) {
                    ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                    recordEntity.setPkContract(pkContract);
                    recordEntity.setPkLeaselist(pkContractInfo);
                    recordEntity.setNhireprice(recordVO.getNhireprice());
                    recordEntity.setPeriodFlag(false);
                    recordEntity.setCheckFlag(false);
                    try {
                        recordEntity.setDmakedate(format.parse(recordVO.getDmakedate()));
                        recordEntity.setDactivedate(format.parse(recordVO.getDactivedate()));
                        recordEntity.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(recordVO.getTs()));
                    }catch (ParseException e) {
                        logger.error(e.getMessage());
                    }
                    recordEntities.add(recordEntity);
                }
            }
        }else {
            //1.没有NC单价变更 2.有验收记录 3.单价记录为空或者最早单价记录比验收记录晚
            if (null != priceFlowEntity && (null == priceRecordEntity || priceRecordEntity.getDactivedate().compareTo(priceFlowEntity.getDetailDate()) > 0)) {
                String key = pkContract  + "@" + format.format(priceFlowEntity.getDetailDate()) + "@" + priceFlowEntity.getPrice().stripTrailingZeros();
                if(!set.contains(key)){
                    if(null != priceCheckRecordEntity){
                        priceCheckRecordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                        priceCheckRecordEntity.setNhireprice(priceFlowEntity.getPrice());
                        priceCheckRecordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                        priceCheckRecordEntity.setTs(priceFlowEntity.getDetailDate());
                        recordEntities.add(priceCheckRecordEntity);
                    }else {
                        ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                        recordEntity.setPkContract(pkContract);
                        recordEntity.setPkLeaselist(pkContractInfo);
                        recordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                        recordEntity.setNhireprice(priceFlowEntity.getPrice());
                        recordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                        recordEntity.setTs(priceFlowEntity.getDetailDate());
                        recordEntity.setPeriodFlag(false);
                        recordEntity.setCheckFlag(true);
                        recordEntities.add(recordEntity);
                    }
                }
            }
        }


        if(CollectionUtils.isNotEmpty(recordEntities)){
            saveOrUpdateBatch(recordEntities);
        }

        recordEntities.addAll(list);
        List<ContInfoPriceRecordVO> result = BeanMapper.mapList(recordEntities, ContInfoPriceRecordVO.class);
        Collections.sort(result, Comparator.comparing(ContInfoPriceRecordVO::getDactivedate));

        return result;
    }

    @Override
    public List<ReportCorpPcVO> queryRentList(QueryWrapper wrapper, List<Long> orgIds, List<Long> projectIds) {
        // 获取当前日期时间
        LocalDateTime now = LocalDateTime.now();

        // 获取前半年日期并将时间设置为00:00:00
        LocalDateTime sixMonthsAgo = now.minus(6, ChronoUnit.MONTHS)
                .withHour(0)
                .withMinute(0)
                .withSecond(0)
                .withNano(0);

        // 将LocalDateTime转换为Date
        Date compareDate = Date.from(sixMonthsAgo.atZone(ZoneId.systemDefault()).toInstant());

        List<ReportCorpPcVO> returnData = new ArrayList<>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper<CalculateEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(CalculateEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.in(CollectionUtils.isNotEmpty(orgIds), CalculateEntity::getParentOrgId, orgIds);
        queryWrapper.in(CollectionUtils.isNotEmpty(projectIds), CalculateEntity::getOrgId, projectIds);
        queryWrapper.orderByDesc(CalculateEntity::getCreateTime);
        List<CalculateEntity> list = calculateService.list(queryWrapper);
        Map<String, Map<Date, BigDecimal>> result = new LinkedHashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> contIdSet = list.stream().map(CalculateEntity::getContractId).collect(Collectors.toSet());
            LambdaQueryWrapper<ContInfoPriceRecordEntity> query = Wrappers.lambdaQuery();
            query.in(ContInfoPriceRecordEntity::getPkContract, new ArrayList<>(contIdSet));
            List<ContInfoPriceRecordEntity> recordEntities = list(query);
            Map<String, List<ContInfoPriceRecordEntity>> map = recordEntities.stream().collect(Collectors.groupingBy(ContInfoPriceRecordEntity::getPkContract));
            for (String pkCont : contIdSet) {
                CommonResponse<List<CmContractInfoVO>> response = cmContractInfoApi.queryLeaseContractInfoById(pkCont);
                List<CmContractInfoVO> infoVOS = response.getData();
                if (CollectionUtils.isNotEmpty(infoVOS)) {
                    List<ContInfoPriceRecordEntity> records = map.get(pkCont);
                    if (CollectionUtils.isNotEmpty(records)) {
                        Map<String, List<ContInfoPriceRecordEntity>> infoMap = records.stream().collect(Collectors.groupingBy(ContInfoPriceRecordEntity::getPkLeaselist));
                        for (CmContractInfoVO infoVO : infoVOS) {
                            if (null == infoVO.getMaterialTypeId()) {
                                continue;
                            }
                            String key = infoVO.getMaterialTypeId() + "@" + infoVO.getMaterialTypeName() + "@" + infoVO.getInfounit();
                            Map<Date, BigDecimal> resultMap = result.containsKey(key) ? result.get(key) : new HashMap<>();
                            List<ContInfoPriceRecordEntity> entities = infoMap.get(infoVO.getPkContractinfo());
                            if (CollectionUtils.isNotEmpty(entities)) {
                                for(ContInfoPriceRecordEntity recordEntity : entities){
                                    resultMap.put(recordEntity.getDactivedate(), recordEntity.getNhireprice());
                                }
                                result.put(key, resultMap);
                            }
                        }
                    }
                }
            }
            for (String key : result.keySet()) {
                Map<Date, BigDecimal> decimalMap = result.get(key);
                ReportCorpPcVO pcVO = new ReportCorpPcVO();
                pcVO.setId(IdWorker.getId());
                String[] arr = key.split("@");
                pcVO.setMaterialTypeId(Long.valueOf(arr[0]));
                pcVO.setMaterialTypeName(arr[1]);
                pcVO.setRentUnitName(arr[2]);
                BigDecimal total = BigDecimal.ZERO;
                int num = 0;
                List<ReportCorpPcDetailVO> detailVOS = new ArrayList<>();
                for (Date date : decimalMap.keySet()) {
                    if (compareDate.compareTo(date) <= 0) {
                        num++;
                        ReportCorpPcDetailVO detailVO = new ReportCorpPcDetailVO();
                        detailVO.setId(IdWorker.getId());
                        detailVO.setActiveDate(dateFormat.format(date));
                        detailVO.setActiveDateCom(date);
                        detailVO.setPrice(decimalMap.get(date));
                        total = ComputeUtil.safeAdd(total, detailVO.getPrice());
                        detailVOS.add(detailVO);
                    }
                }
                pcVO.setDamagePrice(ComputeUtil.safeDiv(total, BigDecimal.valueOf(num)));
                if (CollectionUtils.isNotEmpty(detailVOS)) {
                    detailVOS.sort(Comparator.comparing(ReportCorpPcDetailVO::getActiveDateCom));
                    pcVO.setLinkList(detailVOS);
                    returnData.add(pcVO);
                }
            }
        }
        return returnData;
    }
}
