package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.DailyMapper;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 日租金
 *
 * @author generator
 *
 */
@Service("dailyService")
public class DailyServiceImpl extends BaseServiceImpl<DailyMapper, DailyEntity> implements IDailyService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String RMAT_DAILY = "RMAT_DAILY";

    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private ICalculateOtherService calculateOtherService;
    @Autowired
    private IReportDailyService reportDailyService;
    @Autowired
    private IStopService stopService;
    @Autowired
    private IStopDetailService stopDetailService;
    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private IRestituteScrapService restituteScrapService;
    @Autowired
    private IRestituteMaintainService restituteMaintainService;
    @Autowired
    private IRestituteOtherService restituteOtherService;
    @Autowired
    private IMaterialService materialService;

    @Override
    public DailyVO saveOrUpdate(DailyVO dailyVO) {
        DailyEntity entity = BeanMapper.map(dailyVO, DailyEntity.class);
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, DailyVO.class);
    }

    @Override
    public CommonResponse<String> generation(HttpServletRequest request) {
        logger.info("生成日租金报表开始》》》》》》》》》》》》");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        String beginTime = df.format(calendar.getTime()) + " 00:00:00";
        String endTime = df.format(calendar.getTime()) + " 23:59:59";

        // 手动调用时传的时间参数（正式的调度中心可忽略）
        if (request.getParameter("beginTime") != null) {
            beginTime = request.getParameter("beginTime");
        }
        if (request.getParameter("endTime") != null) {
            endTime = request.getParameter("endTime");
        }
        logger.info("beginTime------->" + beginTime);
        logger.info("endTime------->" + endTime);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = dateFormat.parse(beginTime);
            endDate = dateFormat.parse(endTime);
        } catch (ParseException e) {
            logger.error("日期转换错误！");
            throw new BusinessException(e.getMessage());
        }

        List<CalculateDailyEntity> dailyEntityList = calculateService.dailyQueryList(startDate, endDate);

        Map<Long, DailyEntity> map = new HashMap<>();
        Map<String, CmContractInfoVO> infoMap = new HashMap<>();
        Map<Long, ProjectRegisterVO> projMap = new HashMap<>();
        Map<Long, OrgVO> orgMap = new HashMap<>();

        for(CalculateDailyEntity calcDailyEntity : dailyEntityList){
            DailyEntity dailyEntity = null;
            if(!map.containsKey(calcDailyEntity.getProjectId())){
                dailyEntity = BeanMapper.map(calcDailyEntity, DailyEntity.class);
                dailyEntity.setId(IdWorker.getId());
                dailyEntity.setRentDate(calendar.getTime());
                dailyEntity.setCreateTime(null);
                dailyEntity.setCreateUserCode(null);
                dailyEntity.setUpdateTime(null);
                dailyEntity.setUpdateUserCode(null);
                dailyEntity.setVersion(1);
                dailyEntity.setMemo(null);

                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RMAT_DAILY, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    dailyEntity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }

                dailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                ProjectRegisterVO projectRegisterVO = new ProjectRegisterVO();
                if (projMap.containsKey(calcDailyEntity.getProjectId())) {
                    projectRegisterVO = projMap.get(calcDailyEntity.getProjectId());
                }else{
                    CommonResponse<List<ProjectRegisterVO>> commonResponse = projectApi.queryProjectByIds(Arrays.asList(new Long[]{calcDailyEntity.getProjectId()}));
                    if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                        projectRegisterVO = commonResponse.getData().get(0);
                        projMap.put(calcDailyEntity.getProjectId(), projectRegisterVO);
                    }
                }
                dailyEntity.setProjectCode(projectRegisterVO.getCode());
                dailyEntity.setProjectName(projectRegisterVO.getName());
                dailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                dailyEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                dailyEntity.setOrgName(projectRegisterVO.getName());
                dailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                dailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                dailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());

                OrgVO orgVO = new OrgVO();
                if (orgMap.containsKey(projectRegisterVO.getOrgId())) {
                    orgVO = orgMap.get(projectRegisterVO.getOrgId());
                }else{
                    CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getOrgId());
                    if (response.isSuccess() && response.getData() != null) {
                        orgVO = response.getData();
                        orgMap.put(dailyEntity.getOrgId(), orgVO);
                    }
                }
                dailyEntity.setParentOrgId(orgVO.getId());
                dailyEntity.setParentOrgCode(orgVO.getCode());
                dailyEntity.setParentOrgName(orgVO.getName());
            }else {
                dailyEntity = map.get(calcDailyEntity.getProjectId());
            }

            DailyDetailEntity detailEntity = BeanMapper.map(calcDailyEntity, DailyDetailEntity.class);
            detailEntity.setId(IdWorker.getId());
            detailEntity.setDailyId(dailyEntity.getId());
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setVersion(1);
            detailEntity.setMemo(null);

            if(!infoMap.containsKey(calcDailyEntity.getInfoId())){
                CommonResponse<List<CmContractInfoVO>> response = cmContractInfoApi.queryLeaseContractInfoById(calcDailyEntity.getContractId());
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    for (CmContractInfoVO infoVO : response.getData()) {
                        infoMap.put(infoVO.getPkContractinfo(), infoVO);
                    }
                }
            }
            CmContractInfoVO infoVO = infoMap.get(detailEntity.getInfoId());
            if (null == infoVO) {
                logger.error("NC不存在的合同明细：" + detailEntity.getInfoId());
            }
            detailEntity.setRentPrice(BigDecimal.valueOf(infoVO.getHireprice()));
            detailEntity.setRentTaxPrice(BigDecimal.valueOf(infoVO.getTaxhireprice()));
            detailEntity.setRentMny(ComputeUtil.safeMultiply(detailEntity.getRentNum(), detailEntity.getRentPrice()));
            detailEntity.setRentTaxMny(ComputeUtil.safeMultiply(detailEntity.getRentNum(), detailEntity.getRentTaxPrice()));
            detailEntity.setRentTax(ComputeUtil.safeSub(detailEntity.getRentTaxMny(), detailEntity.getRentMny()));

            List<DailyDetailEntity> detailList = null != dailyEntity.getDetailList() ? dailyEntity.getDetailList() : new ArrayList<>();
            detailList.add(detailEntity);
            dailyEntity.setDetailList(detailList);

            map.put(dailyEntity.getProjectId(), dailyEntity);
        }

        if (CollectionUtils.isNotEmpty(map.values())) {
            for (Long projectId : map.keySet()) {
                DailyEntity dailyEntity = map.get(projectId);
                LambdaQueryWrapper<CalculateEntity> query = new LambdaQueryWrapper<>();
                query.eq(CalculateEntity::getProjectId, dailyEntity.getProjectId());
                query.eq(CalculateEntity::getRentDate, dailyEntity.getRentDate());
                query.eq(CalculateEntity::getBillState, "1,3");
                List<CalculateEntity> calculateEntities = calculateService.list(query);
                for (CalculateEntity calculateEntity : calculateEntities) {
                    dailyEntity.setCalcMny(ComputeUtil.safeAdd(dailyEntity.getCalcMny(), calculateEntity.getRentMny()));
                    dailyEntity.setCalcTaxMny(ComputeUtil.safeAdd(dailyEntity.getCalcTaxMny(), calculateEntity.getRentTaxMny()));
                    dailyEntity.setCalcTax(ComputeUtil.safeAdd(dailyEntity.getCalcTax(), calculateEntity.getRentTax()));
                }

                for(DailyDetailEntity detailEntity : dailyEntity.getDetailList()){
                    dailyEntity.setRentMny(ComputeUtil.safeAdd(dailyEntity.getRentMny(), detailEntity.getRentMny()));
                    dailyEntity.setRentTaxMny(ComputeUtil.safeAdd(dailyEntity.getRentTaxMny(), detailEntity.getRentTaxMny()));
                    dailyEntity.setRentTax(ComputeUtil.safeAdd(dailyEntity.getRentTax(), detailEntity.getRentTax()));
                }
                saveOrUpdate(dailyEntity, false);
            }
        }

        reportDailyService.makeReportDailyData(new ArrayList<>(map.values()));

        return CommonResponse.success("执行成功");
    }

    @Override
    public RentReportVO qryReport(Long projectId, String beginDate, String endDate) {
        RentReportVO rentReportVO = new RentReportVO();
        rentReportVO.setId(IdWorker.getId());
        Map<String, List<ContInfoPriceRecordVO>> priceMap = new HashMap<>();
        //查询开累：截至到结束日期前所有的
        List<RentReportCalcVO> sumCalcList = qryCalcList(projectId, "1990-01-01", endDate, null, priceMap);
        Map<Long, RentReportDetailVO> detailMap = new HashMap<>();
//        Map<Long, RentReportRestituteVO> restituteMap = new HashMap<>();
        Set<Long> detailAddedSet = new HashSet<>();
//        Set<Long> restituteAddedSet = new HashSet<>();

        for (RentReportCalcVO calcVO : sumCalcList) {
            RentReportDetailVO detailVO = null;
            if(!detailMap.containsKey(calcVO.getMaterialId())){
                detailVO = BeanMapper.map(calcVO, RentReportDetailVO.class);
                detailVO.setReportId(rentReportVO.getId());
            }else{
                detailVO = detailMap.get(calcVO.getMaterialId());
            }
            if("进场".equals(calcVO.getBillType()) && !detailAddedSet.contains(calcVO.getSourceDetailId())){
                detailVO.setMaxInNum(ComputeUtil.safeAdd(detailVO.getMaxInNum(), calcVO.getInOutNum()));
            } else if ((calcVO.getBillType().contains("退场") || calcVO.getBillType().contains("赔偿")) && !detailAddedSet.contains(calcVO.getSourceDetailId())) {
                detailVO.setRentNum(ComputeUtil.safeAdd(detailVO.getRentNum(), calcVO.getInOutNum()));
            }
            detailVO.setSumRentMny(ComputeUtil.safeAdd(detailVO.getSumRentMny(), calcVO.getMny()));
            detailVO.setSumRentTaxMny(ComputeUtil.safeAdd(detailVO.getSumRentTaxMny(), calcVO.getTaxMny()));
            detailAddedSet.add(calcVO.getSourceDetailId());
            detailMap.put(calcVO.getMaterialId(), detailVO);

//            RentReportRestituteVO restituteVO = null;
//            if(!restituteMap.containsKey(calcVO.getMaterialId())){
//                restituteVO = BeanMapper.map(calcVO, RentReportRestituteVO.class);
//                restituteVO.setReportId(rentReportVO.getId());
//            }else{
//                restituteVO = restituteMap.get(calcVO.getMaterialId());
//            }
//            if(calcVO.getBillType().contains("赔偿")){
//                if(!restituteAddedSet.contains(calcVO.getSourceDetailId())){
//                    restituteVO.setSumNum(ComputeUtil.safeAdd(restituteVO.getSumNum(), calcVO.getInOutNum()));
//                }
//                restituteVO.setSumRentMny(ComputeUtil.safeAdd(restituteVO.getSumRentMny(), calcVO.getMny()));
//                restituteVO.setSumRentTaxMny(ComputeUtil.safeAdd(restituteVO.getSumRentTaxMny(), calcVO.getTaxMny()));
//            }
//            restituteAddedSet.add(calcVO.getSourceDetailId());
//            restituteMap.put(calcVO.getMaterialId(), restituteVO);
        }

        //查询本期：开始日期到结束日期前.补全本期金额
        List<RentReportCalcVO> reportCalcVOS = qryCalcList(projectId, beginDate, endDate, null, priceMap);
        rentReportVO.setCalcList(reportCalcVOS);
        for (RentReportCalcVO calcVO : reportCalcVOS) {
            RentReportDetailVO detailVO = detailMap.get(calcVO.getMaterialId());
            detailVO.setRentMny(ComputeUtil.safeAdd(detailVO.getRentMny(), calcVO.getMny()));
            detailVO.setRentTaxMny(ComputeUtil.safeAdd(detailVO.getRentTaxMny(), calcVO.getTaxMny()));
            detailMap.put(calcVO.getMaterialId(), detailVO);

//            RentReportRestituteVO restituteVO = restituteMap.get(calcVO.getMaterialId());
//            if(calcVO.getBillType().contains("赔偿")){
//                restituteVO.setRentMny(ComputeUtil.safeAdd(restituteVO.getRentMny(), calcVO.getMny()));
//                restituteVO.setRentTaxMny(ComputeUtil.safeAdd(restituteVO.getRentTaxMny(), calcVO.getTaxMny()));
//            }
//            restituteMap.put(calcVO.getMaterialId(), restituteVO);
        }
        if (!detailMap.isEmpty()) {
            for (RentReportDetailVO detailVO : detailMap.values()) {
                //退场和赔偿数量是负的，所以此处实际为减去
                detailVO.setRentNum(ComputeUtil.safeAdd(detailVO.getMaxInNum(), detailVO.getRentNum()));

                rentReportVO.setTotalMny(ComputeUtil.safeAdd(rentReportVO.getTotalMny(), detailVO.getRentMny()));
                rentReportVO.setRentMny(ComputeUtil.safeAdd(rentReportVO.getRentMny(), detailVO.getRentMny()));
            }
            rentReportVO.setDetailList(new ArrayList<>(detailMap.values()));
        }

//        if (!restituteMap.isEmpty()) {
//            for (RentReportRestituteVO restituteVO : restituteMap.values()) {
//                rentReportVO.setTotalMny(ComputeUtil.safeAdd(rentReportVO.getTotalMny(), restituteVO.getRentMny()));
//                rentReportVO.setOtherMny(ComputeUtil.safeAdd(rentReportVO.getOtherMny(), restituteVO.getRentTaxMny()));
//            }
//            rentReportVO.setRestituteList(new ArrayList<>(restituteMap.values()));
//        }


        LambdaQueryWrapper<RestituteEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RestituteEntity::getProjectId, projectId);
        queryWrapper.in(RestituteEntity::getBillState, "1,3");
        queryWrapper.between(RestituteEntity::getRestituteDate, "1990-01-01", endDate);
        List<RestituteEntity> restituteEntities = restituteService.list(queryWrapper);

        if (CollectionUtils.isNotEmpty(restituteEntities)) {
            rentReportVO.setRestituteList(qryRestituteVOList(rentReportVO, beginDate, restituteEntities));
        }

        if (CollectionUtils.isNotEmpty(restituteEntities)) {
            rentReportVO.setRepairList(qryRepairVOList(rentReportVO, beginDate,  restituteEntities));
        }

        rentReportVO.setOtherList(qryOtherVOList(rentReportVO, projectId, beginDate, endDate, restituteEntities));

        return rentReportVO;
    }

    @Override
    public List<RentReportCalcVO> qryReportCalcList(Long projectId, String beginDate, String endDate, Long materialId) {
        Map<String, List<ContInfoPriceRecordVO>> priceMap = new HashMap<>();
        return qryCalcList(projectId, beginDate, endDate, materialId, priceMap);
    }

    private List<RentReportRestituteVO> qryRestituteVOList(RentReportVO rentReportVO,String beginDate, List<RestituteEntity> restituteEntities){
        Map<Long, RentReportRestituteVO> restituteMap = new HashMap<>();
        Set<Long> bqSet = new HashSet<>();
        List<Long> allList = new ArrayList<>();
        Date begin = null;
        try {
            begin = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
        } catch (ParseException e) {
            logger.error(e.getMessage());
        }
        for(RestituteEntity entity : restituteEntities){
            allList.add(entity.getId());
            if(begin.compareTo(entity.getRestituteDate()) <= 0){
                bqSet.add(entity.getId());
            }
        }

        if (CollectionUtils.isNotEmpty(restituteEntities)) {
            LambdaQueryWrapper<RestituteScrapEntity> query = new LambdaQueryWrapper<>();
            query.in(RestituteScrapEntity::getRestituteId, allList);
            List<RestituteScrapEntity> scrapEntities = restituteScrapService.list(query);
            for (RestituteScrapEntity scrapEntity : scrapEntities) {
                RentReportRestituteVO restituteVO = null;
                if(!restituteMap.containsKey(scrapEntity.getMaterialId())){
                   restituteVO = BeanMapper.map(scrapEntity, RentReportRestituteVO.class);
                   restituteVO.setId(IdWorker.getId());
                   restituteVO.setReportId(rentReportVO.getId());
                }else {
                    restituteVO = restituteMap.get(scrapEntity.getMaterialId());
                }
                if(bqSet.contains(scrapEntity.getRestituteId())){
                    restituteVO.setSumNum(ComputeUtil.safeAdd(restituteVO.getSumNum(), scrapEntity.getDamageNum()));
                    restituteVO.setRentMny(ComputeUtil.safeAdd(restituteVO.getRentMny(), scrapEntity.getDamageMny()));
                    restituteVO.setRentTaxMny(ComputeUtil.safeAdd(restituteVO.getRentTaxMny(), scrapEntity.getDamageTaxMny()));

                    rentReportVO.setTotalMny(ComputeUtil.safeAdd(rentReportVO.getTotalMny(), scrapEntity.getDamageMny()));
                    rentReportVO.setOtherMny(ComputeUtil.safeAdd(rentReportVO.getOtherMny(), scrapEntity.getDamageMny()));
                }
                restituteVO.setSumRentMny(ComputeUtil.safeAdd(restituteVO.getSumRentMny(), scrapEntity.getDamageMny()));
                restituteVO.setSumRentTaxMny(ComputeUtil.safeAdd(restituteVO.getSumRentTaxMny(), scrapEntity.getDamageTaxMny()));
                restituteMap.put(scrapEntity.getMaterialId(), restituteVO);
            }
        }
        return new ArrayList<>(restituteMap.values());
    }


    private List<RentReportRepairVO> qryRepairVOList(RentReportVO rentReportVO, String beginDate, List<RestituteEntity> restituteEntities){
        Map<Long, RentReportRepairVO> repairMap = new HashMap<>();
        Set<Long> bqSet = new HashSet<>();
        List<Long> allList = new ArrayList<>();
        Date begin = null;
        try {
            begin = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
        } catch (ParseException e) {
            logger.error(e.getMessage());
        }
        for(RestituteEntity entity : restituteEntities){
            allList.add(entity.getId());
            if(begin.compareTo(entity.getRestituteDate()) <= 0){
                bqSet.add(entity.getId());
            }
        }

        LambdaQueryWrapper<RestituteMaintainEntity> query = new LambdaQueryWrapper<>();
        query.in(RestituteMaintainEntity::getRestituteId, allList);
        List<RestituteMaintainEntity> detailEntities = restituteMaintainService.list(query);
        for (RestituteMaintainEntity maintainEntity : detailEntities) {
            RentReportRepairVO repairVO = null;
            if(!repairMap.containsKey(maintainEntity.getMaterialId())){
                repairVO = BeanMapper.map(maintainEntity, RentReportRepairVO.class);
                repairVO.setId(IdWorker.getId());
                repairVO.setReportId(rentReportVO.getId());
            }else {
                repairVO = repairMap.get(maintainEntity.getMaterialId());
            }
            if(bqSet.contains(maintainEntity.getRestituteId())){
                repairVO.setSumNum(ComputeUtil.safeAdd(repairVO.getSumNum(), maintainEntity.getMaintainNum()));
                repairVO.setRentMny(ComputeUtil.safeAdd(repairVO.getRentMny(), maintainEntity.getMaintainMny()));
                repairVO.setRentTaxMny(ComputeUtil.safeAdd(repairVO.getRentTaxMny(), maintainEntity.getMaintainTaxMny()));

                rentReportVO.setTotalMny(ComputeUtil.safeAdd(rentReportVO.getTotalMny(), maintainEntity.getMaintainMny()));
                rentReportVO.setOtherMny(ComputeUtil.safeAdd(rentReportVO.getOtherMny(), maintainEntity.getMaintainMny()));
            }
            repairVO.setSumRentMny(ComputeUtil.safeAdd(repairVO.getSumRentMny(), maintainEntity.getMaintainMny()));
            repairVO.setSumRentTaxMny(ComputeUtil.safeAdd(repairVO.getSumRentTaxMny(), maintainEntity.getMaintainTaxMny()));
            repairMap.put(maintainEntity.getMaterialId(), repairVO);
        }
        return new ArrayList<>(repairMap.values());
    }

    private List<RentReportOtherVO> qryOtherVOList(RentReportVO rentReportVO, Long projectId, String beginDate, String endDate, List<RestituteEntity> restituteEntities){
        RentReportOtherVO otherVO = null;
        Set<Long> bqSet = new HashSet<>();
        List<Long> allList = new ArrayList<>();
        Date begin = null;
        Date end = null;
        try {
            begin = new SimpleDateFormat("yyyy-MM-dd").parse(beginDate);
            end = new SimpleDateFormat("yyyy-MM-dd").parse(endDate);
        } catch (ParseException e) {
            logger.error(e.getMessage());
        }
        rentReportVO.setBeginDate(begin);
        rentReportVO.setEndDate(end);
        for(RestituteEntity entity : restituteEntities){
            allList.add(entity.getId());
            if(begin.compareTo(entity.getRestituteDate()) <= 0){
                bqSet.add(entity.getId());
            }
        }

        if (CollectionUtils.isNotEmpty(restituteEntities)) {
            otherVO = new RentReportOtherVO();
            otherVO.setId(IdWorker.getId());
            otherVO.setReportId(rentReportVO.getId());
            LambdaQueryWrapper<RestituteOtherEntity> query = new LambdaQueryWrapper<>();
            query.in(RestituteOtherEntity::getRestituteId, allList);
            List<RestituteOtherEntity> detailEntities = restituteOtherService.list(query);
            for (RestituteOtherEntity otherEntity : detailEntities) {
                if(bqSet.contains(otherEntity.getRestituteId())){
                    otherVO.setRentMny(ComputeUtil.safeAdd(otherVO.getRentMny(), otherEntity.getCurrentAmount()));
                    otherVO.setRentTaxMny(ComputeUtil.safeAdd(otherVO.getRentTaxMny(), otherEntity.getCurrentTaxAmount()));

                    rentReportVO.setTotalMny(ComputeUtil.safeAdd(rentReportVO.getTotalMny(), otherEntity.getCurrentAmount()));
                    rentReportVO.setOtherMny(ComputeUtil.safeAdd(rentReportVO.getOtherMny(), otherEntity.getCurrentAmount()));
                }
                otherVO.setSumMny(ComputeUtil.safeAdd(otherVO.getSumMny(), otherEntity.getCurrentAmount()));
                otherVO.setSumTaxMny(ComputeUtil.safeAdd(otherVO.getSumTaxMny(), otherEntity.getCurrentTaxAmount()));
            }
        }

        LambdaQueryWrapper<CalculateEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CalculateEntity::getProjectId, projectId);
        queryWrapper.in(CalculateEntity::getBillState, "1,3");
        queryWrapper.between(CalculateEntity::getRentDate, "1990-01-01", endDate);
        List<CalculateEntity> calculateEntities = calculateService.list(queryWrapper);
        bqSet = new HashSet<>();
        allList = new ArrayList<>();
        for(CalculateEntity entity : calculateEntities){
            allList.add(entity.getId());
            if(begin.compareTo(entity.getRentDate()) <= 0){
                bqSet.add(entity.getId());
            }
        }

        if (CollectionUtils.isNotEmpty(calculateEntities)) {
            if (otherVO == null) {
                otherVO = new RentReportOtherVO();
                otherVO.setId(IdWorker.getId());
                otherVO.setReportId(rentReportVO.getId());
            }
            LambdaQueryWrapper<CalculateOtherEntity> qry = new LambdaQueryWrapper<>();
            qry.in(CalculateOtherEntity::getCalculateId, allList);
            List<CalculateOtherEntity> otherEntities = calculateOtherService.list(qry);
            for (CalculateOtherEntity otherEntity : otherEntities) {
                if(bqSet.contains(otherEntity.getCalculateId())){
                    otherVO.setRentMny(ComputeUtil.safeAdd(otherVO.getRentMny(), otherEntity.getMny()));
                    otherVO.setRentTaxMny(ComputeUtil.safeAdd(otherVO.getRentTaxMny(), otherEntity.getTaxMny()));

                    rentReportVO.setTotalMny(ComputeUtil.safeAdd(rentReportVO.getTotalMny(), otherEntity.getMny()));
                    rentReportVO.setOtherMny(ComputeUtil.safeAdd(rentReportVO.getOtherMny(), otherEntity.getMny()));
                }
                otherVO.setSumMny(ComputeUtil.safeAdd(otherVO.getSumMny(), otherEntity.getMny()));
                otherVO.setSumTaxMny(ComputeUtil.safeAdd(otherVO.getSumTaxMny(), otherEntity.getTaxMny()));
            }
        }
        if (null == otherVO) {
            return null;
        }
        return Arrays.asList(new RentReportOtherVO[]{otherVO});
    }


    private List<RentReportCalcVO> qryCalcList(Long projectId, String beginDate, String endDate, Long materialId, Map<String, List<ContInfoPriceRecordVO>> priceMap){
        Map<String, String> billTypeMap = new HashMap<>();
        billTypeMap.put("1", "进场");
        billTypeMap.put("2", "停租");
        billTypeMap.put("3", "再启租");
        billTypeMap.put("40", "退场(停用)");
        billTypeMap.put("41", "退场(启用)");
        billTypeMap.put("50", "赔偿(停用)");
        billTypeMap.put("51", "赔偿(启用)");
        List<RentReportCalcVO> result = new ArrayList<>();
        Map<String, CmContractInfoVO> infoMap = new HashMap<>();
        CommonResponse<List<ProjectRegisterVO>> response = projectApi.queryProjectByIds(Arrays.asList(new Long[]{projectId}));
        ProjectRegisterVO projectRegisterVO = response.getData().get(0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = null;
        Date end = null;
        try {
            begin = format.parse(beginDate);
            end = format.parse(endDate);
        } catch (ParseException e) {
           logger.error(e.getMessage());
        }
        LambdaQueryWrapper<RmatFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RmatFlowEntity::getProjectId, projectId);
        queryWrapper.eq(RmatFlowEntity::getEffectiveState, 1);
        queryWrapper.eq(null != materialId, RmatFlowEntity::getMaterialId, materialId);
        List<RmatFlowEntity> flowEntities = rmatFlowService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(flowEntities)) {
            List<RmatFlowEntity> periodList = new ArrayList<>();
            List<RmatFlowEntity> flowList = new ArrayList<>();
            for (RmatFlowEntity flowEntity : flowEntities) {
                if(flowEntity.getDetailDate().compareTo(begin) < 0){
                    periodList.add(flowEntity);
                }else if(flowEntity.getDetailDate().compareTo(begin) >=0 && flowEntity.getDetailDate().compareTo(end) <= 0){
                    flowList.add(flowEntity);
                }
            }
            if(CollectionUtils.isNotEmpty(periodList)){
                Map<String, RentReportCalcVO> map = new HashMap<>();
                for (RmatFlowEntity flowEntity : periodList) {
                    if (!infoMap.containsKey(flowEntity.getInfoId())) {
                        CommonResponse<List<CmContractInfoVO>> commonResponse = cmContractInfoApi.queryLeaseContractInfoById(flowEntity.getContractId());
                        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                            for(CmContractInfoVO infoVO : commonResponse.getData()){
                                infoMap.put(infoVO.getPkContractinfo(), infoVO);
                            }
                        }
                    }

                    String key = flowEntity.getContractId() + "@" + flowEntity.getMaterialId() + "@" + flowEntity.getUseStatus();
                    RentReportCalcVO calcVO = null;
                    //期初启用
                    if("1".equals(flowEntity.getUseStatus())){
                        if (!map.containsKey(key)) {
                            calcVO = new RentReportCalcVO();
                            transferVO(flowEntity, calcVO, projectRegisterVO, infoMap);
                            calcVO.setBillType("期初启用");
                            calcVO.setBillCode("/");
                            calcVO.setBillDate(begin);
                            calcVO.setBillCreateTime("/");
                            calcVO.setRentEndDate(end);
                        }else{
                            calcVO = map.get(key);
                        }
                        //启用的退场，减去
                        if (RmatCommonConsts.OUT.equals(flowEntity.getInOutFlag())) {
                            calcVO.setInOutNum(ComputeUtil.safeSub(calcVO.getInOutNum(), flowEntity.getRentNum()));
                        }else {
                            calcVO.setInOutNum(ComputeUtil.safeAdd(calcVO.getInOutNum(), flowEntity.getRentNum()));
                        }
                    }else  if(MaterialConstant.NO.equals(flowEntity.getUseStatus())){ //期初停用
                        if (!map.containsKey(key)) {
                            calcVO = new RentReportCalcVO();
                            transferVO(flowEntity, calcVO, projectRegisterVO, infoMap);
                            calcVO.setBillType("期初停用");
                            calcVO.setBillCode("/");
                            calcVO.setBillDate(begin);
                            calcVO.setBillCreateTime("/");
                            calcVO.setRentEndDate(end);
                        }else{
                            calcVO = map.get(key);
                        }

                        calcVO.setStopPrice("2".equals(flowEntity.getFlowType()) ? stopDetailService.selectById(flowEntity.getSourceDetailId()).getStopPrice() : null);

                        //停用的退场，加上
                        if (RmatCommonConsts.OUT.equals(flowEntity.getInOutFlag())) {
                            calcVO.setInOutNum(ComputeUtil.safeAdd(calcVO.getInOutNum(), flowEntity.getRentNum()));
                        }else {
                            calcVO.setInOutNum(ComputeUtil.safeSub(calcVO.getInOutNum(), flowEntity.getRentNum()));
                        }
                    }
                    map.put(key, calcVO);
                }
                if (!map.isEmpty()) {
                    result.addAll(map.values());
                }
            }

            if(CollectionUtils.isNotEmpty(flowList)){
                for (RmatFlowEntity flowEntity : flowList) {
                    if (!infoMap.containsKey(flowEntity.getInfoId())) {
                        CommonResponse<List<CmContractInfoVO>> commonResponse = cmContractInfoApi.queryLeaseContractInfoById(flowEntity.getContractId());
                        if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                            for(CmContractInfoVO infoVO : commonResponse.getData()){
                                infoMap.put(infoVO.getPkContractinfo(), infoVO);
                            }
                        }
                    }
                    RentReportCalcVO calcVO = new RentReportCalcVO();
                    transferVO(flowEntity, calcVO, projectRegisterVO, infoMap);
                    //退场和赔偿区分启用停用
                    if("4, 5".contains(flowEntity.getFlowType())){
                        calcVO.setBillType(billTypeMap.get(flowEntity.getFlowType() + flowEntity.getUseStatus()));
                    }else{
                        calcVO.setBillType(billTypeMap.get(flowEntity.getFlowType()));
                    }
                    calcVO.setBillCode(flowEntity.getBillCode());
                    calcVO.setBillDate(flowEntity.getDetailDate());
                    calcVO.setBillCreateTime(DateUtil.formatDate(flowEntity.getBillCreateTime()));
                    calcVO.setRentEndDate(end);
                    //停用类型的，补全停用单价
                    if (MaterialConstant.NO.equals(flowEntity.getUseStatus())) {
                        LambdaQueryWrapper<StopEntity> qry = new LambdaQueryWrapper<>();
                        qry.eq(StopEntity::getContractId, flowEntity.getContractId());
                        qry.in(StopEntity::getBillState, "1,3");
                        List<StopEntity> stopEntities = stopService.list(qry);
                        List<Long> stopIdList = stopEntities.stream().map(StopEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper<StopDetailEntity> query = new LambdaQueryWrapper<>();
                        query.in(StopDetailEntity::getStopId, stopIdList);
                        query.orderByDesc(StopDetailEntity::getStopTime);
                        query.last("limit 1");
                        StopDetailEntity stopDetailEntity = stopDetailService.getOne(query, false);
                        calcVO.setStopPrice(stopDetailEntity.getStopPrice());
                    }

                    //进场和再启租，记正数
                    if ("1,3".contains(flowEntity.getFlowType())) {
                        calcVO.setInOutNum(flowEntity.getRentNum());
                    } else {
                        calcVO.setInOutNum(ComputeUtil.safeSub(BigDecimal.ZERO, flowEntity.getRentNum()));
                    }
                    result.add(calcVO);
                }
            }
        }
        return  fullPriceAndMny(result, priceMap);
    }

    /**
     * 转换材料明细信息
     * @param detail
     * @param vo
     * @param infoMap
     */
    private void transferVO(RmatFlowEntity detail, RentReportCalcVO vo, ProjectRegisterVO projectRegisterVO, Map<String, CmContractInfoVO> infoMap) {
        vo.setId(IdWorker.getId());
        vo.setProjectId(detail.getProjectId());
        vo.setProjectCode(projectRegisterVO.getCode());
        vo.setProjectName(detail.getProjectName());
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setContractInfoId(detail.getInfoId());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgName(detail.getOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());
        vo.setParentOrgId(projectRegisterVO.getOrgId());
        vo.setParentOrgName(projectRegisterVO.getOrgName());
        vo.setRealCorpId(projectRegisterVO.getRealCorpId());
        vo.setRealNcCorp(projectRegisterVO.getRealNcCorp());
        vo.setRealCorpName(projectRegisterVO.getRealCorpName());
        vo.setSourceDetailId(detail.getSourceDetailId());
        vo.setRentUnitId(detail.getRentUnitId());
        vo.setRentUnitName(detail.getRentUnitName());

        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setMaterialSourceId(detail.getMaterialSourceId());
        vo.setSpec(detail.getSpec());
        vo.setMemo(detail.getMemo());

        vo.setTaxRate(infoMap.get(vo.getContractInfoId()).getSl());
    }

    private List<RentReportCalcVO> fullPriceAndMny(List<RentReportCalcVO> calcList, Map<String, List<ContInfoPriceRecordVO>> priceMap){
        List<RentReportCalcVO> result = new ArrayList<>();
        for(RentReportCalcVO calcVO : calcList){
            List<ContInfoPriceRecordVO> priceRecordVOS = priceMap.containsKey(calcVO.getContractInfoId()) ? priceMap.get(calcVO.getContractInfoId()) : contInfoPriceRecordService.qryByContId(calcVO.getContractId(), calcVO.getContractInfoId());
            if(CollectionUtils.isNotEmpty(priceRecordVOS)){
                int anInt = findInt(calcVO.getBillDate(), priceRecordVOS);
                for (int i = anInt; i < priceRecordVOS.size(); i++) {
                    RentReportCalcVO newCalcVO = BeanMapper.map(calcVO, RentReportCalcVO.class);
                    newCalcVO.setId(IdWorker.getId());
                    newCalcVO.setStartPrice(priceRecordVOS.get(i).getNhireprice());
                    if (i != anInt) {
                        newCalcVO.setBillDate(priceRecordVOS.get(i).getDactivedate());
                        newCalcVO.setBillCreateTime(DateUtil.formatDate(priceRecordVOS.get(i).getDmakedate()));
                    }
                    if ((i + 1) <= (priceRecordVOS.size() - 1)) {
                        Date calcEndDate = DateUtil.addDays(priceRecordVOS.get(i + 1).getDactivedate(), -1);
                        if(newCalcVO.getRentEndDate().compareTo(calcEndDate) < 0){
                            result.add(newCalcVO);
                           break;
                        }else{
                            newCalcVO.setRentEndDate(calcEndDate);
                        }
                    }
                    result.add(newCalcVO);
                }
            }else{
                result.add(calcVO);
            }
            priceMap.put(calcVO.getContractInfoId(), priceRecordVOS);
        }

        for (RentReportCalcVO calcVO : result) {
            calcVO.setPrice(ComputeUtil.safeSub(calcVO.getStartPrice(), calcVO.getStopPrice()));
            calcVO.setRentDayNum(BigDecimal.valueOf(DateUtil.getSubDay(calcVO.getRentEndDate(), calcVO.getBillDate())));
            calcVO.setMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(calcVO.getRentDayNum(), ComputeUtil.safeMultiply(calcVO.getPrice(), calcVO.getInOutNum()))));
            calcVO.setTaxMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(calcVO.getMny(), ComputeUtil.safeAdd(ComputeUtil.safeDiv(calcVO.getTaxRate(), BigDecimal.valueOf(100)), BigDecimal.ONE))));
        }

        return result;
    }

    private int findInt(Date date, List<ContInfoPriceRecordVO> priceRecordVOS){
        int k = 0;
        for (int i = 0; i < priceRecordVOS.size(); i++) {
            ContInfoPriceRecordVO recordVO = priceRecordVOS.get(i);
            if(date.compareTo(recordVO.getDactivedate()) >= 0){
                k = i;
            }
        }
        return  k;
    }
}
