package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.CommonSupportService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("restitute")
public class RestituteBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRestituteService service;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IRmatFlowService flowService;

    @Autowired
    private CommonSupportService commonSupportService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity restituteEntity = service.selectById(billId);
        //已拒绝,重新提交需要改为未确认状态
        if (2 == restituteEntity.getConfirmFlag()) {
            restituteEntity.setConfirmFlag(0);
        }
        restituteEntity.setCommitId(InvocationInfoProxy.getUserid().toString());
        service.saveOrUpdate(restituteEntity, false);
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
		/*RestituteEntity entity = service.selectById(billId);
		entity.setSubmitTime(new Date());
		service.saveOrUpdate(entity,false);*/
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity entity = service.selectById(billId);

        if(CollectionUtils.isNotEmpty(entity.getRestituteDetailList())){
            // 推送流水生效
            if (!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.YES)) {
                return CommonResponse.error("审批回调失败，单据推送流水失败！");
            }
        }
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = commonSupportService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            logger.info("赔偿单推送供方JSON------" + JSONObject.toJSONString(BeanMapper.map(entity, RestituteVO.class)));
            CommonResponse<String> pushres = service.pushConfirmEntity(headers, entity);
            logger.info("获取推送供方结果--" + pushres);
            if (pushres.isSuccess()) {
                //推送成功后处理逻辑
                if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
                    //已拒绝,重新提交需要改为未确认状态
                    if (2 == entity.getConfirmFlag()) {
                        entity.setConfirmFlag(0);
                    }
                    entity.setCommitId(InvocationInfoProxy.getUserid().toString());
                }
                service.saveOrUpdate(entity, false);
            } else {
                return pushres;
            }
        } else {
            return tokenres;
        }
        return CommonResponse.success("审批回调成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity entity = service.selectById(billId);

        materialService.validateContract(entity.getContractId(), "BT221025000000001", billId, MaterialConstant.弃审);
        // 校验必须大于最大单据日期
        service.validateTime(BeanMapper.map(entity, RestituteVO.class), MaterialConstant.弃审);

        if (entity.getConfirmFlag() == 1) {
            return CommonResponse.error("赔偿单供方已确认不支持撤回!");
        }
        return CommonResponse.success("弃审前回调成功！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity entity = service.selectById(billId);
        //推送供方
        Map<String, String> headers = new HashMap<>();
        CommonResponse<String> tokenres = commonSupportService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            logger.info("获取供方token--" + headers);
            CommonResponse<String> pushres = service.pushDelete(headers, entity);
            logger.info("获取推送供方结果--" + pushres);
            if (pushres.isSuccess()) {
                    /*//推送成功后处理逻辑
                    if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
                        //已拒绝,重新提交需要改为未确认状态
                        if (2 == exitEntity.getConfirmFlag()) {
                            exitEntity.setConfirmFlag(0);
                        }
                        exitEntity.setCommitId(InvocationInfoProxy.getUserid());
                    }
                    service.saveOrUpdate(exitEntity, false);*/
            } else {
                return pushres;
            }
        } else {
            return tokenres;
        }
        if(CollectionUtils.isNotEmpty(entity.getRestituteDetailList())) {
            // 推送流水未生效
            if (!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.NO)) {
                return CommonResponse.error("弃审后回调失败，单据推送流水失败！");
            }
        }
        return CommonResponse.success("弃审后回调成功！");
    }
}
