package com.ejianc.business.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 退赔单
 *
 * @author generator
 *
 */
 @TableName("ejc_rmat_restitute")
public class RestituteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private String contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商主键
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="supplier_sign_status")
    private Integer supplierSignStatus; // 签字状态(已签字-1,未签字-0)
    @TableField(value="sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @TableField(value="sup_operate_time")
    private Date supOperateTime; // 供方经办人签字时间
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号
    @TableField(value="restitute_date")
    private Date restituteDate; // 退赔日期
    @TableField(value="total_maintain_tax_mny")
    private BigDecimal totalMaintainTaxMny; // 本次维修金额汇总
    @TableField(value="total_maintain_mny")
    private BigDecimal totalMaintainMny; // 本次维修金额汇总(无税)
    @TableField(value="total_maintain_tax")
    private BigDecimal totalMaintainTax; // 维修税额汇总
    @TableField(value="total_scrap_tax_mny")
    private BigDecimal totalScrapTaxMny; // 本次报废金额汇总
    @TableField(value="total_scrap_mny")
    private BigDecimal totalScrapMny; // 本次报废金额汇总(无税)
    @TableField(value="total_scrap_tax")
    private BigDecimal totalScrapTax; // 报废税额汇总
    @TableField(value="push_flag")
    private Integer pushFlag; // 推送标识：0未推送 1已推送
    @TableField(value="restitute_sum_mny")
    private BigDecimal restituteSumMny; // 赔偿金额汇总无税
    @TableField(value="restitute_sum_tax_mny")
    private BigDecimal restituteSumTaxMny; // 赔偿金额汇总含税
    @TableField(value="settle_flag")
    private Integer settleFlag; // 是否结算：0 未结算 1 已结算
    @TableField(value="material_type_names")
    private String materialTypeNames; // 材料分类
    @TableField(value="confirm_note")
    private String confirmNote; // 供方确认说明
    @TableField(value="confirm_date")
    private Date confirmDate; // 确认日期
    @TableField(value="commit_id")
    private String commitId; // 终审人,推送供方
    @TableField(value="confirm_flag")
    private Integer confirmFlag; // 供方确认状态(0-待确认,1-已确认,2-已拒绝）
    @TableField(value = "project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="supplier_source_id")
    private String supplierSourceId; // 供应商来源ID
    @TableField(value="real_corp_id")
    private java.lang.Long realCorpId; // NC所属组织ID
    @TableField(value="real_nc_corp")
    private java.lang.String realNcCorp; // NC所属组织PK
    @TableField(value="real_corp_name")
    private java.lang.String realCorpName; // NC所属组织名称


    @TableField(exist=false)
    @SubEntity(serviceName="restituteMaintainService",pidName = "restituteId")
    private List<RestituteMaintainEntity> restituteMaintainList = new ArrayList<>(); // 退赔单维修清单明细
    @TableField(exist=false)
    @SubEntity(serviceName="restituteScrapService",pidName = "restituteId")
    private List<RestituteScrapEntity> restituteDetailList = new ArrayList<>(); // 退赔单报废清单明细
    @TableField(exist=false)
    @SubEntity(serviceName="restituteOtherService",pidName = "restituteId")
    private List<RestituteOtherEntity> otherList = new ArrayList<>(); // 退赔单其他费用明细

    public BigDecimal getRestituteSumTaxMny() {
        return restituteSumTaxMny;
    }

    public void setRestituteSumTaxMny(BigDecimal restituteSumTaxMny) {
        this.restituteSumTaxMny = restituteSumTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getConfirmFlag() {
        return confirmFlag;
    }

    public void setConfirmFlag(Integer confirmFlag) {
        this.confirmFlag = confirmFlag;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public Date getRestituteDate() {
        return restituteDate;
    }

    public void setRestituteDate(Date restituteDate) {
        this.restituteDate = restituteDate;
    }
    public BigDecimal getTotalMaintainTaxMny() {
        return totalMaintainTaxMny;
    }

    public void setTotalMaintainTaxMny(BigDecimal totalMaintainTaxMny) {
        this.totalMaintainTaxMny = totalMaintainTaxMny;
    }
    public BigDecimal getTotalMaintainMny() {
        return totalMaintainMny;
    }

    public void setTotalMaintainMny(BigDecimal totalMaintainMny) {
        this.totalMaintainMny = totalMaintainMny;
    }
    public BigDecimal getTotalMaintainTax() {
        return totalMaintainTax;
    }

    public void setTotalMaintainTax(BigDecimal totalMaintainTax) {
        this.totalMaintainTax = totalMaintainTax;
    }
    public BigDecimal getTotalScrapTaxMny() {
        return totalScrapTaxMny;
    }

    public void setTotalScrapTaxMny(BigDecimal totalScrapTaxMny) {
        this.totalScrapTaxMny = totalScrapTaxMny;
    }
    public BigDecimal getTotalScrapMny() {
        return totalScrapMny;
    }

    public void setTotalScrapMny(BigDecimal totalScrapMny) {
        this.totalScrapMny = totalScrapMny;
    }
    public BigDecimal getTotalScrapTax() {
        return totalScrapTax;
    }

    public void setTotalScrapTax(BigDecimal totalScrapTax) {
        this.totalScrapTax = totalScrapTax;
    }
    public Integer getPushFlag() {
        return pushFlag;
    }

    public void setPushFlag(Integer pushFlag) {
        this.pushFlag = pushFlag;
    }
    public BigDecimal getRestituteSumMny() {
        return restituteSumMny;
    }

    public void setRestituteSumMny(BigDecimal restituteSumMny) {
        this.restituteSumMny = restituteSumMny;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public List<RestituteMaintainEntity> getRestituteMaintainList() {
        return restituteMaintainList;
    }

    public void setRestituteMaintainList(List<RestituteMaintainEntity> restituteMaintainList) {
        this.restituteMaintainList = restituteMaintainList;
    }

    public List<RestituteScrapEntity> getRestituteDetailList() {
        return restituteDetailList;
    }

    public void setRestituteDetailList(List<RestituteScrapEntity> restituteDetailList) {
        this.restituteDetailList = restituteDetailList;
    }

    public List<RestituteOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<RestituteOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public String getConfirmNote() {
        return confirmNote;
    }

    public void setConfirmNote(String confirmNote) {
        this.confirmNote = confirmNote;
    }

    public Date getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }

    public String getCommitId() {
        return commitId;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }

    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }

    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }
}
