package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.vo.ExitApplyDetailVO;
import com.ejianc.business.rmat.vo.ExitApplyVO;
import com.ejianc.business.rmat.vo.OrderProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 退场申请单
 *
 * @author generator
 */
@Controller
@RequestMapping("exitApply")
public class ExitApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExitApplyService service;

    @Autowired
    private IExitService exitService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private CommonSupportService commonSupportService;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private ICoordinationSetService coordinationSetService;

    @Autowired
    private IProjectApi projectApi;


    private static final String billCodeRule = "EXIT_APPLY";


    /**
     * 修改确认结果信息
     *
     * @Param exitApplyVOS: 确认结果集合
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     **/
    @RequestMapping(value = "/updateConfirmFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> updateConfirmFlag(@RequestBody ExitApplyVO exitApplyVO) {

        if (null != exitApplyVO.getId()) {
            ExitApplyEntity entity = service.getById(exitApplyVO.getId());
            if (entity == null) {
                return CommonResponse.error("修改失败！【" + exitApplyVO.getId() + "】单据不存在！");
            }
        }
        return service.updateConfirmFlag(exitApplyVO);
    }
    @RequestMapping(value = "/query2", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> query2(Long billId) {
        ExitApplyEntity exitApplyEntity = service.selectById(billId);
        //查询是否强制推送供方
        Boolean falg = coordinationSetService.querySupplyByOrgId(exitApplyEntity.getOrgId());
        if(falg) {
            if(exitApplyEntity.getConfirmFlag() == 1){
                return CommonResponse.error("退场申请供方已确认不支持撤回!");
            }else{
                //推送供方 删除供方单据
                Map<String, String> headers = new HashMap<>();
                CommonResponse<String> tokenres = commonSupportService.getAccessToken(headers);
                if (tokenres.isSuccess()) {
                    logger.info("获取供方token--" + headers);
                    CommonResponse<String> pushres = service.pushDelete(headers, exitApplyEntity);
                    logger.info("获取推送供方结果--" + pushres);
                    if (pushres.isSuccess()) {
						/*//推送成功后处理逻辑
						if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
							exitApplyEntity.setCommitId(InvocationInfoProxy.getUserid().toString());
							//已拒绝,重新提交需要改为未确认状态
							if (2 == exitApplyEntity.getConfirmFlag()) {
								exitApplyEntity.setConfirmFlag(0);
							}
						}
						service.saveOrUpdate(exitApplyEntity, false);*/
                    } else {
                        return pushres;
                    }
                } else {
                    return tokenres;
                }
            }
        }else{
            //退场单如果未引用支持撤回
            LambdaQueryWrapper<ExitEntity> lambda = Wrappers.<ExitEntity>lambdaQuery();
            lambda.eq(ExitEntity::getApplyId,exitApplyEntity.getId());
            List<ExitEntity> exitEntityList = exitService.list(lambda);
            if(CollectionUtils.isNotEmpty(exitEntityList)){
                return CommonResponse.error("退场申请单已被退场单引用不支持撤回!");
            }
        }


        return CommonResponse.success("查询详情数据成功！");

    }
    /**
     * 查询组织
     *
     * @Param orgId: orgId
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.OrderProjectVO>
     **/
    @RequestMapping(value = "/queryOrgSource", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderProjectVO> queryOrgSource(Long orgId) {
        OrderProjectVO res = new OrderProjectVO();
        CommonResponse<OrgVO> orgVo = orgApi.getOneById(orgId);
        if (!orgVo.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            res.setOrgId(orgId);
            res.setOrgSourceId(orgVo.getData().getSourceId());
            res.setParentOrgId(orgVo.getData().getParentId());
            //查询上级
            CommonResponse<OrgVO> parentOrgVo = orgApi.getOneById(orgVo.getData().getParentId());
            if (!parentOrgVo.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            if (null != parentOrgVo.getData()) {
                res.setParentOrgSourceId(parentOrgVo.getData().getSourceId());
            }
        }

        return CommonResponse.success("查询详情数据成功！", res);
    }


    /**
     * 查询最近联系人
     *
     * @Param projectId:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     **/
    @RequestMapping(value = "/queryLinkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitApplyVO> queryLinkDetail(Long projectId) {
        LambdaQueryWrapper<ExitApplyEntity> lambda = Wrappers.<ExitApplyEntity>lambdaQuery();
        lambda.eq(ExitApplyEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(ExitApplyEntity::getProjectId, projectId);
        lambda.eq(ExitApplyEntity::getEmployeeId, InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(ExitApplyEntity::getCreateTime);
        List<ExitApplyEntity> details = service.list(lambda);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details)) {
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0), ExitApplyVO.class));
        } else {
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * 关闭/取消申请
     *
     * @Param saveorUpdateVO:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     **/
    @RequestMapping(value = "/upateApplyState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> upateApplyState(@RequestBody ExitApplyVO saveorUpdateVO) {
        LambdaUpdateWrapper<ExitApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ExitApplyEntity::getId, saveorUpdateVO.getId());
        updateWrapper.set(ExitApplyEntity::getApplyState, saveorUpdateVO.getApplyState() == 1 ? 0 : 1);
        service.update(updateWrapper);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> saveOrUpdate(@RequestBody ExitApplyVO saveorUpdateVO) {
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (null == saveorUpdateVO.getId() && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
            saveorUpdateVO.setConfirmFlag(0);
            saveorUpdateVO.setApplyState(0);
        }
        StringBuffer materialName = new StringBuffer();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saveorUpdateVO.getExitApplyDetailEntityList())) {
            saveorUpdateVO.getExitApplyDetailEntityList().forEach(vo -> {
                materialName.append(vo.getMaterialName() + ",");
            });
            String materialNames = materialName.substring(0, materialName.length() - 1);
            saveorUpdateVO.setMaterialName(materialNames);
        }
        ExitApplyEntity entity = BeanMapper.map(saveorUpdateVO, ExitApplyEntity.class);
        //validateNum(saveorUpdateVO);
        service.saveOrUpdate(entity, false);
        ExitApplyVO vo = BeanMapper.map(entity, ExitApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
     /* 校验数量不能大于可参照数量
     * @param restituteVO
     * @return
             */
  /*  private String validateNum(ExitApplyVO saveorUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, saveorUpdateVO.getContractId()));
        List<MaterialVO> list = materialService.queryCheckList(param, "rest");
        Map<String, MaterialVO> map
        for(MaterialVO vo : list){

        }
        Map<String, MaterialVO> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId() + "|" + x.getRefNum() + "|" + x.getUseStatus(), Function.iden.

                tity()));
        String key = null;
        BigDecimal num = BigDecimal.ZERO;
        for(ExitApplyDetailVO vo : saveorUpdateVO.getExitApplyDetailEntityList()){
          *//*  num = ComputeUtil.safeSub(vo.getFullNum(), vo.getMaintainNum(), vo.getScrapNum());
            key

                    = vo.getMaterialId() + "|" + vo.getRentCalculationType() + "|" + vo.getUseStatus() + "|" + vo.getTransScale();
   *//*         if(map.containsKey(key) && num.compareTo(map.get(key).getRefNum()) > 0){
                throw new BusinessException("子表数量大于可参照数量");
            }
        }
        return "校验通过！";
    }
*/
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitApplyVO> queryDetail(Long id) {
        ExitApplyEntity entity = service.selectById(id);
        ExitApplyVO vo = BeanMapper.map(entity, ExitApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitApplyVO> vos) {
        service.removeByIds(vos.stream().map(ExitApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例
         * 模糊搜索：单据编号、项目名称、合同名称、出资单位、编制人
         * 高级筛选：退场日期（时间区间）；单据状态（标准筛选）；*/
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("orgId");
        if (!mobile) {
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<ExitApplyEntity> page = service.queryPage(param, false);
        IPage<ExitApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 导出
     *
     * @Param param: 参数
     * @Param response: 文件流
     * @Return void
     **/
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /*Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }*/
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        service.excelExport(param, response);
    }


    /**
     * 新增,参照材料库,查询并补录材料库在场和退场数据信息
     *
     * @Param exitApplyVO: 合同id 表体材料库信息
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     **/
    @RequestMapping(value = "/queryForAddDeatil", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExitApplyDetailVO>> queryForAddDeatil(@RequestBody ExitApplyVO exitApplyVO) {
        String contractId = exitApplyVO.getContractId();
        List<ExitApplyDetailVO> exitApplyDetail = exitApplyVO.getExitApplyDetailEntityList();
        if (StringUtils.isNotEmpty(contractId) && !org.springframework.util.CollectionUtils.isEmpty(exitApplyDetail)) {
            //List<Long> materialIds = exitApplyDetail.stream().map(ExitApplyDetailVO::getMaterialId).collect(Collectors.toList());
            List<ExitApplyDetailVO> exitApplyDetailVOList = service.queryForAddDeatil(contractId, null, InvocationInfoProxy.getTenantid());
            Map<Long, ExitApplyDetailVO> detailVOMap = null;
            if (!org.springframework.util.CollectionUtils.isEmpty(exitApplyDetailVOList)) {
                detailVOMap = exitApplyDetailVOList.stream().collect(Collectors.toMap(ExitApplyDetailVO::getMaterialId, exitApplyDetailVO -> exitApplyDetailVO));
            }
            for (ExitApplyDetailVO item : exitApplyDetail) {
                Long materialId = item.getMaterialId();
                if (null != detailVOMap && detailVOMap.get(materialId) != null) {
                    ExitApplyDetailVO vo = detailVOMap.get(materialId);
                   // item.setExitedNum(vo.getExitedNum());
                    item.setRentNum(vo.getRentNum());
                } else {
                  //  item.setExitedNum(item.getExitedNum() == null ? BigDecimal.ZERO : item.getExitedNum());
                    item.setRentNum(item.getRentNum() == null ? BigDecimal.ZERO : item.getRentNum());
                }
            }

        }
        return CommonResponse.success("查询成功！", exitApplyDetail);
    }


    /**
     * 退场单参照
     *
     * @Param pageNumber: 当前页
     * @Param pageSize: 每页数
     * @Param condition: 查询条件
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.wzxt.vo.OrderDetailVO>>
     **/
    @RequestMapping(value = "exitApplyRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExitApplyVO>> exitApplyRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialCode");
        IPage<ExitApplyVO> pageData = new Page<>();
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf((String) conditionMap.get("projectId"));
                queryParam.getParams().put("projectId", new Parameter("eq", projectId));
                CommonResponse<List<ProjectRegisterVO>> response = projectApi.queryProjectByIds(Arrays.asList(new Long[]{projectId}));
                //如果强制申请 需要供方确认之后才能参照。否则不需要
                if(coordinationSetService.querySupplyByOrgId(response.getData().get(0).getProjectDepartmentId())){
                    queryParam.getParams().put("confirmFlag", new Parameter("eq", 1));
                }
                queryParam.getParams().put("applyState", new Parameter("eq", 0));
                List<Integer> ids = new ArrayList<>();
                ids.add(1);
                ids.add(3);
                queryParam.getParams().put("billState", new Parameter("in", ids));
                IPage<ExitApplyEntity> page = service.queryPage(queryParam, false);
                pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitApplyVO.class));
            }else{
                throw new BusinessException("网络异常，未获取到项目主键！");
            }
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


}
