package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.business.rmat.vo.StopDetailVO;
import com.ejianc.business.rmat.vo.StopVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.StopMapper;
import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.service.IStopService;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 停租单
 *
 * @author generator
 *
 */
@Service("stopService")
public class StopServiceImpl extends BaseServiceImpl<StopMapper, StopEntity> implements IStopService{

    @Autowired
    private IMaterialService materialService;

    @Override
    public String validateTime(StopVO stopVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", stopVO.getContractId());
        if(stopVO.getId() != null){
            params.put("billType", MaterialConstant.停用单);
            params.put("billId", stopVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        if (lastDate == null) {
            return "未获取最大租金计算日期！";
        }
        for (StopDetailVO detailVO : stopVO.getDetailList()) {
            if(DateUtil.compareDate(detailVO.getStopTime(), lastDate) < 0){
                throw new BusinessException(DateUtil.formatDate(detailVO.getStopTime())
                        + "小于等于最大租金计算日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public String validateContract(String contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<StopEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的停用单，不允许新增!");
        }
        return "校验通过！";
    }
}
