/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.service.IRestituteScrapService;
import com.ejianc.business.rmat.vo.ReportCorpNewVO;
import com.ejianc.business.rmat.vo.ReportCorpPcVO;
import com.ejianc.business.rmat.vo.ReportCorpTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reportCorp"})
public class ReportCorpController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IReportDailyService service;
    @Autowired
    private IRestituteScrapService restituteScrapService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;

    @RequestMapping(value={"/qryTopInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportCorpTopVO> qryTopInfo(@RequestParam(value="orgId", required=false) Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.service.qryTopInfo(InvocationInfoProxy.getOrgId())));
    }

    @RequestMapping(value={"/qryDailyRise"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> qryDailyRise(@RequestParam(value="orgId", required=false) Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.service.qryDailyRise(InvocationInfoProxy.getOrgId()));
    }

    @RequestMapping(value={"/qryRentMnyDistribution"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> qryRentMnyDistribution(@RequestParam(value="orgId", required=false) Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.qryRentMnyDistribution(InvocationInfoProxy.getOrgId()));
    }

    @RequestMapping(value={"/queryPcList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> queryPcList(@RequestBody QueryParam param) {
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List orgVOS = (List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        ArrayList<Long> orgIds = new ArrayList();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)orgVOS)) {
            projectIds.add(InvocationInfoProxy.getOrgId());
        } else {
            orgIds = orgVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReportCorpPcVO> list = this.restituteScrapService.queryPcList((IPage<ReportCorpPcVO>)pageData, wrapper, orgIds, projectIds);
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReportCorpPcVO pcVO : list) {
                pcVO.setId(IdWorker.getId());
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/linkPcList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> linkPcList(@RequestBody QueryParam param) {
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List orgVOS = (List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        Object secondFlagObj = ((Parameter)param.getParams().get("secondFlag")).getValue();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        Map<Object, Object> map = new HashMap();
        boolean secondFlag = true;
        if (null != secondFlagObj && 1 == (Integer)secondFlagObj) {
            orgIds.add(InvocationInfoProxy.getOrgId());
        } else {
            orgIds = orgVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            map = orgVOS.stream().collect(Collectors.toMap(BaseVO::getId, OrgVO::getName, (k1, k2) -> k1));
            secondFlag = false;
        }
        param.getParams().remove("secondFlag");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReportCorpPcVO> list = this.restituteScrapService.linkPcList((IPage<ReportCorpPcVO>)pageData, wrapper, orgIds, secondFlag);
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReportCorpPcVO pcVO : list) {
                pcVO.setId(IdWorker.getId());
                if (secondFlag) continue;
                pcVO.setOrgName((String)map.get(pcVO.getOrgId()));
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRentList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> queryRentList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOS = (List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        ArrayList<Long> orgIds = new ArrayList();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)orgVOS)) {
            projectIds.add(InvocationInfoProxy.getOrgId());
        } else {
            orgIds = orgVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReportCorpPcVO> list = this.contInfoPriceRecordService.queryRentList(wrapper, orgIds, projectIds);
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)list.size());
        pageData.setRecords(this.paginate(list, param.getPageIndex(), param.getPageSize()));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryNewList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReportCorpNewVO>> queryNewList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOS = (List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData();
        ArrayList<Long> orgIds = new ArrayList();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)orgVOS)) {
            projectIds.add(InvocationInfoProxy.getOrgId());
        } else {
            orgIds = orgVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReportCorpPcVO> list = this.contInfoPriceRecordService.queryRentList(wrapper, orgIds, projectIds);
        List<ReportCorpPcVO> paginate = this.paginate(list, param.getPageIndex(), param.getPageSize());
        ArrayList<ReportCorpNewVO> result = new ArrayList<ReportCorpNewVO>();
        for (ReportCorpPcVO pcVO : paginate) {
            ReportCorpNewVO newVO = new ReportCorpNewVO();
            newVO.setId(IdWorker.getId());
            newVO.setContName("\u6d4b\u8bd5\u5408\u540c");
            newVO.setSupplierName("\u6d4b\u8bd5\u4f9b\u5e94\u5546");
            newVO.setMaterialTypeName(pcVO.getMaterialTypeName());
            newVO.setCtrlNum(new BigDecimal(new Random().nextInt(999999)));
            newVO.setInNum(new BigDecimal(new Random().nextInt(99999)));
            newVO.setExitNum(new BigDecimal(new Random().nextInt(99999)));
            newVO.setScapeNum(new BigDecimal(new Random().nextInt(99999)));
            newVO.setRentNum(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeSub((BigDecimal)newVO.getInNum(), (BigDecimal)newVO.getExitNum()), (BigDecimal)newVO.getScapeNum()));
            newVO.setRepareNum(new BigDecimal(new Random().nextInt(99999)));
            newVO.setExitScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)newVO.getExitNum(), (BigDecimal)newVO.getInNum()), (BigDecimal)new BigDecimal(100)));
            newVO.setScapeScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)newVO.getScapeNum(), (BigDecimal)newVO.getInNum()), (BigDecimal)new BigDecimal(100)));
            newVO.setSumSettleMny(new BigDecimal(new Random().nextInt(99999)));
            newVO.setSumSettleTaxMny(new BigDecimal(new Random().nextInt(99999)));
            result.add(newVO);
        }
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)list.size());
        pageData.setRecords(result);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public List<ReportCorpPcVO> paginate(List<ReportCorpPcVO> list, int pageIndex, int pageSize) {
        int total = list.size();
        int fromIndex = (pageIndex - 1) * pageSize;
        int toIndex = Math.min(fromIndex + pageSize, total);
        if (fromIndex > total || fromIndex < 0) {
            return new ArrayList<ReportCorpPcVO>();
        }
        return list.subList(fromIndex, toIndex);
    }
}

