/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.StartDetailEntity;
import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.IStartService;
import com.ejianc.business.rmat.vo.StartVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"start"})
public class StartController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRmatFlowService rmatFlowService;
    private static final String START_CODE = "START_CODE";
    @Autowired
    private IStartService service;
    @Autowired
    private IProjectApi projectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StartVO> saveOrUpdate(@RequestBody StartVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), "\u542f\u7528\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.service.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        StartEntity entity = (StartEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StartEntity.class));
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(START_CODE, InvocationInfoProxy.getTenantid());
        if (null == saveOrUpdateVO.getId()) {
            entity.setBillCode((String)codeBatchByRuleCode.getData());
            ArrayList<Long> projectId = new ArrayList<Long>();
            projectId.add(entity.getProjectId());
            CommonResponse projectRegisterVO = this.projectApi.queryProjectByIds(projectId);
            if (projectRegisterVO.getCode() == 0 && projectRegisterVO.getData() != null) {
                entity.setOrgId(((ProjectRegisterVO)((List)projectRegisterVO.getData()).get(0)).getProjectDepartmentId());
                CommonResponse orgVo = this.iOrgApi.detailById(entity.getOrgId());
                entity.setOrgCode(((OrgVO)orgVo.getData()).getCode());
                entity.setOrgName(((OrgVO)orgVo.getData()).getName());
                if (((OrgVO)orgVo.getData()).getParentId() != null) {
                    entity.setParentOrgId(((OrgVO)orgVo.getData()).getParentId());
                } else {
                    entity.setParentOrgId(entity.getOrgId());
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u9879\u76ee\u90e8\u4e3b\u952e");
            }
        }
        List detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeName(materialTypeNames);
        ArrayList<StartDetailEntity> detailDelList = new ArrayList<StartDetailEntity>();
        for (StartDetailEntity detailEntity : entity.getDetailList()) {
            if (!"del".equals(detailEntity.getRowState())) continue;
            detailDelList.add(detailEntity);
        }
        this.service.saveOrUpdate((Object)entity, false);
        entity.getDetailList().addAll(detailDelList);
        this.rmatFlowService.insertStartFlow(entity, BillTypeEnum.\u542f\u7528\u5355.getCode(), RmatCommonConsts.NO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)this.service.selectById(entity.getId()), StartVO.class));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StartVO> queryDetail(Long id) {
        StartEntity entity = (StartEntity)((Object)this.service.selectById(id));
        StartVO vo = (StartVO)BeanMapper.map((Object)((Object)entity), StartVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StartVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (!this.rmatFlowService.delFlow(ids, BillTypeEnum.\u542f\u7528\u5355.getCode()).booleanValue()) {
            return CommonResponse.error((String)"\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StartVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("materialTypeName");
        boolean mobile = param.getParams().containsKey("orgId");
        if (!mobile) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StartVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, StartVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("start-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStartData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StartVO>> refStartData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StartVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryParentOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgVO> queryParentOrg(Long orgId) {
        CommonResponse orgVO = this.iOrgApi.detailById(((OrgVO)this.iOrgApi.detailById(orgId).getData()).getParentId());
        return CommonResponse.success((Object)orgVO.getData());
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") String contractId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateContract(contractId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }
}

