/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.dataexchange.vo.LeaseInfoPriceRecordVO;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.ContInfoPriceRecordEntity;
import com.ejianc.business.rmat.bean.PriceFlowEntity;
import com.ejianc.business.rmat.mapper.ContInfoPriceRecordMapper;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.ContInfoPriceRecordVO;
import com.ejianc.business.rmat.vo.ReportCorpPcDetailVO;
import com.ejianc.business.rmat.vo.ReportCorpPcVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contInfoPriceRecordService")
public class ContInfoPriceRecordServiceImpl
extends BaseServiceImpl<ContInfoPriceRecordMapper, ContInfoPriceRecordEntity>
implements IContInfoPriceRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private ICalculateService calculateService;

    @Override
    public ContInfoPriceRecordVO queryDetail(Long id) {
        ContInfoPriceRecordEntity entity = (ContInfoPriceRecordEntity)((Object)this.selectById(id));
        ContInfoPriceRecordVO vo = (ContInfoPriceRecordVO)BeanMapper.map((Object)((Object)entity), ContInfoPriceRecordVO.class);
        return vo;
    }

    @Override
    public List<ContInfoPriceRecordVO> qryByContId(String pkContract, String pkContractInfo) {
        String key;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContInfoPriceRecordEntity::getPkContract, (Object)pkContract);
        queryWrapper.eq(ContInfoPriceRecordEntity::getPkLeaselist, (Object)pkContractInfo);
        queryWrapper.orderByAsc(ContInfoPriceRecordEntity::getDactivedate);
        List list = this.list((Wrapper)queryWrapper);
        HashSet<String> set = new HashSet<String>();
        ContInfoPriceRecordEntity priceRecordEntity = null;
        ContInfoPriceRecordEntity priceCheckRecordEntity = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ContInfoPriceRecordEntity recordEntity : list) {
                set.add(recordEntity.getPkContract() + "@" + format.format(recordEntity.getDactivedate()) + "@" + recordEntity.getNhireprice().stripTrailingZeros());
                if (!recordEntity.getCheckFlag().booleanValue()) continue;
                priceCheckRecordEntity = recordEntity;
            }
            priceRecordEntity = (ContInfoPriceRecordEntity)((Object)list.get(0));
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PriceFlowEntity::getFlowType, (Object)1);
        query.ne(PriceFlowEntity::getBillTypeCode, (Object)"BT230606000000001");
        query.eq(PriceFlowEntity::getInfoId, (Object)pkContractInfo);
        query.orderByAsc(PriceFlowEntity::getDetailDate);
        query.last("limit 1");
        PriceFlowEntity priceFlowEntity = (PriceFlowEntity)((Object)this.priceFlowService.getOne((Wrapper)query, false));
        ArrayList<ContInfoPriceRecordEntity> recordEntities = new ArrayList<ContInfoPriceRecordEntity>();
        CommonResponse response = this.cmContractInfoApi.queryLeasePriceById(pkContract, pkContractInfo);
        this.logger.error(JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            try {
                if (!(null == priceFlowEntity || null != priceRecordEntity && priceRecordEntity.getDactivedate().compareTo(priceFlowEntity.getDetailDate()) <= 0 || set.contains(key = pkContract + "@" + format.format(priceFlowEntity.getDetailDate()) + "@" + priceFlowEntity.getPrice().stripTrailingZeros()) || format.parse(((LeaseInfoPriceRecordVO)((List)response.getData()).get(0)).getDactivedate()).compareTo(priceFlowEntity.getDetailDate()) <= 0)) {
                    if (null != priceCheckRecordEntity) {
                        priceCheckRecordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                        priceCheckRecordEntity.setNhireprice(priceFlowEntity.getPrice());
                        priceCheckRecordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                        priceCheckRecordEntity.setTs(priceFlowEntity.getDetailDate());
                        recordEntities.add(priceCheckRecordEntity);
                    } else {
                        ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                        recordEntity.setPkContract(pkContract);
                        recordEntity.setPkLeaselist(pkContractInfo);
                        recordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                        recordEntity.setNhireprice(priceFlowEntity.getPrice());
                        recordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                        recordEntity.setTs(priceFlowEntity.getDetailDate());
                        recordEntity.setPeriodFlag(false);
                        recordEntity.setCheckFlag(true);
                        recordEntities.add(recordEntity);
                    }
                    set.add(key);
                }
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage());
            }
            for (LeaseInfoPriceRecordVO recordVO : (List)response.getData()) {
                String key2 = recordVO.getPkContract() + "@" + recordVO.getDactivedate() + "@" + recordVO.getNhireprice().stripTrailingZeros();
                if (set.contains(key2)) continue;
                ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                recordEntity.setPkContract(pkContract);
                recordEntity.setPkLeaselist(pkContractInfo);
                recordEntity.setNhireprice(recordVO.getNhireprice());
                recordEntity.setPeriodFlag(false);
                recordEntity.setCheckFlag(false);
                try {
                    recordEntity.setDmakedate(format.parse(recordVO.getDmakedate()));
                    recordEntity.setDactivedate(format.parse(recordVO.getDactivedate()));
                    recordEntity.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(recordVO.getTs()));
                }
                catch (ParseException e) {
                    this.logger.error(e.getMessage());
                }
                recordEntities.add(recordEntity);
            }
        } else if (!(null == priceFlowEntity || null != priceRecordEntity && priceRecordEntity.getDactivedate().compareTo(priceFlowEntity.getDetailDate()) <= 0 || set.contains(key = pkContract + "@" + format.format(priceFlowEntity.getDetailDate()) + "@" + priceFlowEntity.getPrice().stripTrailingZeros()))) {
            if (null != priceCheckRecordEntity) {
                priceCheckRecordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                priceCheckRecordEntity.setNhireprice(priceFlowEntity.getPrice());
                priceCheckRecordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                priceCheckRecordEntity.setTs(priceFlowEntity.getDetailDate());
                recordEntities.add(priceCheckRecordEntity);
            } else {
                ContInfoPriceRecordEntity recordEntity = new ContInfoPriceRecordEntity();
                recordEntity.setPkContract(pkContract);
                recordEntity.setPkLeaselist(pkContractInfo);
                recordEntity.setDmakedate(priceFlowEntity.getDetailDate());
                recordEntity.setNhireprice(priceFlowEntity.getPrice());
                recordEntity.setDactivedate(priceFlowEntity.getDetailDate());
                recordEntity.setTs(priceFlowEntity.getDetailDate());
                recordEntity.setPeriodFlag(false);
                recordEntity.setCheckFlag(true);
                recordEntities.add(recordEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(recordEntities)) {
            this.saveOrUpdateBatch(recordEntities);
        }
        recordEntities.addAll(list);
        List result = BeanMapper.mapList(recordEntities, ContInfoPriceRecordVO.class);
        Collections.sort(result, Comparator.comparing(ContInfoPriceRecordVO::getDactivedate));
        return result;
    }

    @Override
    public List<ReportCorpPcVO> queryRentList(QueryWrapper wrapper, List<Long> orgIds, List<Long> projectIds) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime sixMonthsAgo = now.minus(6L, ChronoUnit.MONTHS).withHour(0).withMinute(0).withSecond(0).withNano(0);
        Date compareDate = Date.from(sixMonthsAgo.atZone(ZoneId.systemDefault()).toInstant());
        ArrayList<ReportCorpPcVO> returnData = new ArrayList<ReportCorpPcVO>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(CalculateEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.in(CollectionUtils.isNotEmpty(orgIds), CalculateEntity::getRealCorpId, orgIds);
        queryWrapper.in(CollectionUtils.isNotEmpty(projectIds), CalculateEntity::getOrgId, projectIds);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.calculateService.list((Wrapper)queryWrapper);
        LinkedHashMap result = new LinkedHashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set contIdSet = list.stream().map(CalculateEntity::getContractId).collect(Collectors.toSet());
            LambdaQueryWrapper query = Wrappers.lambdaQuery();
            query.in(ContInfoPriceRecordEntity::getPkContract, new ArrayList(contIdSet));
            List recordEntities = this.list((Wrapper)query);
            Map<String, List<ContInfoPriceRecordEntity>> map = recordEntities.stream().collect(Collectors.groupingBy(ContInfoPriceRecordEntity::getPkContract));
            for (String pkCont : contIdSet) {
                List<ContInfoPriceRecordEntity> records;
                CommonResponse response = this.cmContractInfoApi.queryLeaseContractInfoById(pkCont);
                List infoVOS = (List)response.getData();
                if (!CollectionUtils.isNotEmpty((Collection)infoVOS) || !CollectionUtils.isNotEmpty(records = map.get(pkCont))) continue;
                Map<String, List<ContInfoPriceRecordEntity>> infoMap = records.stream().collect(Collectors.groupingBy(ContInfoPriceRecordEntity::getPkLeaselist));
                for (CmContractInfoVO infoVO : infoVOS) {
                    Map<Date, BigDecimal> resultMap;
                    if (null == infoVO.getMaterialTypeId()) continue;
                    String key = infoVO.getMaterialTypeId() + "@" + infoVO.getMaterialTypeName() + "@" + infoVO.getInfounit();
                    Map map2 = resultMap = result.containsKey(key) ? (Map)result.get(key) : new HashMap();
                    List<ContInfoPriceRecordEntity> entities = infoMap.get(infoVO.getPkContractinfo());
                    if (!CollectionUtils.isNotEmpty(entities)) continue;
                    for (ContInfoPriceRecordEntity recordEntity : entities) {
                        resultMap.put(recordEntity.getDactivedate(), recordEntity.getNhireprice());
                    }
                    result.put(key, resultMap);
                }
            }
            for (String key : result.keySet()) {
                Map decimalMap = (Map)result.get(key);
                ReportCorpPcVO pcVO = new ReportCorpPcVO();
                pcVO.setId(IdWorker.getId());
                String[] arr = key.split("@");
                pcVO.setMaterialTypeId(Long.valueOf(arr[0]));
                pcVO.setMaterialTypeName(arr[1]);
                pcVO.setRentUnitName(arr[2]);
                BigDecimal total = BigDecimal.ZERO;
                int num = 0;
                ArrayList<ReportCorpPcDetailVO> detailVOS = new ArrayList<ReportCorpPcDetailVO>();
                for (Date date : decimalMap.keySet()) {
                    if (compareDate.compareTo(date) > 0) continue;
                    ++num;
                    ReportCorpPcDetailVO detailVO = new ReportCorpPcDetailVO();
                    detailVO.setId(IdWorker.getId());
                    detailVO.setActiveDate(dateFormat.format(date));
                    detailVO.setActiveDateCom(date);
                    detailVO.setPrice((BigDecimal)decimalMap.get(date));
                    total = ComputeUtil.safeAdd((BigDecimal)total, (BigDecimal)detailVO.getPrice());
                    detailVOS.add(detailVO);
                }
                pcVO.setDamagePrice(ComputeUtil.safeDiv((BigDecimal)total, (BigDecimal)BigDecimal.valueOf(num)));
                if (!CollectionUtils.isNotEmpty(detailVOS)) continue;
                detailVOS.sort(Comparator.comparing(ReportCorpPcDetailVO::getActiveDateCom));
                pcVO.setLinkList(detailVOS);
                returnData.add(pcVO);
            }
        }
        return returnData;
    }
}

