/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.CommonSupportService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="restitute")
public class RestituteBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRestituteService service;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IRmatFlowService flowService;
    @Autowired
    private CommonSupportService commonSupportService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity restituteEntity = (RestituteEntity)((Object)this.service.selectById(billId));
        if (2 == restituteEntity.getConfirmFlag()) {
            restituteEntity.setConfirmFlag(0);
        }
        restituteEntity.setCommitId(InvocationInfoProxy.getUserid().toString());
        this.service.saveOrUpdate((Object)restituteEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity entity = (RestituteEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(entity.getRestituteDetailList()) && !this.flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.commonSupportService.getAccessToken(headers);
        if (!tokenres.isSuccess()) return tokenres;
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
        this.logger.info("\u8d54\u507f\u5355\u63a8\u9001\u4f9b\u65b9JSON------" + JSONObject.toJSONString((Object)BeanMapper.map((Object)((Object)entity), RestituteVO.class)));
        CommonResponse<String> pushres = this.service.pushConfirmEntity(headers, entity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        if (!pushres.isSuccess()) return pushres;
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
            if (2 == entity.getConfirmFlag()) {
                entity.setConfirmFlag(0);
            }
            entity.setCommitId(InvocationInfoProxy.getUserid().toString());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity entity = (RestituteEntity)((Object)this.service.selectById(billId));
        this.materialService.validateContract(entity.getContractId(), "BT221025000000001", billId, "\u5f03\u5ba1");
        this.service.validateTime((RestituteVO)BeanMapper.map((Object)((Object)entity), RestituteVO.class), "\u5f03\u5ba1");
        if (entity.getConfirmFlag() == 1) {
            return CommonResponse.error((String)"\u8d54\u507f\u5355\u4f9b\u65b9\u5df2\u786e\u8ba4\u4e0d\u652f\u6301\u64a4\u56de!");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RestituteEntity entity = (RestituteEntity)((Object)this.service.selectById(billId));
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.commonSupportService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.service.pushDelete(headers, entity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                return pushres;
            }
        } else {
            return tokenres;
        }
        if (CollectionUtils.isNotEmpty(entity.getRestituteDetailList()) && !this.flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u540e\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1\u540e\u56de\u8c03\u6210\u529f\uff01");
    }
}

