/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.IStartService;
import com.ejianc.business.rmat.service.IStopService;
import com.ejianc.business.rmat.vo.StopVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stop")
public class StopBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IStopService service;
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStartService startService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StopEntity entity = (StopEntity)((Object)this.service.selectById(billId));
        if (!this.rmatFlowService.insertStopFlow(entity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (!this.priceFlowService.insertStopFlow(entity, billTypeCode).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        StopEntity entity = (StopEntity)((Object)this.service.selectById(billId));
        this.service.validateTime((StopVO)BeanMapper.map((Object)((Object)entity), StopVO.class), "\u5f03\u5ba1");
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(StartEntity::getProjectId, (Object)entity.getProjectId());
        query.eq(StartEntity::getContractId, (Object)entity.getContractId());
        query.orderByDesc(StartEntity::getStartTime);
        query.last("limit 1");
        StartEntity startEntity = (StartEntity)((Object)this.startService.getOne((Wrapper)query, false));
        if (null != startEntity && entity.getStopTime().compareTo(startEntity.getStartTime()) <= 0) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u505c\u79df\u542f\u79df\u5355\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        StopEntity entity = (StopEntity)((Object)this.service.selectById(billId));
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        if (!this.priceFlowService.delFlow(ids, billTypeCode).booleanValue()) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        this.logger.info("\u5220\u9664\u5355\u4ef7\u6d41\u6c34\u6210\u529f--" + billId + billTypeCode);
        if (!this.rmatFlowService.insertStopFlow(entity, billTypeCode, RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }
}

