package com.ejianc.business.rmat.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.rmat.service.IContInfoPriceRecordService;
import com.ejianc.business.rmat.service.IDailyService;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.service.IRestituteScrapService;
import com.ejianc.business.rmat.vo.ReportCorpNewVO;
import com.ejianc.business.rmat.vo.ReportCorpPcVO;
import com.ejianc.business.rmat.vo.ReportCorpTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 公司租金分析
 *
 * @author generator
 */
@Controller
@RequestMapping("reportCorp")
public class ReportCorpController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IReportDailyService service;

    @Autowired
    private IRestituteScrapService restituteScrapService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContInfoPriceRecordService contInfoPriceRecordService;

    @Autowired
    private IDailyService dailyService;

    @Autowired
    private IProjectApi projectApi;

    /**
     * @param orgId
     * @Description qryTopInfo
     */
    @RequestMapping(value = "/qryTopInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportCorpTopVO> qryTopInfo(@RequestParam(value = "orgId", required = false) Long orgId, @RequestParam(value = "beginDate", required = false) String beginDate, @RequestParam(value = "endDate", required = false) String endDate) {
        return CommonResponse.success("查询数据成功！", service.qryTopInfo(orgId, getHourMinBeginDate(beginDate), getHourMinEndDate(endDate)));
    }

    private String getHourMinBeginDate(String beginDate) {
        String result = null;
        if (StringUtils.isNotBlank(beginDate)) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = ft.parse(beginDate);
                DateTime dateTime = DateUtil.beginOfDay(date);
                result = dateTime.toString(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            result = "1990-01-01 00:00:00";
        }
        return result;
    }

    private String getHourMinEndDate(String endDate) {
        String result = null;
        if (StringUtils.isNotBlank(endDate)) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = ft.parse(endDate);
                DateTime dateTime = DateUtil.endOfDay(date);
                result = dateTime.toString(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            result = DateUtil.endOfDay(new Date()).toString(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        return result;
    }

    /**
     * @param orgId
     * @Description qryDailyRise 查询日租金涨幅情况
     */
    @RequestMapping(value = "/qryDailyRise", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> qryDailyRise(@RequestParam(value = "orgId", required = false) Long orgId, @RequestParam(value = "beginDate", required = false) String beginDate, @RequestParam(value = "endDate", required = false) String endDate) {
        return CommonResponse.success("查询数据成功！", service.qryDailyRise(orgId, getHourMinBeginDate(beginDate), getHourMinEndDate(endDate)));
    }

    /**
     * @param orgId
     * @Description qryRentMnyDistribution 查询累计租金分布
     */
    @RequestMapping(value = "/qryRentMnyDistribution", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> qryRentMnyDistribution(@RequestParam(value = "orgId", required = false) Long orgId, @RequestParam(value = "beginDate", required = false) String beginDate, @RequestParam(value = "endDate", required = false) String endDate) {
        return CommonResponse.success("查询数据成功！", service.qryRentMnyDistribution(orgId, getHourMinBeginDate(beginDate), getHourMinEndDate(endDate)));
    }

    /**
     * @param param
     * @Description queryPcList 赔偿单价列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> queryPcList(@RequestBody QueryParam param) {
        Parameter beginDateParam = param.getParams().get("beginDate");
        Parameter endDateParam = param.getParams().get("endDate");
        Parameter orgIdParam = param.getParams().get("orgId");
        String beginDate = getHourMinBeginDate(null != beginDateParam ? (String) beginDateParam.getValue() : null);
        param.getParams().remove("beginDate");
        String endDate = getHourMinEndDate(null != endDateParam ? (String) endDateParam.getValue() : null);
        param.getParams().remove("endDate");
        IPage<ReportCorpPcVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
        Long orgId = null;
        if(null != orgIdParam){
            orgId = Long.valueOf((String) orgIdParam.getValue());
            param.getParams().remove("orgId");
        }else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData();
        List<Long> orgIds = new ArrayList<>();
        List<Long> projectIds = new ArrayList<>();
        if (CollectionUtils.isEmpty(orgVOS)) {
            projectIds.add(orgId);
        } else {
            orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportCorpPcVO> list = restituteScrapService.queryPcList(pageData, wrapper, orgIds, projectIds, beginDate, endDate);
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReportCorpPcVO pcVO : list) {
                pcVO.setId(IdWorker.getId());
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryPcList 赔偿单价列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/linkPcList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> linkPcList(@RequestBody QueryParam param) {
        Parameter beginDateParam = param.getParams().get("beginDate");
        Parameter endDateParam = param.getParams().get("endDate");
        Parameter orgIdParam = param.getParams().get("orgId");
        String beginDate = getHourMinBeginDate(null != beginDateParam ? (String) beginDateParam.getValue() : null);
        param.getParams().remove("beginDate");
        String endDate = getHourMinEndDate(null != endDateParam ? (String) endDateParam.getValue() : null);
        param.getParams().remove("endDate");
        IPage<ReportCorpPcVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
        Long orgId = null;
        if(null != orgIdParam){
            orgId = Long.valueOf((String) orgIdParam.getValue());
            param.getParams().remove("orgId");
        }else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData();
        Object secondFlagObj = param.getParams().get("secondFlag").getValue();
        List<Long> orgIds = new ArrayList<>();
        Map<Long, String> map = new HashMap<>();
        boolean secondFlag = true;
        if (null != secondFlagObj && 1 == (Integer) secondFlagObj) {
            orgIds.add(InvocationInfoProxy.getOrgId());
        } else {
            orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
            map = orgVOS.stream().collect(Collectors.toMap(OrgVO::getId, OrgVO::getName, (k1, k2) -> k1));
            secondFlag = false;
        }
        param.getParams().remove("secondFlag");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReportCorpPcVO> list = restituteScrapService.linkPcList(pageData, wrapper, orgIds, secondFlag, beginDate, endDate);
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReportCorpPcVO pcVO : list) {
                pcVO.setId(IdWorker.getId());
                if (!secondFlag) {
                    pcVO.setOrgName(map.get(pcVO.getOrgId()));
                }
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryPcList 赔偿单价列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryRentList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpPcVO>> queryRentList(@RequestBody QueryParam param) {
        Parameter beginDateParam = param.getParams().get("beginDate");
        Parameter endDateParam = param.getParams().get("endDate");
        Parameter orgIdParam = param.getParams().get("orgId");
        String beginDate = getHourMinBeginDate(null != beginDateParam ? (String) beginDateParam.getValue() : null);
        param.getParams().remove("beginDate");
        String endDate = getHourMinEndDate(null != endDateParam ? (String) endDateParam.getValue() : null);
        param.getParams().remove("endDate");

        Parameter materialTypeNameObj = param.getParams().get("materialTypeName");
        String materialTypeName = null;
        if (null != materialTypeNameObj) {
            materialTypeName = (String) materialTypeNameObj.getValue();
            param.getParams().remove("materialTypeName");
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        if(null != orgIdParam){
            orgId = Long.valueOf((String) orgIdParam.getValue());
            param.getParams().remove("orgId");
        }else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData();
        List<Long> orgIds = new ArrayList<>();
        List<Long> projectIds = new ArrayList<>();
        if (CollectionUtils.isEmpty(orgVOS)) {
            projectIds.add(orgId);
        } else {
            orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        List<ReportCorpPcVO> list = contInfoPriceRecordService.queryRentList(materialTypeName, orgIds, projectIds, beginDate, endDate);
        IPage<ReportCorpPcVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        pageData.setRecords(param.getPageSize() > 0 ? paginate(list, param.getPageIndex(), param.getPageSize()) : list);
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryNewList 新列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/qryNewList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReportCorpNewVO>> qryNewList(@RequestBody QueryParam param) {
        Parameter beginDateParam = param.getParams().get("beginDate");
        Parameter endDateParam = param.getParams().get("endDate");
        Parameter orgIdParam = param.getParams().get("orgId");
        String beginDate = getHourMinBeginDate(null != beginDateParam ? (String) beginDateParam.getValue() : null);
        param.getParams().remove("beginDate");
        String endDate = getHourMinEndDate(null != endDateParam ? (String) endDateParam.getValue() : null);
        param.getParams().remove("endDate");


        Long orgId = null;
        if(null != orgIdParam){
            orgId = Long.valueOf((String) orgIdParam.getValue());
            param.getParams().remove("orgId");
        }else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData();
        List<Long> orgIds = new ArrayList<>();
        Long projectId = null;
        List<ReportCorpNewVO> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(orgVOS)) {
            projectId = projectApi.queryProjectBySourceId(orgApi.getOneById(orgId).getData().getSourceId()).getData().getId();
            list = dailyService.qryNewList(orgIds, projectId, beginDate, endDate);
        } else {
            orgIds = orgVOS.stream().map(OrgVO::getId).collect(Collectors.toList());
            list = dailyService.qryNewCorpList(orgIds, beginDate, endDate);
        }
        List<ReportCorpNewVO> paginate = new ArrayList<>();
        int total = list.size();  // 获取总记录数
        if (param.getPageSize() > 0) {

            // 计算起始索引和结束索引
            int fromIndex = (param.getPageIndex() - 1) * param.getPageSize();
            int toIndex = Math.min(fromIndex + param.getPageSize(), total);

            // 防止索引越界
            if (fromIndex <= total && fromIndex >= 0) {
                paginate = list.subList(fromIndex, toIndex);
            }
        }else {
            paginate = list;
        }


        IPage<ReportCorpNewVO> page = new Page<>(param.getPageIndex(), param.getPageSize(), total);
        page.setRecords(paginate);
        return CommonResponse.success("查询数据成功！", page);
    }

    /**
     * 手动分页
     *
     * @param list      要分页的原始列表
     * @param pageIndex 当前页的索引（从1开始）
     * @param pageSize  每页的大小
     * @return 截取后的分页列表
     */
    public List<ReportCorpPcVO> paginate(List<ReportCorpPcVO> list, int pageIndex, int pageSize) {
        int total = list.size();  // 获取总记录数

        // 计算起始索引和结束索引
        int fromIndex = (pageIndex - 1) * pageSize;
        int toIndex = Math.min(fromIndex + pageSize, total);

        // 防止索引越界
        if (fromIndex > total || fromIndex < 0) {
            return new ArrayList<>(); // 返回空列表
        }

        return list.subList(fromIndex, toIndex);
    }

    /**
     * @param orgId
     * @Description qryMonthRise 查询月租金涨幅情况
     */
    @RequestMapping(value = "/qryMonthRise", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> qryMonthRise(@RequestParam(value = "orgId", required = false) Long orgId, @RequestParam(value = "beginDate", required = false) String beginDate, @RequestParam(value = "endDate", required = false) String endDate) {
        return CommonResponse.success("查询数据成功！", service.qryMonthRise(orgId, getHourMinBeginDate(beginDate), getHourMinEndDate(endDate)));
    }
}
