package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.ReportDailyMapper;
import com.ejianc.business.rmat.service.*;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.ReportCorpLowerVO;
import com.ejianc.business.rmat.vo.ReportCorpTopVO;
import com.ejianc.business.rmat.vo.ReportDailyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 日租金报表
 *
 * @author generator
 */
@Service("reportDailyService")
public class ReportDailyServiceImpl extends BaseServiceImpl<ReportDailyMapper, ReportDailyEntity> implements IReportDailyService {

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDailyService dailyService;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private ICalculateDailyService calculateDailyService;

    private static final String REPORT_RMAT_DAILY = "REPORT_RMAT_DAILY";

    @Override
    public ReportDailyVO saveOrUpdate(ReportDailyVO reportDailyVO) {
        ReportDailyEntity entity = BeanMapper.map(reportDailyVO, ReportDailyEntity.class);
        if (StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReportDailyVO.class);
    }

    @Override
    public void makeReportDailyData(List<DailyEntity> dailyList) {
        List<ReportDailyEntity> reportList = list();
        Map<Long, ReportDailyEntity> reportMap = reportList.stream().collect(Collectors.toMap(ReportDailyEntity::getProjectId, Function.identity(), (key1, key2) -> key1));
        List<ReportDailyVO> caclMny = baseMapper.getCaclMny();
        List<ReportDailyVO> restitueMny = baseMapper.getRestitueMny();
        List<ReportDailyVO> repairMny = baseMapper.getRepairMny();
        List<ReportDailyVO> pcOtherMny = baseMapper.getPcOtherMny();
        List<ReportDailyVO> calcOtherMny = baseMapper.getCalcOtherMny();

        Map<Long, ReportDailyVO> newReportMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (DailyEntity dailyEntity : dailyList) {
                ReportDailyVO reportVO = new ReportDailyVO();
                reportVO.setProjectId(dailyEntity.getProjectId());
                newReportMap.put(dailyEntity.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(caclMny)) {
            for (ReportDailyVO reportDailyVO : caclMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRentTaxMny(ComputeUtil.safeAdd(reportVO.getSumRentTaxMny(), reportDailyVO.getSumRentTaxMny()));
                reportVO.setSumRentMny(ComputeUtil.safeAdd(reportVO.getSumRentMny(), reportDailyVO.getSumRentMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(restitueMny)) {
            for (ReportDailyVO reportDailyVO : restitueMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumScrapTaxMny(ComputeUtil.safeAdd(reportVO.getSumScrapTaxMny(), reportDailyVO.getSumScrapTaxMny()));
                reportVO.setSumScrapMny(ComputeUtil.safeAdd(reportVO.getSumScrapMny(), reportDailyVO.getSumScrapMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(repairMny)) {
            for (ReportDailyVO reportDailyVO : repairMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRepairTaxMny(ComputeUtil.safeAdd(reportVO.getSumRepairTaxMny(), reportDailyVO.getSumRepairTaxMny()));
                reportVO.setSumRepairMny(ComputeUtil.safeAdd(reportVO.getSumRepairMny(), reportDailyVO.getSumRepairMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(pcOtherMny)) {
            for (ReportDailyVO reportDailyVO : pcOtherMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd(reportVO.getSumOtherTaxMny(), reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd(reportVO.getSumOtherMny(), reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(calcOtherMny)) {
            for (ReportDailyVO reportDailyVO : calcOtherMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd(reportVO.getSumOtherTaxMny(), reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd(reportVO.getSumOtherMny(), reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        List<ReportDailyEntity> reportSaveList = new ArrayList<>();
        for (Long key : newReportMap.keySet()) {
            ReportDailyVO reportDailyVO = newReportMap.get(key);
            ReportDailyEntity reportDailyEntity = null;
            if (reportMap.containsKey(key)) {
                reportDailyEntity = reportMap.get(key);
            } else {
                reportDailyEntity = new ReportDailyEntity();
                reportDailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                reportDailyEntity.setProjectId(reportDailyVO.getProjectId());
                if (StringUtils.isEmpty(reportDailyEntity.getBillCode())) {
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        reportDailyEntity.setBillCode(billCode.getData());
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
                CommonResponse<List<ProjectRegisterVO>> commonResponse = projectApi.queryProjectByIds(Arrays.asList(new Long[]{reportDailyVO.getProjectId()}));
                if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                    ProjectRegisterVO projectRegisterVO = commonResponse.getData().get(0);
                    reportDailyEntity.setProjectCode(projectRegisterVO.getCode());
                    reportDailyEntity.setProjectName(projectRegisterVO.getName());
                    reportDailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                    reportDailyEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                    reportDailyEntity.setOrgName(projectRegisterVO.getName());
                    reportDailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                    reportDailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                    reportDailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());

                    CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getOrgId());
                    if (response.isSuccess() && response.getData() != null) {
                        OrgVO orgVO = response.getData();
                        reportDailyEntity.setParentOrgId(orgVO.getId());
                        reportDailyEntity.setParentOrgCode(orgVO.getCode());
                        reportDailyEntity.setParentOrgName(orgVO.getName());
                    }
                }
            }
            reportDailyEntity.setSumRentTaxMny(reportDailyVO.getSumRentTaxMny());
            reportDailyEntity.setSumRentMny(reportDailyVO.getSumRentMny());
            reportDailyEntity.setSumScrapTaxMny(reportDailyVO.getSumScrapTaxMny());
            reportDailyEntity.setSumScrapMny(reportDailyVO.getSumScrapMny());
            reportDailyEntity.setSumRepairTaxMny(reportDailyVO.getSumRepairTaxMny());
            reportDailyEntity.setSumRepairMny(reportDailyVO.getSumRepairMny());
            reportDailyEntity.setSumOtherTaxMny(reportDailyVO.getSumOtherTaxMny());
            reportDailyEntity.setSumOtherMny(reportDailyVO.getSumOtherMny());
            reportSaveList.add(reportDailyEntity);
        }
        if (CollectionUtils.isNotEmpty(reportSaveList)) {
            saveOrUpdateBatch(reportSaveList, reportSaveList.size());
        }
    }

    static final Map<String, String> nameMap = ImmutableMap.<String, String>builder()
            .put("中国建筑五局河南公司豫陕分公司", "陕西@6")
            .put("中国建筑五局河南公司豫冀分公司", "华北@8")
            .put("中国建筑五局河南公司山西分公司", "山西@5")
            .put("中建五局河南公司（四公司）直属经理部", "直属@9")
            .put("中国建筑五局河南公司湖北分公司", "华中@7")
            .put("中国建筑五局河南公司豫东分公司", "豫东@2")
            .put("中国建筑五局河南公司豫西分公司", "豫西@3")
            .put("中国建筑五局河南公司豫南分公司", "豫南@4")
            .put("中国建筑五局河南公司郑州分公司", "郑州@1")
            .put("中建潇湘（匈牙利）有限公司-管理", "中建潇湘@10")
            .build();


    @Override
    public ReportCorpTopVO qryTopInfo(Long orgId, String beginDate, String endDate) {
        OrgVO currOrgVO = orgApi.getOneById(orgId).getData();
        boolean projFlag = "5".equals(String.valueOf(currOrgVO.getOrgType()));

        ReportCorpTopVO topVO = new ReportCorpTopVO();
        topVO.setId(IdWorker.getId());
        topVO.setScaleZb(BigDecimal.valueOf(47));
        topVO.setOrgName(currOrgVO.getName());
        List<OrgVO> orgVOS = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData();
        Map<Long, ReportCorpLowerVO> detailMap = new HashMap<>();
        Map<Long, String> innerCodeMap = new HashMap<>();
        List<Long> orgIdList = new ArrayList<>();
        Set<Long> departmentIdSet = new HashSet<>();
        //当前组织是项目部
        if (projFlag) {

            ReportCorpLowerVO lowerVO = new ReportCorpLowerVO();
            lowerVO.setId(IdWorker.getId());
            lowerVO.setTopId(topVO.getId());
            lowerVO.setOrgName(currOrgVO.getName());
            lowerVO.setOrgId(currOrgVO.getId());
            lowerVO.setOrgCode(currOrgVO.getCode());
            lowerVO.setOrgType(currOrgVO.getOrgType());
            lowerVO.setOrgShortName(nameMap.containsKey(lowerVO.getOrgName()) ? nameMap.get(lowerVO.getOrgName()) : lowerVO.getOrgName());
            lowerVO.setScaleZb(BigDecimal.valueOf(new Random().nextInt(11) + 40));
            detailMap.put(currOrgVO.getId(), lowerVO);
            orgIdList.add(currOrgVO.getId());
            departmentIdSet.add(currOrgVO.getId());
            innerCodeMap.put(currOrgVO.getId(), currOrgVO.getInnerCode());
        } else if (orgVOS.size() == 1) { //当前组织是分公司
            projFlag = true;
            CommonResponse<List<ProjectRegisterVO>> response = projectApi.queryProjectByNcCorpId(orgId);
            if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                CommonResponse<List<OrgVO>> orgResponse = orgApi.findAllByIds(response.getData().stream().map(ProjectRegisterVO::getProjectDepartmentId).collect(Collectors.toList()));
                for (OrgVO orgVO : orgResponse.getData()) {
                    ReportCorpLowerVO lowerVO = new ReportCorpLowerVO();
                    lowerVO.setId(IdWorker.getId());
                    lowerVO.setTopId(topVO.getId());
                    lowerVO.setOrgName(orgVO.getName());
                    lowerVO.setOrgId(orgVO.getId());
                    lowerVO.setOrgCode(orgVO.getCode());
                    lowerVO.setOrgShortName(nameMap.containsKey(lowerVO.getOrgName()) ? nameMap.get(lowerVO.getOrgName()) : lowerVO.getOrgName());
                    lowerVO.setSequence(0);
                    lowerVO.setOrgType(orgVO.getOrgType());
                    lowerVO.setScaleZb(BigDecimal.valueOf(new Random().nextInt(11) + 40));
                    detailMap.put(orgVO.getId(), lowerVO);
                    orgIdList.add(orgVO.getId());
                    departmentIdSet.add(orgVO.getId());
                    innerCodeMap.put(orgVO.getId(), orgVO.getInnerCode());
                }
            }
        } else {
            for (OrgVO orgVO : orgVOS) {
                if (null != orgVO.getParentId() && orgVO.getParentId().equals(orgId) && !"1328246326575501314".equals(String.valueOf(orgVO.getId())) && !"1328246326474838018".equals(String.valueOf(orgVO.getId())) && !"1798394378744545282".equals(String.valueOf(orgVO.getId()))) {
                    ReportCorpLowerVO lowerVO = new ReportCorpLowerVO();
                    lowerVO.setId(IdWorker.getId());
                    lowerVO.setTopId(topVO.getId());
                    lowerVO.setOrgName(orgVO.getName());
                    lowerVO.setOrgId(orgVO.getId());
                    lowerVO.setOrgCode(orgVO.getCode());
                    lowerVO.setOrgType(orgVO.getOrgType());
                    lowerVO.setOrgShortName(nameMap.containsKey(lowerVO.getOrgName()) ? nameMap.get(lowerVO.getOrgName()).split("@")[0] : lowerVO.getOrgName());
                    lowerVO.setSequence(nameMap.containsKey(lowerVO.getOrgName()) ? Integer.valueOf(nameMap.get(lowerVO.getOrgName()).split("@")[1]) : 0);
                    lowerVO.setScaleZb(BigDecimal.valueOf(new Random().nextInt(11) + 40));
                    detailMap.put(orgVO.getId(), lowerVO);
                }
                orgIdList.add(orgVO.getId());
                innerCodeMap.put(orgVO.getId(), orgVO.getInnerCode());
            }
        }

        LambdaQueryWrapper<DailyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DailyEntity::getRentDate, new SimpleDateFormat("yyyy-MM-dd").format(DateUtil.daySubOne(new Date())));
        queryWrapper.in(DailyEntity::getBillState, "1,3");
        queryWrapper.in(!projFlag, DailyEntity::getRealCorpId, orgIdList);
        queryWrapper.in(projFlag, DailyEntity::getOrgId, orgIdList);
        List<DailyEntity> dailyEntities = dailyService.list(queryWrapper);
        for (DailyEntity dailyEntity : dailyEntities) {
            for (Long key : detailMap.keySet()) {
                if (projFlag && dailyEntity.getOrgId().equals(key) || (innerCodeMap.containsKey(dailyEntity.getRealCorpId()) && innerCodeMap.get(dailyEntity.getRealCorpId()).contains(String.valueOf(key)))) {
                    ReportCorpLowerVO lowerVO = detailMap.get(key);
                    lowerVO.setDailyMny(ComputeUtil.safeAdd(lowerVO.getDailyMny(), dailyEntity.getRentMny()));
                }
            }
        }

        LambdaQueryWrapper<CalculateEntity> query = new LambdaQueryWrapper<>();
        query.ge(StringUtils.isNotBlank(beginDate), CalculateEntity::getRentDate, beginDate);
        query.le(StringUtils.isNotBlank(endDate), CalculateEntity::getRentDate, endDate);
        query.in(CalculateEntity::getBillState, "1,3");
        query.in(!projFlag, CalculateEntity::getRealCorpId, orgIdList);
        query.in(projFlag, CalculateEntity::getOrgId, orgIdList);
        List<CalculateEntity> calcList = calculateService.list(query);
        LocalDate now = StringUtils.isNotBlank(endDate) ? LocalDate.parse(endDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : LocalDate.now();
        Date beginDateA = Date.from(now.with(TemporalAdjusters.firstDayOfYear()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date endDateA = Date.from(now.with(TemporalAdjusters.lastDayOfYear()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        for (CalculateEntity calcEntity : calcList) {
            for (Long key : detailMap.keySet()) {
                if (projFlag && calcEntity.getOrgId().equals(key) || (innerCodeMap.containsKey(calcEntity.getRealCorpId()) && innerCodeMap.get(calcEntity.getRealCorpId()).contains(String.valueOf(key)))) {
                    ReportCorpLowerVO lowerVO = detailMap.get(key);
                    if (calcEntity.getRentDate().after(beginDateA) && calcEntity.getRentDate().before(endDateA)) {
                        lowerVO.setYearMny(ComputeUtil.safeAdd(lowerVO.getYearMny(), calcEntity.getRentMny()));
                    }
                    lowerVO.setSumMny(ComputeUtil.safeAdd(lowerVO.getSumMny(), calcEntity.getRentMny()));
                }
            }
        }

        if (departmentIdSet.isEmpty() && !projFlag) {
            CommonResponse<List<OrgVO>> orgResponse = orgApi.findChildrenByParentIds(orgIdList);
            for (OrgVO orgVO : orgResponse.getData()) {
                if (orgVO.getInnerCode().contains(String.valueOf(orgId)) && orgVO.getOrgType().equals(Integer.valueOf(5))) {
                    departmentIdSet.add(orgVO.getId());
                    innerCodeMap.put(orgVO.getId(), orgVO.getInnerCode());
                }
            }
        }

        List<Long> departmentIdList = new ArrayList<>(departmentIdSet);

        //查询架管的子分类，写死主键
        CommonResponse<List<MaterialCategoryVO>> pipeResponse = materialApi.queryCategoryListByPid(Long.valueOf("1328902423640543234"));
        List<Long> pipeCtyList = pipeResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<RmatFlowEntity> flowQuery = new LambdaQueryWrapper<>();
        flowQuery.eq(RmatFlowEntity::getEffectiveState, RmatCommonConsts.YES);
        flowQuery.ge(StringUtils.isNotBlank(beginDate), RmatFlowEntity::getDetailDate, beginDate);
        flowQuery.le(StringUtils.isNotBlank(endDate), RmatFlowEntity::getDetailDate, endDate);
        flowQuery.in(RmatFlowEntity::getMaterialTypeId, pipeCtyList);
        flowQuery.in(RmatFlowEntity::getOrgId, departmentIdList);
        List<RmatFlowEntity> pipeFlowList = rmatFlowService.list(flowQuery);
        for (RmatFlowEntity flowEntity : pipeFlowList) {
            for (Long key : detailMap.keySet()) {
                if (projFlag && flowEntity.getOrgId().equals(key) || (innerCodeMap.containsKey(flowEntity.getRealCorpId()) && innerCodeMap.get(flowEntity.getRealCorpId()).contains(String.valueOf(key)))) {
                    ReportCorpLowerVO lowerVO = detailMap.get(key);
                    if (FlowTypeEnum.验收.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                        lowerVO.setSumPipeInNum(ComputeUtil.safeAdd(lowerVO.getSumPipeInNum(), flowEntity.getRealNum()));
                    }
                    if (FlowTypeEnum.退场.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType())) || FlowTypeEnum.赔偿.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                        lowerVO.setSumPipeOutNum(ComputeUtil.safeAdd(lowerVO.getSumPipeOutNum(), flowEntity.getRealNum()));
                        if (FlowTypeEnum.赔偿.getFlowType().equals(Integer.valueOf(Integer.valueOf(flowEntity.getFlowType())))) {
                            lowerVO.setSumPipePcNum(ComputeUtil.safeAdd(lowerVO.getSumPipePcNum(), flowEntity.getRealNum()));
                        }
                    }
                }
            }
        }

        //查询扣件的子分类，写死主键
        CommonResponse<List<MaterialCategoryVO>> clampResponse = materialApi.queryCategoryListByPid(Long.valueOf("1328902425322459138"));
        List<Long> clampCtyList = clampResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        flowQuery = new LambdaQueryWrapper<>();
        flowQuery.eq(RmatFlowEntity::getEffectiveState, RmatCommonConsts.YES);
        flowQuery.ge(StringUtils.isNotBlank(beginDate), RmatFlowEntity::getDetailDate, beginDate);
        flowQuery.le(StringUtils.isNotBlank(endDate), RmatFlowEntity::getDetailDate, endDate);
        flowQuery.in(RmatFlowEntity::getMaterialTypeId, clampCtyList);
        flowQuery.in(RmatFlowEntity::getOrgId, departmentIdList);
        List<RmatFlowEntity> clampFlowList = rmatFlowService.list(flowQuery);
        for (RmatFlowEntity flowEntity : clampFlowList) {
            for (Long key : detailMap.keySet()) {
                if (projFlag && flowEntity.getOrgId().equals(key) || (innerCodeMap.containsKey(flowEntity.getRealCorpId()) && innerCodeMap.get(flowEntity.getRealCorpId()).contains(String.valueOf(key)))) {
                    ReportCorpLowerVO lowerVO = detailMap.get(key);
                    if (FlowTypeEnum.验收.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                        lowerVO.setSumClampInNum(ComputeUtil.safeAdd(lowerVO.getSumClampInNum(), flowEntity.getRealNum()));
                    }
                    if (FlowTypeEnum.退场.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType())) || FlowTypeEnum.赔偿.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                        lowerVO.setSumClampOutNum(ComputeUtil.safeAdd(lowerVO.getSumClampOutNum(), flowEntity.getRealNum()));
                        if (FlowTypeEnum.赔偿.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                            lowerVO.setSumClampPcNum(ComputeUtil.safeAdd(lowerVO.getSumClampPcNum(), flowEntity.getRealNum()));
                        }
                    }
                }
            }
        }

        //查询轮扣的子分类，写死主键
        CommonResponse<List<MaterialCategoryVO>> koujResponse = materialApi.queryCategoryListByPid(Long.valueOf("1328902426949849089"));
        List<Long> koujCtyList = koujResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
        flowQuery = new LambdaQueryWrapper<>();
        flowQuery.eq(RmatFlowEntity::getEffectiveState, RmatCommonConsts.YES);
        flowQuery.ge(StringUtils.isNotBlank(beginDate), RmatFlowEntity::getDetailDate, beginDate);
        flowQuery.le(StringUtils.isNotBlank(endDate), RmatFlowEntity::getDetailDate, endDate);
        flowQuery.in(RmatFlowEntity::getMaterialTypeId, koujCtyList);
        flowQuery.in(RmatFlowEntity::getOrgId, departmentIdList);
        List<RmatFlowEntity> koujFlowList = rmatFlowService.list(flowQuery);
        for (RmatFlowEntity flowEntity : koujFlowList) {
            for (Long key : detailMap.keySet()) {
                if (projFlag && flowEntity.getOrgId().equals(key) || (innerCodeMap.containsKey(flowEntity.getRealCorpId()) && innerCodeMap.get(flowEntity.getRealCorpId()).contains(String.valueOf(key)))) {
                    ReportCorpLowerVO lowerVO = detailMap.get(key);
                    if (FlowTypeEnum.验收.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                        lowerVO.setSumLunkInNum(ComputeUtil.safeAdd(lowerVO.getSumLunkInNum(), flowEntity.getRealNum()));
                    }
                    if (FlowTypeEnum.退场.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType())) || FlowTypeEnum.赔偿.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                        lowerVO.setSumLunkOutNum(ComputeUtil.safeAdd(lowerVO.getSumLunkOutNum(), flowEntity.getRealNum()));
                        if (FlowTypeEnum.赔偿.getFlowType().equals(Integer.valueOf(flowEntity.getFlowType()))) {
                            lowerVO.setSumLunkPcNum(ComputeUtil.safeAdd(lowerVO.getSumLunkPcNum(), flowEntity.getRealNum()));
                        }
                    }
                }
            }
        }
        for (ReportCorpLowerVO lowerVO : detailMap.values()) {
            lowerVO.setDailyMny(ComputeUtil.safeDiv(lowerVO.getDailyMny(), BigDecimal.valueOf(10000)));
            lowerVO.setYearMny(ComputeUtil.safeDiv(lowerVO.getYearMny(), BigDecimal.valueOf(10000)));
            lowerVO.setSumMny(ComputeUtil.safeDiv(lowerVO.getSumMny(), BigDecimal.valueOf(10000)));
            topVO.setDailyMny(ComputeUtil.safeAdd(topVO.getDailyMny(), lowerVO.getDailyMny()));
            topVO.setYearMny(ComputeUtil.safeAdd(topVO.getYearMny(), lowerVO.getYearMny()));
            topVO.setSumMny(ComputeUtil.safeAdd(topVO.getSumMny(), lowerVO.getSumMny()));

            lowerVO.setSumPipeNum(ComputeUtil.safeSub(lowerVO.getSumPipeInNum(), lowerVO.getSumPipeOutNum()));
            lowerVO.setPipeRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(lowerVO.getSumPipePcNum(), lowerVO.getSumPipeInNum()), BigDecimal.valueOf(100)));
            topVO.setSumPipeInNum(ComputeUtil.safeAdd(topVO.getSumPipeInNum(), lowerVO.getSumPipeInNum()));
            topVO.setSumPipeOutNum(ComputeUtil.safeAdd(topVO.getSumPipeOutNum(), lowerVO.getSumPipeOutNum()));
            topVO.setSumPipePcNum(ComputeUtil.safeAdd(topVO.getSumPipePcNum(), lowerVO.getSumPipePcNum()));

            lowerVO.setSumClampNum(ComputeUtil.safeSub(lowerVO.getSumClampInNum(), lowerVO.getSumClampOutNum()));
            lowerVO.setClampRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(lowerVO.getSumClampPcNum(), lowerVO.getSumClampInNum()), BigDecimal.valueOf(100)));
            topVO.setSumClampInNum(ComputeUtil.safeAdd(topVO.getSumClampInNum(), lowerVO.getSumClampInNum()));
            topVO.setSumClampOutNum(ComputeUtil.safeAdd(topVO.getSumClampOutNum(), lowerVO.getSumClampOutNum()));
            topVO.setSumClampPcNum(ComputeUtil.safeAdd(topVO.getSumClampPcNum(), lowerVO.getSumClampPcNum()));

            lowerVO.setSumLunkNum(ComputeUtil.safeSub(lowerVO.getSumLunkInNum(), lowerVO.getSumLunkOutNum()));
            topVO.setSumLunkInNum(ComputeUtil.safeAdd(topVO.getSumLunkInNum(), lowerVO.getSumLunkInNum()));
            topVO.setSumLunkOutNum(ComputeUtil.safeAdd(topVO.getSumLunkOutNum(), lowerVO.getSumLunkOutNum()));
            topVO.setSumLunkPcNum(ComputeUtil.safeAdd(topVO.getSumLunkPcNum(), lowerVO.getSumLunkPcNum()));
        }

        topVO.setSumPipeNum(ComputeUtil.safeSub(topVO.getSumPipeInNum(), topVO.getSumPipeOutNum()));
        topVO.setPipeRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(topVO.getSumPipePcNum(), topVO.getSumPipeInNum()), BigDecimal.valueOf(100)));
        topVO.setSumClampNum(ComputeUtil.safeSub(topVO.getSumClampInNum(), topVO.getSumClampOutNum()));
        topVO.setClampRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(topVO.getSumClampPcNum(), topVO.getSumClampInNum()), BigDecimal.valueOf(100)));
        topVO.setSumLunkNum(ComputeUtil.safeSub(topVO.getSumLunkInNum(), topVO.getSumLunkOutNum()));

        List<ReportCorpLowerVO> lowerVOS = new ArrayList<>(detailMap.values());
        lowerVOS.sort(Comparator
                .comparingInt(ReportCorpLowerVO::getSequence));
        topVO.setLowerVOList(lowerVOS);
        return topVO;
    }


    @Override
    public List<JSONObject> qryDailyRise(Long orgId, String beginDate, String endDate) {
        boolean projFlag = null == orgId ? "5".equals(InvocationInfoProxy.getOrgType()) : "5".equals(String.valueOf(orgApi.getOneById(orgId).getData().getOrgType()));
        List<JSONObject> list = new ArrayList<>();
        Date fromDate = Date.from(LocalDate.parse(endDate.substring(0, 10)).minusDays(29).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List<Long> orgIdList = new ArrayList<>();
        if (projFlag) {
            orgIdList.add(orgId);
        } else {
            orgIdList = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }

        QueryWrapper<DailyEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL(sum(rent_mny),0) as rentMny, rent_date as rentDate");
        queryWrapper.between("rent_date", fromDate, endDate);
        queryWrapper.in("bill_state", "1,3");
        queryWrapper.in(!projFlag, "real_corp_id", orgIdList);
        queryWrapper.in(projFlag, "org_id", orgIdList);
        queryWrapper.groupBy("rent_date");
        List<DailyEntity> dailyEntities = dailyService.list(queryWrapper);
        Map<String, BigDecimal> map = new HashMap<>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (DailyEntity dailyEntity : dailyEntities) {
            map.put(dateFormat.format(dailyEntity.getRentDate()), dailyEntity.getRentMny());
        }
        LocalDate currentDate = LocalDate.parse(endDate.substring(0, 10));
        for (int i = 30; i > 1; i--) {
            String date = dateFormat.format(Date.from(currentDate.minusDays(i - 1).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", date);
            jsonObject.put("value", map.get(date));
            list.add(jsonObject);
        }
        return list;
    }

    @Override
    public JSONObject qryRentMnyDistribution(Long orgId, String beginDate, String endDate) {
        boolean projFlag = null == orgId ? "5".equals(InvocationInfoProxy.getOrgType()) : "5".equals(String.valueOf(orgApi.getOneById(orgId).getData().getOrgType()));
        JSONObject jsonObject = new JSONObject();
        List<Long> orgIdList = new ArrayList<>();
        if (projFlag) {
            orgIdList.add(orgId);
        } else {
            orgIdList = orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        LambdaQueryWrapper<CalculateEntity> query = new LambdaQueryWrapper<>();
        query.ge(StringUtils.isNotBlank(beginDate), CalculateEntity::getRentDate, beginDate);
        query.le(StringUtils.isNotBlank(endDate), CalculateEntity::getRentDate, endDate);
        query.in(CalculateEntity::getBillState, "1,3");
        query.in(!projFlag, CalculateEntity::getRealCorpId, orgIdList);
        query.in(projFlag, CalculateEntity::getOrgId, orgIdList);
        List<CalculateEntity> calcList = calculateService.list(query);
        BigDecimal pipe = null;
        BigDecimal clamp = null;
        BigDecimal lunk = null;
        BigDecimal other = null;
        if (CollectionUtils.isNotEmpty(calcList)) {
            List<Long> calcIdList = calcList.stream().map(CalculateEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<CalculateDailyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.isNotNull(CalculateDailyEntity::getMaterialTypeId);
            queryWrapper.in(CalculateDailyEntity::getCalculateId, calcIdList);
            List<CalculateDailyEntity> dailyEntities = calculateDailyService.list(queryWrapper);
            //查询架管的子分类，写死主键
            CommonResponse<List<MaterialCategoryVO>> pipeResponse = materialApi.queryCategoryListByPid(Long.valueOf("1328902423640543234"));
            Set<Long> pipeCtySet = pipeResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toSet());
            //查询扣件的子分类，写死主键
            CommonResponse<List<MaterialCategoryVO>> clampResponse = materialApi.queryCategoryListByPid(Long.valueOf("1328902425322459138"));
            Set<Long> clampCtySet = clampResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toSet());
            //查询轮扣的子分类，写死主键
            CommonResponse<List<MaterialCategoryVO>> koujResponse = materialApi.queryCategoryListByPid(Long.valueOf("1328902426949849089"));
            Set<Long> koujCtySet = koujResponse.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toSet());
            for (CalculateDailyEntity dailyEntity : dailyEntities) {
                Long materialTypeId = dailyEntity.getMaterialTypeId();
                if (pipeCtySet.contains(materialTypeId)) {
                    pipe = ComputeUtil.safeAdd(pipe, dailyEntity.getDailyRentMny());
                } else if (clampCtySet.contains(materialTypeId)) {
                    clamp = ComputeUtil.safeAdd(clamp, dailyEntity.getDailyRentMny());
                } else if (koujCtySet.contains(materialTypeId)) {
                    lunk = ComputeUtil.safeAdd(lunk, dailyEntity.getDailyRentMny());
                } else {
                    other = ComputeUtil.safeAdd(other, dailyEntity.getDailyRentMny());
                }
            }
        }
        jsonObject.put("pipe", ComputeUtil.safeDiv(pipe, BigDecimal.valueOf(10000)));
        jsonObject.put("clamp", ComputeUtil.safeDiv(clamp, BigDecimal.valueOf(10000)));
        jsonObject.put("lunk", ComputeUtil.safeDiv(lunk, BigDecimal.valueOf(10000)));
        jsonObject.put("other", ComputeUtil.safeDiv(other, BigDecimal.valueOf(10000)));
        return jsonObject;
    }

    @Override
    public List<JSONObject> qryMonthRise(Long orgId, String beginDate, String endDate) {
        if(null == orgId){
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<JSONObject> list = new ArrayList<>();
        String fromDate =  LocalDate.parse(endDate.substring(0, 10)).minusMonths(12).format(DateTimeFormatter.ofPattern("yyyy-MM")) + "-01 00:00:00";

        QueryWrapper<DailyEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.between("rent_date", fromDate, endDate);
        queryWrapper.in("bill_state", "1,3");
        queryWrapper.eq("org_id", orgId);
        queryWrapper.orderByAsc("rent_date");
        List<DailyEntity> dailyEntities = dailyService.list(queryWrapper);
        Map<String, BigDecimal> map = new LinkedHashMap<>();
        for (DailyEntity dailyEntity : dailyEntities) {
            String key = new SimpleDateFormat("yyyy-MM").format(dailyEntity.getRentDate());
            BigDecimal mny = map.containsKey(key) ? map.get(key) : BigDecimal.ZERO;
            mny = ComputeUtil.safeAdd(mny, dailyEntity.getRentMny());
            map.put(key, mny);
        }
        for (String key : map.keySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", key);
            jsonObject.put("value", map.get(key));
            list.add(jsonObject);
        }
        return list;
    }

}
