package com.ejianc.business.rmat.util;

import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class CmContractUtil {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICmContractInfoApi infoApi;

    /**
     * 查询NC合同详情
     * @param pkContract
     * @return
     */
    public Map<Long, CmContractInfoVO> getInfoMap(String pkContract) {
        CommonResponse<List<CmContractInfoVO>> response =  infoApi.queryLeaseContractInfoById(pkContract);
        if(!response.isSuccess()){
            logger.error(response.getMsg());
        }
        List<CmContractInfoVO> infoList = new ArrayList<>();
        if(response.isSuccess()){
            infoList = response.getData();
        }
        Map<Long, CmContractInfoVO> infoMap = infoList.stream().collect(Collectors.toMap(
                x->x.getMaterialId() != null ? x.getMaterialId() : x.getMaterialTypeId(), x->x, (key1, key2) -> key1));
        return infoMap;
    }

    /**
     * 根据物料主键或者物料分类主键获取对应NC合同清单，并赋值
     * @param infoMap
     * @param materialId
     * @param materialTypeId
     * @return
     */
    public CmContractInfoVO getInfoVO(Map<Long, CmContractInfoVO> infoMap, Long materialId, Long materialTypeId, PriceFlowVO vo) {
        CmContractInfoVO infoVO = null;
        if(infoMap.containsKey(materialId)){
            infoVO = infoMap.get(materialId);
        } else if(infoMap.containsKey(materialTypeId)){
            infoVO = infoMap.get(materialTypeId);
        }
        if(infoVO != null){
            vo.setInfoId(StringUtils.isNotEmpty(vo.getInfoId()) ? vo.getInfoId() : infoVO.getPkContractinfo());
        }
        return infoVO;
    }

    /**
     * 根据物料主键或者物料分类主键获取对应NC合同清单，并赋值
     * @param infoMap
     * @param materialId
     * @param materialTypeId
     * @return
     */
    public CmContractInfoVO getInfoVO(Map<Long, CmContractInfoVO> infoMap, Long materialId, Long materialTypeId, RmatFlowVO vo) {
        CmContractInfoVO infoVO = null;
        if(infoMap.containsKey(materialId)){
            infoVO = infoMap.get(materialId);
            vo.setSignRowType(vo.getSignRowType() != null ? vo.getSignRowType() : 2);// 合同签订方式
        } else if(infoMap.containsKey(materialTypeId)){
            infoVO = infoMap.get(materialTypeId);
            vo.setSignRowType(vo.getSignRowType() != null ? vo.getSignRowType() : 1);// 合同签订方式
        }
        if(infoVO != null){
            vo.setInfoId(StringUtils.isNotEmpty(vo.getInfoId()) ? vo.getInfoId() : infoVO.getPkContractinfo());
        }
        return infoVO;
    }
}
